// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * Describes a configuration for a custom domain.
 */
public class DomainNameConfig private constructor(builder: Builder) {
    /**
     * The domain name that AppSync provides.
     */
    public val appsyncDomainName: kotlin.String? = builder.appsyncDomainName
    /**
     * The Amazon Resource Name (ARN) of the certificate. This can be an Certificate Manager (ACM) certificate or an Identity and Access Management (IAM) server certificate.
     */
    public val certificateArn: kotlin.String? = builder.certificateArn
    /**
     * A description of the `DomainName` configuration.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The domain name.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * The ID of your Amazon Route 53 hosted zone.
     */
    public val hostedZoneId: kotlin.String? = builder.hostedZoneId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.DomainNameConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DomainNameConfig(")
        append("appsyncDomainName=$appsyncDomainName,")
        append("certificateArn=$certificateArn,")
        append("description=$description,")
        append("domainName=$domainName,")
        append("hostedZoneId=$hostedZoneId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appsyncDomainName?.hashCode() ?: 0
        result = 31 * result + (certificateArn?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (hostedZoneId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DomainNameConfig

        if (appsyncDomainName != other.appsyncDomainName) return false
        if (certificateArn != other.certificateArn) return false
        if (description != other.description) return false
        if (domainName != other.domainName) return false
        if (hostedZoneId != other.hostedZoneId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.DomainNameConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The domain name that AppSync provides.
         */
        public var appsyncDomainName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the certificate. This can be an Certificate Manager (ACM) certificate or an Identity and Access Management (IAM) server certificate.
         */
        public var certificateArn: kotlin.String? = null
        /**
         * A description of the `DomainName` configuration.
         */
        public var description: kotlin.String? = null
        /**
         * The domain name.
         */
        public var domainName: kotlin.String? = null
        /**
         * The ID of your Amazon Route 53 hosted zone.
         */
        public var hostedZoneId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.DomainNameConfig) : this() {
            this.appsyncDomainName = x.appsyncDomainName
            this.certificateArn = x.certificateArn
            this.description = x.description
            this.domainName = x.domainName
            this.hostedZoneId = x.hostedZoneId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.DomainNameConfig = DomainNameConfig(this)
    }
}
