// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



public class CreateFunctionRequest private constructor(builder: Builder) {
    /**
     * The GraphQL API ID.
     */
    public val apiId: kotlin.String? = requireNotNull(builder.apiId) { "A non-null value must be provided for apiId" }
    /**
     * The `function` code that contains the request and response functions. When code is used, the `runtime` is required. The `runtime` value must be `APPSYNC_JS`.
     */
    public val code: kotlin.String? = builder.code
    /**
     * The `Function``DataSource` name.
     */
    public val dataSourceName: kotlin.String? = builder.dataSourceName
    /**
     * The `Function` description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The `version` of the request mapping template. Currently, the supported value is 2018-05-29. Note that when using VTL and mapping templates, the `functionVersion` is required.
     */
    public val functionVersion: kotlin.String? = builder.functionVersion
    /**
     * The maximum batching size for a resolver.
     */
    public val maxBatchSize: kotlin.Int = builder.maxBatchSize
    /**
     * The `Function` name. The function name does not have to be unique.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The `Function` request mapping template. Functions support only the 2018-05-29 version of the request mapping template.
     */
    public val requestMappingTemplate: kotlin.String? = builder.requestMappingTemplate
    /**
     * The `Function` response mapping template.
     */
    public val responseMappingTemplate: kotlin.String? = builder.responseMappingTemplate
    /**
     * Describes a runtime used by an Amazon Web Services AppSync pipeline resolver or Amazon Web Services AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
     */
    public val runtime: aws.sdk.kotlin.services.appsync.model.AppSyncRuntime? = builder.runtime
    /**
     * Describes a Sync configuration for a resolver.
     *
     * Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
     */
    public val syncConfig: aws.sdk.kotlin.services.appsync.model.SyncConfig? = builder.syncConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.CreateFunctionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFunctionRequest(")
        append("apiId=$apiId,")
        append("code=$code,")
        append("dataSourceName=$dataSourceName,")
        append("description=$description,")
        append("functionVersion=$functionVersion,")
        append("maxBatchSize=$maxBatchSize,")
        append("name=$name,")
        append("requestMappingTemplate=$requestMappingTemplate,")
        append("responseMappingTemplate=$responseMappingTemplate,")
        append("runtime=$runtime,")
        append("syncConfig=$syncConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiId?.hashCode() ?: 0
        result = 31 * result + (code?.hashCode() ?: 0)
        result = 31 * result + (dataSourceName?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (functionVersion?.hashCode() ?: 0)
        result = 31 * result + (maxBatchSize)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (requestMappingTemplate?.hashCode() ?: 0)
        result = 31 * result + (responseMappingTemplate?.hashCode() ?: 0)
        result = 31 * result + (runtime?.hashCode() ?: 0)
        result = 31 * result + (syncConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFunctionRequest

        if (apiId != other.apiId) return false
        if (code != other.code) return false
        if (dataSourceName != other.dataSourceName) return false
        if (description != other.description) return false
        if (functionVersion != other.functionVersion) return false
        if (maxBatchSize != other.maxBatchSize) return false
        if (name != other.name) return false
        if (requestMappingTemplate != other.requestMappingTemplate) return false
        if (responseMappingTemplate != other.responseMappingTemplate) return false
        if (runtime != other.runtime) return false
        if (syncConfig != other.syncConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.CreateFunctionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The GraphQL API ID.
         */
        public var apiId: kotlin.String? = null
        /**
         * The `function` code that contains the request and response functions. When code is used, the `runtime` is required. The `runtime` value must be `APPSYNC_JS`.
         */
        public var code: kotlin.String? = null
        /**
         * The `Function``DataSource` name.
         */
        public var dataSourceName: kotlin.String? = null
        /**
         * The `Function` description.
         */
        public var description: kotlin.String? = null
        /**
         * The `version` of the request mapping template. Currently, the supported value is 2018-05-29. Note that when using VTL and mapping templates, the `functionVersion` is required.
         */
        public var functionVersion: kotlin.String? = null
        /**
         * The maximum batching size for a resolver.
         */
        public var maxBatchSize: kotlin.Int = 0
        /**
         * The `Function` name. The function name does not have to be unique.
         */
        public var name: kotlin.String? = null
        /**
         * The `Function` request mapping template. Functions support only the 2018-05-29 version of the request mapping template.
         */
        public var requestMappingTemplate: kotlin.String? = null
        /**
         * The `Function` response mapping template.
         */
        public var responseMappingTemplate: kotlin.String? = null
        /**
         * Describes a runtime used by an Amazon Web Services AppSync pipeline resolver or Amazon Web Services AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
         */
        public var runtime: aws.sdk.kotlin.services.appsync.model.AppSyncRuntime? = null
        /**
         * Describes a Sync configuration for a resolver.
         *
         * Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
         */
        public var syncConfig: aws.sdk.kotlin.services.appsync.model.SyncConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.CreateFunctionRequest) : this() {
            this.apiId = x.apiId
            this.code = x.code
            this.dataSourceName = x.dataSourceName
            this.description = x.description
            this.functionVersion = x.functionVersion
            this.maxBatchSize = x.maxBatchSize
            this.name = x.name
            this.requestMappingTemplate = x.requestMappingTemplate
            this.responseMappingTemplate = x.responseMappingTemplate
            this.runtime = x.runtime
            this.syncConfig = x.syncConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.CreateFunctionRequest = CreateFunctionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.AppSyncRuntime] inside the given [block]
         */
        public fun runtime(block: aws.sdk.kotlin.services.appsync.model.AppSyncRuntime.Builder.() -> kotlin.Unit) {
            this.runtime = aws.sdk.kotlin.services.appsync.model.AppSyncRuntime.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.SyncConfig] inside the given [block]
         */
        public fun syncConfig(block: aws.sdk.kotlin.services.appsync.model.SyncConfig.Builder.() -> kotlin.Unit) {
            this.syncConfig = aws.sdk.kotlin.services.appsync.model.SyncConfig.invoke(block)
        }
    }
}
