// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.appsync.endpoints.internal.ResolveEndpoint
import aws.sdk.kotlin.services.appsync.endpoints.internal.bindAwsBuiltins
import aws.sdk.kotlin.services.appsync.model.*
import aws.sdk.kotlin.services.appsync.model.AssociateApiRequest
import aws.sdk.kotlin.services.appsync.model.CreateApiCacheRequest
import aws.sdk.kotlin.services.appsync.model.CreateApiKeyRequest
import aws.sdk.kotlin.services.appsync.model.CreateDataSourceRequest
import aws.sdk.kotlin.services.appsync.model.CreateDomainNameRequest
import aws.sdk.kotlin.services.appsync.model.CreateFunctionRequest
import aws.sdk.kotlin.services.appsync.model.CreateGraphqlApiRequest
import aws.sdk.kotlin.services.appsync.model.CreateResolverRequest
import aws.sdk.kotlin.services.appsync.model.CreateTypeRequest
import aws.sdk.kotlin.services.appsync.model.DeleteApiCacheRequest
import aws.sdk.kotlin.services.appsync.model.DeleteApiKeyRequest
import aws.sdk.kotlin.services.appsync.model.DeleteDataSourceRequest
import aws.sdk.kotlin.services.appsync.model.DeleteDomainNameRequest
import aws.sdk.kotlin.services.appsync.model.DeleteFunctionRequest
import aws.sdk.kotlin.services.appsync.model.DeleteGraphqlApiRequest
import aws.sdk.kotlin.services.appsync.model.DeleteResolverRequest
import aws.sdk.kotlin.services.appsync.model.DeleteTypeRequest
import aws.sdk.kotlin.services.appsync.model.DisassociateApiRequest
import aws.sdk.kotlin.services.appsync.model.EvaluateCodeRequest
import aws.sdk.kotlin.services.appsync.model.EvaluateMappingTemplateRequest
import aws.sdk.kotlin.services.appsync.model.FlushApiCacheRequest
import aws.sdk.kotlin.services.appsync.model.GetApiAssociationRequest
import aws.sdk.kotlin.services.appsync.model.GetApiCacheRequest
import aws.sdk.kotlin.services.appsync.model.GetDataSourceRequest
import aws.sdk.kotlin.services.appsync.model.GetDomainNameRequest
import aws.sdk.kotlin.services.appsync.model.GetFunctionRequest
import aws.sdk.kotlin.services.appsync.model.GetGraphqlApiRequest
import aws.sdk.kotlin.services.appsync.model.GetIntrospectionSchemaRequest
import aws.sdk.kotlin.services.appsync.model.GetResolverRequest
import aws.sdk.kotlin.services.appsync.model.GetSchemaCreationStatusRequest
import aws.sdk.kotlin.services.appsync.model.GetTypeRequest
import aws.sdk.kotlin.services.appsync.model.ListApiKeysRequest
import aws.sdk.kotlin.services.appsync.model.ListDataSourcesRequest
import aws.sdk.kotlin.services.appsync.model.ListDomainNamesRequest
import aws.sdk.kotlin.services.appsync.model.ListFunctionsRequest
import aws.sdk.kotlin.services.appsync.model.ListGraphqlApisRequest
import aws.sdk.kotlin.services.appsync.model.ListResolversByFunctionRequest
import aws.sdk.kotlin.services.appsync.model.ListResolversRequest
import aws.sdk.kotlin.services.appsync.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.appsync.model.ListTypesRequest
import aws.sdk.kotlin.services.appsync.model.StartSchemaCreationRequest
import aws.sdk.kotlin.services.appsync.model.TagResourceRequest
import aws.sdk.kotlin.services.appsync.model.UntagResourceRequest
import aws.sdk.kotlin.services.appsync.model.UpdateApiCacheRequest
import aws.sdk.kotlin.services.appsync.model.UpdateApiKeyRequest
import aws.sdk.kotlin.services.appsync.model.UpdateDataSourceRequest
import aws.sdk.kotlin.services.appsync.model.UpdateDomainNameRequest
import aws.sdk.kotlin.services.appsync.model.UpdateFunctionRequest
import aws.sdk.kotlin.services.appsync.model.UpdateGraphqlApiRequest
import aws.sdk.kotlin.services.appsync.model.UpdateResolverRequest
import aws.sdk.kotlin.services.appsync.model.UpdateTypeRequest
import aws.sdk.kotlin.services.appsync.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsHttpSigner
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "AppSync"
public const val ServiceApiVersion: String = "2017-07-25"
public const val SdkVersion: String = "0.20.3-beta"

internal class DefaultAppSyncClient(override val config: AppSyncClient.Config) : AppSyncClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClientEngine)

    init {
        managedResources.addIfManaged(config.httpClientEngine)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Maps an endpoint to your custom domain.
     */
    override suspend fun associateApi(input: AssociateApiRequest): AssociateApiResponse {
        val op = SdkHttpOperation.build<AssociateApiRequest, AssociateApiResponse> {
            serializer = AssociateApiOperationSerializer()
            deserializer = AssociateApiOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateApi"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<AssociateApiRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AssociateApi-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a cache for the GraphQL API.
     */
    override suspend fun createApiCache(input: CreateApiCacheRequest): CreateApiCacheResponse {
        val op = SdkHttpOperation.build<CreateApiCacheRequest, CreateApiCacheResponse> {
            serializer = CreateApiCacheOperationSerializer()
            deserializer = CreateApiCacheOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateApiCache"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateApiCacheRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateApiCache-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a unique key that you can distribute to clients who invoke your API.
     */
    override suspend fun createApiKey(input: CreateApiKeyRequest): CreateApiKeyResponse {
        val op = SdkHttpOperation.build<CreateApiKeyRequest, CreateApiKeyResponse> {
            serializer = CreateApiKeyOperationSerializer()
            deserializer = CreateApiKeyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateApiKey"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateApiKeyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateApiKey-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a `DataSource` object.
     */
    override suspend fun createDataSource(input: CreateDataSourceRequest): CreateDataSourceResponse {
        val op = SdkHttpOperation.build<CreateDataSourceRequest, CreateDataSourceResponse> {
            serializer = CreateDataSourceOperationSerializer()
            deserializer = CreateDataSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDataSource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateDataSourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateDataSource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a custom `DomainName` object.
     */
    override suspend fun createDomainName(input: CreateDomainNameRequest): CreateDomainNameResponse {
        val op = SdkHttpOperation.build<CreateDomainNameRequest, CreateDomainNameResponse> {
            serializer = CreateDomainNameOperationSerializer()
            deserializer = CreateDomainNameOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDomainName"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateDomainNameRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateDomainName-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a `Function` object.
     *
     * A function is a reusable entity. You can use multiple functions to compose the resolver logic.
     */
    override suspend fun createFunction(input: CreateFunctionRequest): CreateFunctionResponse {
        val op = SdkHttpOperation.build<CreateFunctionRequest, CreateFunctionResponse> {
            serializer = CreateFunctionOperationSerializer()
            deserializer = CreateFunctionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateFunction"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateFunctionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateFunction-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a `GraphqlApi` object.
     */
    override suspend fun createGraphqlApi(input: CreateGraphqlApiRequest): CreateGraphqlApiResponse {
        val op = SdkHttpOperation.build<CreateGraphqlApiRequest, CreateGraphqlApiResponse> {
            serializer = CreateGraphqlApiOperationSerializer()
            deserializer = CreateGraphqlApiOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateGraphqlApi"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateGraphqlApiRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateGraphqlApi-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a `Resolver` object.
     *
     * A resolver converts incoming requests into a format that a data source can understand, and converts the data source's responses into GraphQL.
     */
    override suspend fun createResolver(input: CreateResolverRequest): CreateResolverResponse {
        val op = SdkHttpOperation.build<CreateResolverRequest, CreateResolverResponse> {
            serializer = CreateResolverOperationSerializer()
            deserializer = CreateResolverOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateResolver"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateResolverRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateResolver-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a `Type` object.
     */
    override suspend fun createType(input: CreateTypeRequest): CreateTypeResponse {
        val op = SdkHttpOperation.build<CreateTypeRequest, CreateTypeResponse> {
            serializer = CreateTypeOperationSerializer()
            deserializer = CreateTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateType"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateTypeRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateType-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an `ApiCache` object.
     */
    override suspend fun deleteApiCache(input: DeleteApiCacheRequest): DeleteApiCacheResponse {
        val op = SdkHttpOperation.build<DeleteApiCacheRequest, DeleteApiCacheResponse> {
            serializer = DeleteApiCacheOperationSerializer()
            deserializer = DeleteApiCacheOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteApiCache"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteApiCacheRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteApiCache-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an API key.
     */
    override suspend fun deleteApiKey(input: DeleteApiKeyRequest): DeleteApiKeyResponse {
        val op = SdkHttpOperation.build<DeleteApiKeyRequest, DeleteApiKeyResponse> {
            serializer = DeleteApiKeyOperationSerializer()
            deserializer = DeleteApiKeyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteApiKey"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteApiKeyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteApiKey-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a `DataSource` object.
     */
    override suspend fun deleteDataSource(input: DeleteDataSourceRequest): DeleteDataSourceResponse {
        val op = SdkHttpOperation.build<DeleteDataSourceRequest, DeleteDataSourceResponse> {
            serializer = DeleteDataSourceOperationSerializer()
            deserializer = DeleteDataSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDataSource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteDataSourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteDataSource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a custom `DomainName` object.
     */
    override suspend fun deleteDomainName(input: DeleteDomainNameRequest): DeleteDomainNameResponse {
        val op = SdkHttpOperation.build<DeleteDomainNameRequest, DeleteDomainNameResponse> {
            serializer = DeleteDomainNameOperationSerializer()
            deserializer = DeleteDomainNameOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDomainName"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteDomainNameRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteDomainName-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a `Function`.
     */
    override suspend fun deleteFunction(input: DeleteFunctionRequest): DeleteFunctionResponse {
        val op = SdkHttpOperation.build<DeleteFunctionRequest, DeleteFunctionResponse> {
            serializer = DeleteFunctionOperationSerializer()
            deserializer = DeleteFunctionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteFunction"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteFunctionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteFunction-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a `GraphqlApi` object.
     */
    override suspend fun deleteGraphqlApi(input: DeleteGraphqlApiRequest): DeleteGraphqlApiResponse {
        val op = SdkHttpOperation.build<DeleteGraphqlApiRequest, DeleteGraphqlApiResponse> {
            serializer = DeleteGraphqlApiOperationSerializer()
            deserializer = DeleteGraphqlApiOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteGraphqlApi"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteGraphqlApiRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteGraphqlApi-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a `Resolver` object.
     */
    override suspend fun deleteResolver(input: DeleteResolverRequest): DeleteResolverResponse {
        val op = SdkHttpOperation.build<DeleteResolverRequest, DeleteResolverResponse> {
            serializer = DeleteResolverOperationSerializer()
            deserializer = DeleteResolverOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteResolver"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteResolverRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteResolver-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a `Type` object.
     */
    override suspend fun deleteType(input: DeleteTypeRequest): DeleteTypeResponse {
        val op = SdkHttpOperation.build<DeleteTypeRequest, DeleteTypeResponse> {
            serializer = DeleteTypeOperationSerializer()
            deserializer = DeleteTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteType"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteTypeRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteType-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes an `ApiAssociation` object from a custom domain.
     */
    override suspend fun disassociateApi(input: DisassociateApiRequest): DisassociateApiResponse {
        val op = SdkHttpOperation.build<DisassociateApiRequest, DisassociateApiResponse> {
            serializer = DisassociateApiOperationSerializer()
            deserializer = DisassociateApiOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateApi"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DisassociateApiRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DisassociateApi-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Evaluates the given code and returns the response. The code definition requirements depend on the specified runtime. For `APPSYNC_JS` runtimes, the code defines the request and response functions. The request function takes the incoming request after a GraphQL operation is parsed and converts it into a request configuration for the selected data source operation. The response function interprets responses from the data source and maps it to the shape of the GraphQL field output type.
     */
    override suspend fun evaluateCode(input: EvaluateCodeRequest): EvaluateCodeResponse {
        val op = SdkHttpOperation.build<EvaluateCodeRequest, EvaluateCodeResponse> {
            serializer = EvaluateCodeOperationSerializer()
            deserializer = EvaluateCodeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EvaluateCode"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<EvaluateCodeRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("EvaluateCode-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Evaluates a given template and returns the response. The mapping template can be a request or response template.
     *
     * Request templates take the incoming request after a GraphQL operation is parsed and convert it into a request configuration for the selected data source operation. Response templates interpret responses from the data source and map it to the shape of the GraphQL field output type.
     *
     * Mapping templates are written in the Apache Velocity Template Language (VTL).
     */
    override suspend fun evaluateMappingTemplate(input: EvaluateMappingTemplateRequest): EvaluateMappingTemplateResponse {
        val op = SdkHttpOperation.build<EvaluateMappingTemplateRequest, EvaluateMappingTemplateResponse> {
            serializer = EvaluateMappingTemplateOperationSerializer()
            deserializer = EvaluateMappingTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EvaluateMappingTemplate"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<EvaluateMappingTemplateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("EvaluateMappingTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Flushes an `ApiCache` object.
     */
    override suspend fun flushApiCache(input: FlushApiCacheRequest): FlushApiCacheResponse {
        val op = SdkHttpOperation.build<FlushApiCacheRequest, FlushApiCacheResponse> {
            serializer = FlushApiCacheOperationSerializer()
            deserializer = FlushApiCacheOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "FlushApiCache"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<FlushApiCacheRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("FlushApiCache-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves an `ApiAssociation` object.
     */
    override suspend fun getApiAssociation(input: GetApiAssociationRequest): GetApiAssociationResponse {
        val op = SdkHttpOperation.build<GetApiAssociationRequest, GetApiAssociationResponse> {
            serializer = GetApiAssociationOperationSerializer()
            deserializer = GetApiAssociationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetApiAssociation"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetApiAssociationRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetApiAssociation-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves an `ApiCache` object.
     */
    override suspend fun getApiCache(input: GetApiCacheRequest): GetApiCacheResponse {
        val op = SdkHttpOperation.build<GetApiCacheRequest, GetApiCacheResponse> {
            serializer = GetApiCacheOperationSerializer()
            deserializer = GetApiCacheOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetApiCache"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetApiCacheRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetApiCache-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves a `DataSource` object.
     */
    override suspend fun getDataSource(input: GetDataSourceRequest): GetDataSourceResponse {
        val op = SdkHttpOperation.build<GetDataSourceRequest, GetDataSourceResponse> {
            serializer = GetDataSourceOperationSerializer()
            deserializer = GetDataSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDataSource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetDataSourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetDataSource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves a custom `DomainName` object.
     */
    override suspend fun getDomainName(input: GetDomainNameRequest): GetDomainNameResponse {
        val op = SdkHttpOperation.build<GetDomainNameRequest, GetDomainNameResponse> {
            serializer = GetDomainNameOperationSerializer()
            deserializer = GetDomainNameOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDomainName"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetDomainNameRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetDomainName-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Get a `Function`.
     */
    override suspend fun getFunction(input: GetFunctionRequest): GetFunctionResponse {
        val op = SdkHttpOperation.build<GetFunctionRequest, GetFunctionResponse> {
            serializer = GetFunctionOperationSerializer()
            deserializer = GetFunctionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFunction"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetFunctionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetFunction-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves a `GraphqlApi` object.
     */
    override suspend fun getGraphqlApi(input: GetGraphqlApiRequest): GetGraphqlApiResponse {
        val op = SdkHttpOperation.build<GetGraphqlApiRequest, GetGraphqlApiResponse> {
            serializer = GetGraphqlApiOperationSerializer()
            deserializer = GetGraphqlApiOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetGraphqlApi"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetGraphqlApiRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetGraphqlApi-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the introspection schema for a GraphQL API.
     */
    override suspend fun getIntrospectionSchema(input: GetIntrospectionSchemaRequest): GetIntrospectionSchemaResponse {
        val op = SdkHttpOperation.build<GetIntrospectionSchemaRequest, GetIntrospectionSchemaResponse> {
            serializer = GetIntrospectionSchemaOperationSerializer()
            deserializer = GetIntrospectionSchemaOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetIntrospectionSchema"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetIntrospectionSchemaRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetIntrospectionSchema-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves a `Resolver` object.
     */
    override suspend fun getResolver(input: GetResolverRequest): GetResolverResponse {
        val op = SdkHttpOperation.build<GetResolverRequest, GetResolverResponse> {
            serializer = GetResolverOperationSerializer()
            deserializer = GetResolverOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetResolver"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetResolverRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetResolver-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the current status of a schema creation operation.
     */
    override suspend fun getSchemaCreationStatus(input: GetSchemaCreationStatusRequest): GetSchemaCreationStatusResponse {
        val op = SdkHttpOperation.build<GetSchemaCreationStatusRequest, GetSchemaCreationStatusResponse> {
            serializer = GetSchemaCreationStatusOperationSerializer()
            deserializer = GetSchemaCreationStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSchemaCreationStatus"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetSchemaCreationStatusRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetSchemaCreationStatus-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves a `Type` object.
     */
    override suspend fun getType(input: GetTypeRequest): GetTypeResponse {
        val op = SdkHttpOperation.build<GetTypeRequest, GetTypeResponse> {
            serializer = GetTypeOperationSerializer()
            deserializer = GetTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetType"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetTypeRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetType-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the API keys for a given API.
     *
     * API keys are deleted automatically 60 days after they expire. However, they may still be included in the response until they have actually been deleted. You can safely call `DeleteApiKey` to manually delete a key before it's automatically deleted.
     */
    override suspend fun listApiKeys(input: ListApiKeysRequest): ListApiKeysResponse {
        val op = SdkHttpOperation.build<ListApiKeysRequest, ListApiKeysResponse> {
            serializer = ListApiKeysOperationSerializer()
            deserializer = ListApiKeysOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListApiKeys"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListApiKeysRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListApiKeys-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the data sources for a given API.
     */
    override suspend fun listDataSources(input: ListDataSourcesRequest): ListDataSourcesResponse {
        val op = SdkHttpOperation.build<ListDataSourcesRequest, ListDataSourcesResponse> {
            serializer = ListDataSourcesOperationSerializer()
            deserializer = ListDataSourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDataSources"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListDataSourcesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListDataSources-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists multiple custom domain names.
     */
    override suspend fun listDomainNames(input: ListDomainNamesRequest): ListDomainNamesResponse {
        val op = SdkHttpOperation.build<ListDomainNamesRequest, ListDomainNamesResponse> {
            serializer = ListDomainNamesOperationSerializer()
            deserializer = ListDomainNamesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDomainNames"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListDomainNamesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListDomainNames-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List multiple functions.
     */
    override suspend fun listFunctions(input: ListFunctionsRequest): ListFunctionsResponse {
        val op = SdkHttpOperation.build<ListFunctionsRequest, ListFunctionsResponse> {
            serializer = ListFunctionsOperationSerializer()
            deserializer = ListFunctionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFunctions"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListFunctionsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListFunctions-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists your GraphQL APIs.
     */
    override suspend fun listGraphqlApis(input: ListGraphqlApisRequest): ListGraphqlApisResponse {
        val op = SdkHttpOperation.build<ListGraphqlApisRequest, ListGraphqlApisResponse> {
            serializer = ListGraphqlApisOperationSerializer()
            deserializer = ListGraphqlApisOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListGraphqlApis"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListGraphqlApisRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListGraphqlApis-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the resolvers for a given API and type.
     */
    override suspend fun listResolvers(input: ListResolversRequest): ListResolversResponse {
        val op = SdkHttpOperation.build<ListResolversRequest, ListResolversResponse> {
            serializer = ListResolversOperationSerializer()
            deserializer = ListResolversOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListResolvers"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListResolversRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListResolvers-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List the resolvers that are associated with a specific function.
     */
    override suspend fun listResolversByFunction(input: ListResolversByFunctionRequest): ListResolversByFunctionResponse {
        val op = SdkHttpOperation.build<ListResolversByFunctionRequest, ListResolversByFunctionResponse> {
            serializer = ListResolversByFunctionOperationSerializer()
            deserializer = ListResolversByFunctionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListResolversByFunction"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListResolversByFunctionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListResolversByFunction-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the tags for a resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListTagsForResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListTagsForResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the types for a given API.
     */
    override suspend fun listTypes(input: ListTypesRequest): ListTypesResponse {
        val op = SdkHttpOperation.build<ListTypesRequest, ListTypesResponse> {
            serializer = ListTypesOperationSerializer()
            deserializer = ListTypesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTypes"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListTypesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListTypes-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Adds a new schema to your GraphQL API.
     *
     * This operation is asynchronous. Use to determine when it has completed.
     */
    override suspend fun startSchemaCreation(input: StartSchemaCreationRequest): StartSchemaCreationResponse {
        val op = SdkHttpOperation.build<StartSchemaCreationRequest, StartSchemaCreationResponse> {
            serializer = StartSchemaCreationOperationSerializer()
            deserializer = StartSchemaCreationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartSchemaCreation"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<StartSchemaCreationRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartSchemaCreation-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Tags a resource with user-supplied tags.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<TagResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("TagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Untags a resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UntagResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UntagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the cache for the GraphQL API.
     */
    override suspend fun updateApiCache(input: UpdateApiCacheRequest): UpdateApiCacheResponse {
        val op = SdkHttpOperation.build<UpdateApiCacheRequest, UpdateApiCacheResponse> {
            serializer = UpdateApiCacheOperationSerializer()
            deserializer = UpdateApiCacheOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateApiCache"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateApiCacheRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateApiCache-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates an API key. You can update the key as long as it's not deleted.
     */
    override suspend fun updateApiKey(input: UpdateApiKeyRequest): UpdateApiKeyResponse {
        val op = SdkHttpOperation.build<UpdateApiKeyRequest, UpdateApiKeyResponse> {
            serializer = UpdateApiKeyOperationSerializer()
            deserializer = UpdateApiKeyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateApiKey"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateApiKeyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateApiKey-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates a `DataSource` object.
     */
    override suspend fun updateDataSource(input: UpdateDataSourceRequest): UpdateDataSourceResponse {
        val op = SdkHttpOperation.build<UpdateDataSourceRequest, UpdateDataSourceResponse> {
            serializer = UpdateDataSourceOperationSerializer()
            deserializer = UpdateDataSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDataSource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateDataSourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateDataSource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates a custom `DomainName` object.
     */
    override suspend fun updateDomainName(input: UpdateDomainNameRequest): UpdateDomainNameResponse {
        val op = SdkHttpOperation.build<UpdateDomainNameRequest, UpdateDomainNameResponse> {
            serializer = UpdateDomainNameOperationSerializer()
            deserializer = UpdateDomainNameOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDomainName"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateDomainNameRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateDomainName-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates a `Function` object.
     */
    override suspend fun updateFunction(input: UpdateFunctionRequest): UpdateFunctionResponse {
        val op = SdkHttpOperation.build<UpdateFunctionRequest, UpdateFunctionResponse> {
            serializer = UpdateFunctionOperationSerializer()
            deserializer = UpdateFunctionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateFunction"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateFunctionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateFunction-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates a `GraphqlApi` object.
     */
    override suspend fun updateGraphqlApi(input: UpdateGraphqlApiRequest): UpdateGraphqlApiResponse {
        val op = SdkHttpOperation.build<UpdateGraphqlApiRequest, UpdateGraphqlApiResponse> {
            serializer = UpdateGraphqlApiOperationSerializer()
            deserializer = UpdateGraphqlApiOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateGraphqlApi"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateGraphqlApiRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateGraphqlApi-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates a `Resolver` object.
     */
    override suspend fun updateResolver(input: UpdateResolverRequest): UpdateResolverResponse {
        val op = SdkHttpOperation.build<UpdateResolverRequest, UpdateResolverResponse> {
            serializer = UpdateResolverOperationSerializer()
            deserializer = UpdateResolverOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateResolver"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateResolverRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateResolver-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates a `Type` object.
     */
    override suspend fun updateType(input: UpdateTypeRequest): UpdateTypeResponse {
        val op = SdkHttpOperation.build<UpdateTypeRequest, UpdateTypeResponse> {
            serializer = UpdateTypeOperationSerializer()
            deserializer = UpdateTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateType"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateTypeRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "appsync"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateType-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "appsync")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
