// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.appsync.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.appsync.endpoints.EndpointProvider
import aws.sdk.kotlin.services.appsync.model.AssociateApiRequest
import aws.sdk.kotlin.services.appsync.model.AssociateApiResponse
import aws.sdk.kotlin.services.appsync.model.CreateApiCacheRequest
import aws.sdk.kotlin.services.appsync.model.CreateApiCacheResponse
import aws.sdk.kotlin.services.appsync.model.CreateApiKeyRequest
import aws.sdk.kotlin.services.appsync.model.CreateApiKeyResponse
import aws.sdk.kotlin.services.appsync.model.CreateDataSourceRequest
import aws.sdk.kotlin.services.appsync.model.CreateDataSourceResponse
import aws.sdk.kotlin.services.appsync.model.CreateDomainNameRequest
import aws.sdk.kotlin.services.appsync.model.CreateDomainNameResponse
import aws.sdk.kotlin.services.appsync.model.CreateFunctionRequest
import aws.sdk.kotlin.services.appsync.model.CreateFunctionResponse
import aws.sdk.kotlin.services.appsync.model.CreateGraphqlApiRequest
import aws.sdk.kotlin.services.appsync.model.CreateGraphqlApiResponse
import aws.sdk.kotlin.services.appsync.model.CreateResolverRequest
import aws.sdk.kotlin.services.appsync.model.CreateResolverResponse
import aws.sdk.kotlin.services.appsync.model.CreateTypeRequest
import aws.sdk.kotlin.services.appsync.model.CreateTypeResponse
import aws.sdk.kotlin.services.appsync.model.DeleteApiCacheRequest
import aws.sdk.kotlin.services.appsync.model.DeleteApiCacheResponse
import aws.sdk.kotlin.services.appsync.model.DeleteApiKeyRequest
import aws.sdk.kotlin.services.appsync.model.DeleteApiKeyResponse
import aws.sdk.kotlin.services.appsync.model.DeleteDataSourceRequest
import aws.sdk.kotlin.services.appsync.model.DeleteDataSourceResponse
import aws.sdk.kotlin.services.appsync.model.DeleteDomainNameRequest
import aws.sdk.kotlin.services.appsync.model.DeleteDomainNameResponse
import aws.sdk.kotlin.services.appsync.model.DeleteFunctionRequest
import aws.sdk.kotlin.services.appsync.model.DeleteFunctionResponse
import aws.sdk.kotlin.services.appsync.model.DeleteGraphqlApiRequest
import aws.sdk.kotlin.services.appsync.model.DeleteGraphqlApiResponse
import aws.sdk.kotlin.services.appsync.model.DeleteResolverRequest
import aws.sdk.kotlin.services.appsync.model.DeleteResolverResponse
import aws.sdk.kotlin.services.appsync.model.DeleteTypeRequest
import aws.sdk.kotlin.services.appsync.model.DeleteTypeResponse
import aws.sdk.kotlin.services.appsync.model.DisassociateApiRequest
import aws.sdk.kotlin.services.appsync.model.DisassociateApiResponse
import aws.sdk.kotlin.services.appsync.model.EvaluateCodeRequest
import aws.sdk.kotlin.services.appsync.model.EvaluateCodeResponse
import aws.sdk.kotlin.services.appsync.model.EvaluateMappingTemplateRequest
import aws.sdk.kotlin.services.appsync.model.EvaluateMappingTemplateResponse
import aws.sdk.kotlin.services.appsync.model.FlushApiCacheRequest
import aws.sdk.kotlin.services.appsync.model.FlushApiCacheResponse
import aws.sdk.kotlin.services.appsync.model.GetApiAssociationRequest
import aws.sdk.kotlin.services.appsync.model.GetApiAssociationResponse
import aws.sdk.kotlin.services.appsync.model.GetApiCacheRequest
import aws.sdk.kotlin.services.appsync.model.GetApiCacheResponse
import aws.sdk.kotlin.services.appsync.model.GetDataSourceRequest
import aws.sdk.kotlin.services.appsync.model.GetDataSourceResponse
import aws.sdk.kotlin.services.appsync.model.GetDomainNameRequest
import aws.sdk.kotlin.services.appsync.model.GetDomainNameResponse
import aws.sdk.kotlin.services.appsync.model.GetFunctionRequest
import aws.sdk.kotlin.services.appsync.model.GetFunctionResponse
import aws.sdk.kotlin.services.appsync.model.GetGraphqlApiRequest
import aws.sdk.kotlin.services.appsync.model.GetGraphqlApiResponse
import aws.sdk.kotlin.services.appsync.model.GetIntrospectionSchemaRequest
import aws.sdk.kotlin.services.appsync.model.GetIntrospectionSchemaResponse
import aws.sdk.kotlin.services.appsync.model.GetResolverRequest
import aws.sdk.kotlin.services.appsync.model.GetResolverResponse
import aws.sdk.kotlin.services.appsync.model.GetSchemaCreationStatusRequest
import aws.sdk.kotlin.services.appsync.model.GetSchemaCreationStatusResponse
import aws.sdk.kotlin.services.appsync.model.GetTypeRequest
import aws.sdk.kotlin.services.appsync.model.GetTypeResponse
import aws.sdk.kotlin.services.appsync.model.ListApiKeysRequest
import aws.sdk.kotlin.services.appsync.model.ListApiKeysResponse
import aws.sdk.kotlin.services.appsync.model.ListDataSourcesRequest
import aws.sdk.kotlin.services.appsync.model.ListDataSourcesResponse
import aws.sdk.kotlin.services.appsync.model.ListDomainNamesRequest
import aws.sdk.kotlin.services.appsync.model.ListDomainNamesResponse
import aws.sdk.kotlin.services.appsync.model.ListFunctionsRequest
import aws.sdk.kotlin.services.appsync.model.ListFunctionsResponse
import aws.sdk.kotlin.services.appsync.model.ListGraphqlApisRequest
import aws.sdk.kotlin.services.appsync.model.ListGraphqlApisResponse
import aws.sdk.kotlin.services.appsync.model.ListResolversByFunctionRequest
import aws.sdk.kotlin.services.appsync.model.ListResolversByFunctionResponse
import aws.sdk.kotlin.services.appsync.model.ListResolversRequest
import aws.sdk.kotlin.services.appsync.model.ListResolversResponse
import aws.sdk.kotlin.services.appsync.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.appsync.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.appsync.model.ListTypesRequest
import aws.sdk.kotlin.services.appsync.model.ListTypesResponse
import aws.sdk.kotlin.services.appsync.model.StartSchemaCreationRequest
import aws.sdk.kotlin.services.appsync.model.StartSchemaCreationResponse
import aws.sdk.kotlin.services.appsync.model.TagResourceRequest
import aws.sdk.kotlin.services.appsync.model.TagResourceResponse
import aws.sdk.kotlin.services.appsync.model.UntagResourceRequest
import aws.sdk.kotlin.services.appsync.model.UntagResourceResponse
import aws.sdk.kotlin.services.appsync.model.UpdateApiCacheRequest
import aws.sdk.kotlin.services.appsync.model.UpdateApiCacheResponse
import aws.sdk.kotlin.services.appsync.model.UpdateApiKeyRequest
import aws.sdk.kotlin.services.appsync.model.UpdateApiKeyResponse
import aws.sdk.kotlin.services.appsync.model.UpdateDataSourceRequest
import aws.sdk.kotlin.services.appsync.model.UpdateDataSourceResponse
import aws.sdk.kotlin.services.appsync.model.UpdateDomainNameRequest
import aws.sdk.kotlin.services.appsync.model.UpdateDomainNameResponse
import aws.sdk.kotlin.services.appsync.model.UpdateFunctionRequest
import aws.sdk.kotlin.services.appsync.model.UpdateFunctionResponse
import aws.sdk.kotlin.services.appsync.model.UpdateGraphqlApiRequest
import aws.sdk.kotlin.services.appsync.model.UpdateGraphqlApiResponse
import aws.sdk.kotlin.services.appsync.model.UpdateResolverRequest
import aws.sdk.kotlin.services.appsync.model.UpdateResolverResponse
import aws.sdk.kotlin.services.appsync.model.UpdateTypeRequest
import aws.sdk.kotlin.services.appsync.model.UpdateTypeResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.internal.manage
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig
import kotlin.collections.List
import kotlin.jvm.JvmStatic

/**
 * AppSync provides API actions for creating and interacting with data sources using GraphQL from your application.
 */
public interface AppSyncClient : SdkClient {

    override val serviceName: String
        get() = "AppSync"
    /**
     * AppSyncClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, AppSyncClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, AppSyncClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): AppSyncClient = DefaultAppSyncClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine = builder.httpClientEngine ?: DefaultHttpEngine().manage()
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "AppSync")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            httpClientEngine = this@Config.httpClientEngine
            region = this@Config.region
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            interceptors = this@Config.interceptors.toMutableList()
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            sdkLogMode = this@Config.sdkLogMode
            signer = this@Config.signer
            tracer = this@Config.tracer
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, HttpClientConfig.Builder, SdkClientConfig.Builder<Config>, TracingClientConfig.Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            override var httpClientEngine: HttpClientEngine? = null

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            override var retryStrategy: RetryStrategy? = null

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            override var tracer: Tracer? = null

            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false

            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Maps an endpoint to your custom domain.
     */
    public suspend fun associateApi(input: AssociateApiRequest): AssociateApiResponse

    /**
     * Creates a cache for the GraphQL API.
     */
    public suspend fun createApiCache(input: CreateApiCacheRequest): CreateApiCacheResponse

    /**
     * Creates a unique key that you can distribute to clients who invoke your API.
     */
    public suspend fun createApiKey(input: CreateApiKeyRequest): CreateApiKeyResponse

    /**
     * Creates a `DataSource` object.
     */
    public suspend fun createDataSource(input: CreateDataSourceRequest): CreateDataSourceResponse

    /**
     * Creates a custom `DomainName` object.
     */
    public suspend fun createDomainName(input: CreateDomainNameRequest): CreateDomainNameResponse

    /**
     * Creates a `Function` object.
     *
     * A function is a reusable entity. You can use multiple functions to compose the resolver logic.
     */
    public suspend fun createFunction(input: CreateFunctionRequest): CreateFunctionResponse

    /**
     * Creates a `GraphqlApi` object.
     */
    public suspend fun createGraphqlApi(input: CreateGraphqlApiRequest): CreateGraphqlApiResponse

    /**
     * Creates a `Resolver` object.
     *
     * A resolver converts incoming requests into a format that a data source can understand, and converts the data source's responses into GraphQL.
     */
    public suspend fun createResolver(input: CreateResolverRequest): CreateResolverResponse

    /**
     * Creates a `Type` object.
     */
    public suspend fun createType(input: CreateTypeRequest): CreateTypeResponse

    /**
     * Deletes an `ApiCache` object.
     */
    public suspend fun deleteApiCache(input: DeleteApiCacheRequest): DeleteApiCacheResponse

    /**
     * Deletes an API key.
     */
    public suspend fun deleteApiKey(input: DeleteApiKeyRequest): DeleteApiKeyResponse

    /**
     * Deletes a `DataSource` object.
     */
    public suspend fun deleteDataSource(input: DeleteDataSourceRequest): DeleteDataSourceResponse

    /**
     * Deletes a custom `DomainName` object.
     */
    public suspend fun deleteDomainName(input: DeleteDomainNameRequest): DeleteDomainNameResponse

    /**
     * Deletes a `Function`.
     */
    public suspend fun deleteFunction(input: DeleteFunctionRequest): DeleteFunctionResponse

    /**
     * Deletes a `GraphqlApi` object.
     */
    public suspend fun deleteGraphqlApi(input: DeleteGraphqlApiRequest): DeleteGraphqlApiResponse

    /**
     * Deletes a `Resolver` object.
     */
    public suspend fun deleteResolver(input: DeleteResolverRequest): DeleteResolverResponse

    /**
     * Deletes a `Type` object.
     */
    public suspend fun deleteType(input: DeleteTypeRequest): DeleteTypeResponse

    /**
     * Removes an `ApiAssociation` object from a custom domain.
     */
    public suspend fun disassociateApi(input: DisassociateApiRequest): DisassociateApiResponse

    /**
     * Evaluates the given code and returns the response. The code definition requirements depend on the specified runtime. For `APPSYNC_JS` runtimes, the code defines the request and response functions. The request function takes the incoming request after a GraphQL operation is parsed and converts it into a request configuration for the selected data source operation. The response function interprets responses from the data source and maps it to the shape of the GraphQL field output type.
     */
    public suspend fun evaluateCode(input: EvaluateCodeRequest): EvaluateCodeResponse

    /**
     * Evaluates a given template and returns the response. The mapping template can be a request or response template.
     *
     * Request templates take the incoming request after a GraphQL operation is parsed and convert it into a request configuration for the selected data source operation. Response templates interpret responses from the data source and map it to the shape of the GraphQL field output type.
     *
     * Mapping templates are written in the Apache Velocity Template Language (VTL).
     */
    public suspend fun evaluateMappingTemplate(input: EvaluateMappingTemplateRequest): EvaluateMappingTemplateResponse

    /**
     * Flushes an `ApiCache` object.
     */
    public suspend fun flushApiCache(input: FlushApiCacheRequest): FlushApiCacheResponse

    /**
     * Retrieves an `ApiAssociation` object.
     */
    public suspend fun getApiAssociation(input: GetApiAssociationRequest): GetApiAssociationResponse

    /**
     * Retrieves an `ApiCache` object.
     */
    public suspend fun getApiCache(input: GetApiCacheRequest): GetApiCacheResponse

    /**
     * Retrieves a `DataSource` object.
     */
    public suspend fun getDataSource(input: GetDataSourceRequest): GetDataSourceResponse

    /**
     * Retrieves a custom `DomainName` object.
     */
    public suspend fun getDomainName(input: GetDomainNameRequest): GetDomainNameResponse

    /**
     * Get a `Function`.
     */
    public suspend fun getFunction(input: GetFunctionRequest): GetFunctionResponse

    /**
     * Retrieves a `GraphqlApi` object.
     */
    public suspend fun getGraphqlApi(input: GetGraphqlApiRequest): GetGraphqlApiResponse

    /**
     * Retrieves the introspection schema for a GraphQL API.
     */
    public suspend fun getIntrospectionSchema(input: GetIntrospectionSchemaRequest): GetIntrospectionSchemaResponse

    /**
     * Retrieves a `Resolver` object.
     */
    public suspend fun getResolver(input: GetResolverRequest): GetResolverResponse

    /**
     * Retrieves the current status of a schema creation operation.
     */
    public suspend fun getSchemaCreationStatus(input: GetSchemaCreationStatusRequest): GetSchemaCreationStatusResponse

    /**
     * Retrieves a `Type` object.
     */
    public suspend fun getType(input: GetTypeRequest): GetTypeResponse

    /**
     * Lists the API keys for a given API.
     *
     * API keys are deleted automatically 60 days after they expire. However, they may still be included in the response until they have actually been deleted. You can safely call `DeleteApiKey` to manually delete a key before it's automatically deleted.
     */
    public suspend fun listApiKeys(input: ListApiKeysRequest): ListApiKeysResponse

    /**
     * Lists the data sources for a given API.
     */
    public suspend fun listDataSources(input: ListDataSourcesRequest): ListDataSourcesResponse

    /**
     * Lists multiple custom domain names.
     */
    public suspend fun listDomainNames(input: ListDomainNamesRequest = ListDomainNamesRequest {}): ListDomainNamesResponse

    /**
     * List multiple functions.
     */
    public suspend fun listFunctions(input: ListFunctionsRequest): ListFunctionsResponse

    /**
     * Lists your GraphQL APIs.
     */
    public suspend fun listGraphqlApis(input: ListGraphqlApisRequest = ListGraphqlApisRequest {}): ListGraphqlApisResponse

    /**
     * Lists the resolvers for a given API and type.
     */
    public suspend fun listResolvers(input: ListResolversRequest): ListResolversResponse

    /**
     * List the resolvers that are associated with a specific function.
     */
    public suspend fun listResolversByFunction(input: ListResolversByFunctionRequest): ListResolversByFunctionResponse

    /**
     * Lists the tags for a resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the types for a given API.
     */
    public suspend fun listTypes(input: ListTypesRequest): ListTypesResponse

    /**
     * Adds a new schema to your GraphQL API.
     *
     * This operation is asynchronous. Use to determine when it has completed.
     */
    public suspend fun startSchemaCreation(input: StartSchemaCreationRequest): StartSchemaCreationResponse

    /**
     * Tags a resource with user-supplied tags.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Untags a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the cache for the GraphQL API.
     */
    public suspend fun updateApiCache(input: UpdateApiCacheRequest): UpdateApiCacheResponse

    /**
     * Updates an API key. You can update the key as long as it's not deleted.
     */
    public suspend fun updateApiKey(input: UpdateApiKeyRequest): UpdateApiKeyResponse

    /**
     * Updates a `DataSource` object.
     */
    public suspend fun updateDataSource(input: UpdateDataSourceRequest): UpdateDataSourceResponse

    /**
     * Updates a custom `DomainName` object.
     */
    public suspend fun updateDomainName(input: UpdateDomainNameRequest): UpdateDomainNameResponse

    /**
     * Updates a `Function` object.
     */
    public suspend fun updateFunction(input: UpdateFunctionRequest): UpdateFunctionResponse

    /**
     * Updates a `GraphqlApi` object.
     */
    public suspend fun updateGraphqlApi(input: UpdateGraphqlApiRequest): UpdateGraphqlApiResponse

    /**
     * Updates a `Resolver` object.
     */
    public suspend fun updateResolver(input: UpdateResolverRequest): UpdateResolverResponse

    /**
     * Updates a `Type` object.
     */
    public suspend fun updateType(input: UpdateTypeRequest): UpdateTypeResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun AppSyncClient.withConfig(block: AppSyncClient.Config.Builder.() -> Unit): AppSyncClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultAppSyncClient(newConfig)
}

/**
 * Maps an endpoint to your custom domain.
 */
public suspend inline fun AppSyncClient.associateApi(crossinline block: AssociateApiRequest.Builder.() -> Unit): AssociateApiResponse = associateApi(AssociateApiRequest.Builder().apply(block).build())

/**
 * Creates a cache for the GraphQL API.
 */
public suspend inline fun AppSyncClient.createApiCache(crossinline block: CreateApiCacheRequest.Builder.() -> Unit): CreateApiCacheResponse = createApiCache(CreateApiCacheRequest.Builder().apply(block).build())

/**
 * Creates a unique key that you can distribute to clients who invoke your API.
 */
public suspend inline fun AppSyncClient.createApiKey(crossinline block: CreateApiKeyRequest.Builder.() -> Unit): CreateApiKeyResponse = createApiKey(CreateApiKeyRequest.Builder().apply(block).build())

/**
 * Creates a `DataSource` object.
 */
public suspend inline fun AppSyncClient.createDataSource(crossinline block: CreateDataSourceRequest.Builder.() -> Unit): CreateDataSourceResponse = createDataSource(CreateDataSourceRequest.Builder().apply(block).build())

/**
 * Creates a custom `DomainName` object.
 */
public suspend inline fun AppSyncClient.createDomainName(crossinline block: CreateDomainNameRequest.Builder.() -> Unit): CreateDomainNameResponse = createDomainName(CreateDomainNameRequest.Builder().apply(block).build())

/**
 * Creates a `Function` object.
 *
 * A function is a reusable entity. You can use multiple functions to compose the resolver logic.
 */
public suspend inline fun AppSyncClient.createFunction(crossinline block: CreateFunctionRequest.Builder.() -> Unit): CreateFunctionResponse = createFunction(CreateFunctionRequest.Builder().apply(block).build())

/**
 * Creates a `GraphqlApi` object.
 */
public suspend inline fun AppSyncClient.createGraphqlApi(crossinline block: CreateGraphqlApiRequest.Builder.() -> Unit): CreateGraphqlApiResponse = createGraphqlApi(CreateGraphqlApiRequest.Builder().apply(block).build())

/**
 * Creates a `Resolver` object.
 *
 * A resolver converts incoming requests into a format that a data source can understand, and converts the data source's responses into GraphQL.
 */
public suspend inline fun AppSyncClient.createResolver(crossinline block: CreateResolverRequest.Builder.() -> Unit): CreateResolverResponse = createResolver(CreateResolverRequest.Builder().apply(block).build())

/**
 * Creates a `Type` object.
 */
public suspend inline fun AppSyncClient.createType(crossinline block: CreateTypeRequest.Builder.() -> Unit): CreateTypeResponse = createType(CreateTypeRequest.Builder().apply(block).build())

/**
 * Deletes an `ApiCache` object.
 */
public suspend inline fun AppSyncClient.deleteApiCache(crossinline block: DeleteApiCacheRequest.Builder.() -> Unit): DeleteApiCacheResponse = deleteApiCache(DeleteApiCacheRequest.Builder().apply(block).build())

/**
 * Deletes an API key.
 */
public suspend inline fun AppSyncClient.deleteApiKey(crossinline block: DeleteApiKeyRequest.Builder.() -> Unit): DeleteApiKeyResponse = deleteApiKey(DeleteApiKeyRequest.Builder().apply(block).build())

/**
 * Deletes a `DataSource` object.
 */
public suspend inline fun AppSyncClient.deleteDataSource(crossinline block: DeleteDataSourceRequest.Builder.() -> Unit): DeleteDataSourceResponse = deleteDataSource(DeleteDataSourceRequest.Builder().apply(block).build())

/**
 * Deletes a custom `DomainName` object.
 */
public suspend inline fun AppSyncClient.deleteDomainName(crossinline block: DeleteDomainNameRequest.Builder.() -> Unit): DeleteDomainNameResponse = deleteDomainName(DeleteDomainNameRequest.Builder().apply(block).build())

/**
 * Deletes a `Function`.
 */
public suspend inline fun AppSyncClient.deleteFunction(crossinline block: DeleteFunctionRequest.Builder.() -> Unit): DeleteFunctionResponse = deleteFunction(DeleteFunctionRequest.Builder().apply(block).build())

/**
 * Deletes a `GraphqlApi` object.
 */
public suspend inline fun AppSyncClient.deleteGraphqlApi(crossinline block: DeleteGraphqlApiRequest.Builder.() -> Unit): DeleteGraphqlApiResponse = deleteGraphqlApi(DeleteGraphqlApiRequest.Builder().apply(block).build())

/**
 * Deletes a `Resolver` object.
 */
public suspend inline fun AppSyncClient.deleteResolver(crossinline block: DeleteResolverRequest.Builder.() -> Unit): DeleteResolverResponse = deleteResolver(DeleteResolverRequest.Builder().apply(block).build())

/**
 * Deletes a `Type` object.
 */
public suspend inline fun AppSyncClient.deleteType(crossinline block: DeleteTypeRequest.Builder.() -> Unit): DeleteTypeResponse = deleteType(DeleteTypeRequest.Builder().apply(block).build())

/**
 * Removes an `ApiAssociation` object from a custom domain.
 */
public suspend inline fun AppSyncClient.disassociateApi(crossinline block: DisassociateApiRequest.Builder.() -> Unit): DisassociateApiResponse = disassociateApi(DisassociateApiRequest.Builder().apply(block).build())

/**
 * Evaluates the given code and returns the response. The code definition requirements depend on the specified runtime. For `APPSYNC_JS` runtimes, the code defines the request and response functions. The request function takes the incoming request after a GraphQL operation is parsed and converts it into a request configuration for the selected data source operation. The response function interprets responses from the data source and maps it to the shape of the GraphQL field output type.
 */
public suspend inline fun AppSyncClient.evaluateCode(crossinline block: EvaluateCodeRequest.Builder.() -> Unit): EvaluateCodeResponse = evaluateCode(EvaluateCodeRequest.Builder().apply(block).build())

/**
 * Evaluates a given template and returns the response. The mapping template can be a request or response template.
 *
 * Request templates take the incoming request after a GraphQL operation is parsed and convert it into a request configuration for the selected data source operation. Response templates interpret responses from the data source and map it to the shape of the GraphQL field output type.
 *
 * Mapping templates are written in the Apache Velocity Template Language (VTL).
 */
public suspend inline fun AppSyncClient.evaluateMappingTemplate(crossinline block: EvaluateMappingTemplateRequest.Builder.() -> Unit): EvaluateMappingTemplateResponse = evaluateMappingTemplate(EvaluateMappingTemplateRequest.Builder().apply(block).build())

/**
 * Flushes an `ApiCache` object.
 */
public suspend inline fun AppSyncClient.flushApiCache(crossinline block: FlushApiCacheRequest.Builder.() -> Unit): FlushApiCacheResponse = flushApiCache(FlushApiCacheRequest.Builder().apply(block).build())

/**
 * Retrieves an `ApiAssociation` object.
 */
public suspend inline fun AppSyncClient.getApiAssociation(crossinline block: GetApiAssociationRequest.Builder.() -> Unit): GetApiAssociationResponse = getApiAssociation(GetApiAssociationRequest.Builder().apply(block).build())

/**
 * Retrieves an `ApiCache` object.
 */
public suspend inline fun AppSyncClient.getApiCache(crossinline block: GetApiCacheRequest.Builder.() -> Unit): GetApiCacheResponse = getApiCache(GetApiCacheRequest.Builder().apply(block).build())

/**
 * Retrieves a `DataSource` object.
 */
public suspend inline fun AppSyncClient.getDataSource(crossinline block: GetDataSourceRequest.Builder.() -> Unit): GetDataSourceResponse = getDataSource(GetDataSourceRequest.Builder().apply(block).build())

/**
 * Retrieves a custom `DomainName` object.
 */
public suspend inline fun AppSyncClient.getDomainName(crossinline block: GetDomainNameRequest.Builder.() -> Unit): GetDomainNameResponse = getDomainName(GetDomainNameRequest.Builder().apply(block).build())

/**
 * Get a `Function`.
 */
public suspend inline fun AppSyncClient.getFunction(crossinline block: GetFunctionRequest.Builder.() -> Unit): GetFunctionResponse = getFunction(GetFunctionRequest.Builder().apply(block).build())

/**
 * Retrieves a `GraphqlApi` object.
 */
public suspend inline fun AppSyncClient.getGraphqlApi(crossinline block: GetGraphqlApiRequest.Builder.() -> Unit): GetGraphqlApiResponse = getGraphqlApi(GetGraphqlApiRequest.Builder().apply(block).build())

/**
 * Retrieves the introspection schema for a GraphQL API.
 */
public suspend inline fun AppSyncClient.getIntrospectionSchema(crossinline block: GetIntrospectionSchemaRequest.Builder.() -> Unit): GetIntrospectionSchemaResponse = getIntrospectionSchema(GetIntrospectionSchemaRequest.Builder().apply(block).build())

/**
 * Retrieves a `Resolver` object.
 */
public suspend inline fun AppSyncClient.getResolver(crossinline block: GetResolverRequest.Builder.() -> Unit): GetResolverResponse = getResolver(GetResolverRequest.Builder().apply(block).build())

/**
 * Retrieves the current status of a schema creation operation.
 */
public suspend inline fun AppSyncClient.getSchemaCreationStatus(crossinline block: GetSchemaCreationStatusRequest.Builder.() -> Unit): GetSchemaCreationStatusResponse = getSchemaCreationStatus(GetSchemaCreationStatusRequest.Builder().apply(block).build())

/**
 * Retrieves a `Type` object.
 */
public suspend inline fun AppSyncClient.getType(crossinline block: GetTypeRequest.Builder.() -> Unit): GetTypeResponse = getType(GetTypeRequest.Builder().apply(block).build())

/**
 * Lists the API keys for a given API.
 *
 * API keys are deleted automatically 60 days after they expire. However, they may still be included in the response until they have actually been deleted. You can safely call `DeleteApiKey` to manually delete a key before it's automatically deleted.
 */
public suspend inline fun AppSyncClient.listApiKeys(crossinline block: ListApiKeysRequest.Builder.() -> Unit): ListApiKeysResponse = listApiKeys(ListApiKeysRequest.Builder().apply(block).build())

/**
 * Lists the data sources for a given API.
 */
public suspend inline fun AppSyncClient.listDataSources(crossinline block: ListDataSourcesRequest.Builder.() -> Unit): ListDataSourcesResponse = listDataSources(ListDataSourcesRequest.Builder().apply(block).build())

/**
 * Lists multiple custom domain names.
 */
public suspend inline fun AppSyncClient.listDomainNames(crossinline block: ListDomainNamesRequest.Builder.() -> Unit): ListDomainNamesResponse = listDomainNames(ListDomainNamesRequest.Builder().apply(block).build())

/**
 * List multiple functions.
 */
public suspend inline fun AppSyncClient.listFunctions(crossinline block: ListFunctionsRequest.Builder.() -> Unit): ListFunctionsResponse = listFunctions(ListFunctionsRequest.Builder().apply(block).build())

/**
 * Lists your GraphQL APIs.
 */
public suspend inline fun AppSyncClient.listGraphqlApis(crossinline block: ListGraphqlApisRequest.Builder.() -> Unit): ListGraphqlApisResponse = listGraphqlApis(ListGraphqlApisRequest.Builder().apply(block).build())

/**
 * Lists the resolvers for a given API and type.
 */
public suspend inline fun AppSyncClient.listResolvers(crossinline block: ListResolversRequest.Builder.() -> Unit): ListResolversResponse = listResolvers(ListResolversRequest.Builder().apply(block).build())

/**
 * List the resolvers that are associated with a specific function.
 */
public suspend inline fun AppSyncClient.listResolversByFunction(crossinline block: ListResolversByFunctionRequest.Builder.() -> Unit): ListResolversByFunctionResponse = listResolversByFunction(ListResolversByFunctionRequest.Builder().apply(block).build())

/**
 * Lists the tags for a resource.
 */
public suspend inline fun AppSyncClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists the types for a given API.
 */
public suspend inline fun AppSyncClient.listTypes(crossinline block: ListTypesRequest.Builder.() -> Unit): ListTypesResponse = listTypes(ListTypesRequest.Builder().apply(block).build())

/**
 * Adds a new schema to your GraphQL API.
 *
 * This operation is asynchronous. Use to determine when it has completed.
 */
public suspend inline fun AppSyncClient.startSchemaCreation(crossinline block: StartSchemaCreationRequest.Builder.() -> Unit): StartSchemaCreationResponse = startSchemaCreation(StartSchemaCreationRequest.Builder().apply(block).build())

/**
 * Tags a resource with user-supplied tags.
 */
public suspend inline fun AppSyncClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Untags a resource.
 */
public suspend inline fun AppSyncClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the cache for the GraphQL API.
 */
public suspend inline fun AppSyncClient.updateApiCache(crossinline block: UpdateApiCacheRequest.Builder.() -> Unit): UpdateApiCacheResponse = updateApiCache(UpdateApiCacheRequest.Builder().apply(block).build())

/**
 * Updates an API key. You can update the key as long as it's not deleted.
 */
public suspend inline fun AppSyncClient.updateApiKey(crossinline block: UpdateApiKeyRequest.Builder.() -> Unit): UpdateApiKeyResponse = updateApiKey(UpdateApiKeyRequest.Builder().apply(block).build())

/**
 * Updates a `DataSource` object.
 */
public suspend inline fun AppSyncClient.updateDataSource(crossinline block: UpdateDataSourceRequest.Builder.() -> Unit): UpdateDataSourceResponse = updateDataSource(UpdateDataSourceRequest.Builder().apply(block).build())

/**
 * Updates a custom `DomainName` object.
 */
public suspend inline fun AppSyncClient.updateDomainName(crossinline block: UpdateDomainNameRequest.Builder.() -> Unit): UpdateDomainNameResponse = updateDomainName(UpdateDomainNameRequest.Builder().apply(block).build())

/**
 * Updates a `Function` object.
 */
public suspend inline fun AppSyncClient.updateFunction(crossinline block: UpdateFunctionRequest.Builder.() -> Unit): UpdateFunctionResponse = updateFunction(UpdateFunctionRequest.Builder().apply(block).build())

/**
 * Updates a `GraphqlApi` object.
 */
public suspend inline fun AppSyncClient.updateGraphqlApi(crossinline block: UpdateGraphqlApiRequest.Builder.() -> Unit): UpdateGraphqlApiResponse = updateGraphqlApi(UpdateGraphqlApiRequest.Builder().apply(block).build())

/**
 * Updates a `Resolver` object.
 */
public suspend inline fun AppSyncClient.updateResolver(crossinline block: UpdateResolverRequest.Builder.() -> Unit): UpdateResolverResponse = updateResolver(UpdateResolverRequest.Builder().apply(block).build())

/**
 * Updates a `Type` object.
 */
public suspend inline fun AppSyncClient.updateType(crossinline block: UpdateTypeRequest.Builder.() -> Unit): UpdateTypeResponse = updateType(UpdateTypeRequest.Builder().apply(block).build())
