// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.transform

import aws.sdk.kotlin.services.appsync.model.CachingConfig
import aws.sdk.kotlin.services.appsync.model.CreateResolverRequest
import aws.sdk.kotlin.services.appsync.model.PipelineConfig
import aws.sdk.kotlin.services.appsync.model.ResolverKind
import aws.sdk.kotlin.services.appsync.model.SyncConfig
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateResolverOperationSerializer: HttpSerialize<CreateResolverRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateResolverRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "v1",
                "apis",
                "${input.apiId}".encodeLabel(),
                "types",
                "${input.typeName}".encodeLabel(),
                "resolvers",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateResolverOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/json")
        return builder
    }
}

private fun serializeCreateResolverOperationBody(context: ExecutionContext, input: CreateResolverRequest): ByteArray {
    val serializer = JsonSerializer()
    val CACHINGCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("cachingConfig"))
    val DATASOURCENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dataSourceName"))
    val FIELDNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("fieldName"))
    val KIND_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("kind"))
    val MAXBATCHSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("maxBatchSize"))
    val PIPELINECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("pipelineConfig"))
    val REQUESTMAPPINGTEMPLATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("requestMappingTemplate"))
    val RESPONSEMAPPINGTEMPLATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("responseMappingTemplate"))
    val SYNCCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("syncConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CACHINGCONFIG_DESCRIPTOR)
        field(DATASOURCENAME_DESCRIPTOR)
        field(FIELDNAME_DESCRIPTOR)
        field(KIND_DESCRIPTOR)
        field(MAXBATCHSIZE_DESCRIPTOR)
        field(PIPELINECONFIG_DESCRIPTOR)
        field(REQUESTMAPPINGTEMPLATE_DESCRIPTOR)
        field(RESPONSEMAPPINGTEMPLATE_DESCRIPTOR)
        field(SYNCCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.cachingConfig?.let { field(CACHINGCONFIG_DESCRIPTOR, it, ::serializeCachingConfigDocument) }
        input.dataSourceName?.let { field(DATASOURCENAME_DESCRIPTOR, it) }
        input.fieldName?.let { field(FIELDNAME_DESCRIPTOR, it) }
        input.kind?.let { field(KIND_DESCRIPTOR, it.value) }
        if (input.maxBatchSize != 0) field(MAXBATCHSIZE_DESCRIPTOR, input.maxBatchSize)
        input.pipelineConfig?.let { field(PIPELINECONFIG_DESCRIPTOR, it, ::serializePipelineConfigDocument) }
        input.requestMappingTemplate?.let { field(REQUESTMAPPINGTEMPLATE_DESCRIPTOR, it) }
        input.responseMappingTemplate?.let { field(RESPONSEMAPPINGTEMPLATE_DESCRIPTOR, it) }
        input.syncConfig?.let { field(SYNCCONFIG_DESCRIPTOR, it, ::serializeSyncConfigDocument) }
    }
    return serializer.toByteArray()
}
