// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.transform

import aws.sdk.kotlin.services.appsync.model.CreateDataSourceRequest
import aws.sdk.kotlin.services.appsync.model.DataSourceType
import aws.sdk.kotlin.services.appsync.model.DynamodbDataSourceConfig
import aws.sdk.kotlin.services.appsync.model.ElasticsearchDataSourceConfig
import aws.sdk.kotlin.services.appsync.model.HttpDataSourceConfig
import aws.sdk.kotlin.services.appsync.model.LambdaDataSourceConfig
import aws.sdk.kotlin.services.appsync.model.OpenSearchServiceDataSourceConfig
import aws.sdk.kotlin.services.appsync.model.RelationalDatabaseDataSourceConfig
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateDataSourceOperationSerializer: HttpSerialize<CreateDataSourceRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateDataSourceRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "v1",
                "apis",
                "${input.apiId}".encodeLabel(),
                "datasources",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateDataSourceOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/json")
        return builder
    }
}

private fun serializeCreateDataSourceOperationBody(context: ExecutionContext, input: CreateDataSourceRequest): ByteArray {
    val serializer = JsonSerializer()
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val DYNAMODBCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("dynamodbConfig"))
    val ELASTICSEARCHCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("elasticsearchConfig"))
    val HTTPCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("httpConfig"))
    val LAMBDACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("lambdaConfig"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val OPENSEARCHSERVICECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("openSearchServiceConfig"))
    val RELATIONALDATABASECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("relationalDatabaseConfig"))
    val SERVICEROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("serviceRoleArn"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(DYNAMODBCONFIG_DESCRIPTOR)
        field(ELASTICSEARCHCONFIG_DESCRIPTOR)
        field(HTTPCONFIG_DESCRIPTOR)
        field(LAMBDACONFIG_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OPENSEARCHSERVICECONFIG_DESCRIPTOR)
        field(RELATIONALDATABASECONFIG_DESCRIPTOR)
        field(SERVICEROLEARN_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.dynamodbConfig?.let { field(DYNAMODBCONFIG_DESCRIPTOR, it, ::serializeDynamodbDataSourceConfigDocument) }
        input.elasticsearchConfig?.let { field(ELASTICSEARCHCONFIG_DESCRIPTOR, it, ::serializeElasticsearchDataSourceConfigDocument) }
        input.httpConfig?.let { field(HTTPCONFIG_DESCRIPTOR, it, ::serializeHttpDataSourceConfigDocument) }
        input.lambdaConfig?.let { field(LAMBDACONFIG_DESCRIPTOR, it, ::serializeLambdaDataSourceConfigDocument) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.openSearchServiceConfig?.let { field(OPENSEARCHSERVICECONFIG_DESCRIPTOR, it, ::serializeOpenSearchServiceDataSourceConfigDocument) }
        input.relationalDatabaseConfig?.let { field(RELATIONALDATABASECONFIG_DESCRIPTOR, it, ::serializeRelationalDatabaseDataSourceConfigDocument) }
        input.serviceRoleArn?.let { field(SERVICEROLEARN_DESCRIPTOR, it) }
        input.type?.let { field(TYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
