// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.appsync.model.ApiAssociation
import aws.sdk.kotlin.services.appsync.model.AppSyncException
import aws.sdk.kotlin.services.appsync.model.AssociateApiResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class AssociateApiOperationDeserializer: HttpDeserialize<AssociateApiResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): AssociateApiResponse {
        if (!response.status.isSuccess()) {
            throwAssociateApiError(context, response)
        }
        val builder = AssociateApiResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeAssociateApiOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeAssociateApiOperationBody(builder: AssociateApiResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APIASSOCIATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("apiAssociation"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APIASSOCIATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APIASSOCIATION_DESCRIPTOR.index -> builder.apiAssociation = deserializeApiAssociationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwAssociateApiError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AppSyncException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer()
        "BadRequestException" -> BadRequestExceptionDeserializer()
        "InternalFailureException" -> InternalFailureExceptionDeserializer()
        "NotFoundException" -> NotFoundExceptionDeserializer()
        else -> throw AppSyncException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
