// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * Describes an Amazon Cognito user pool configuration.
 */
class UserPoolConfig private constructor(builder: Builder) {
    /**
     * A regular expression for validating the incoming Amazon Cognito user pool app client
     * ID.
     */
    val appIdClientRegex: kotlin.String? = builder.appIdClientRegex
    /**
     * The Amazon Web Services Region in which the user pool was created.
     */
    val awsRegion: kotlin.String? = builder.awsRegion
    /**
     * The action that you want your GraphQL API to take when a request that uses Amazon Cognito user pool authentication doesn't match the Amazon Cognito user pool
     * configuration.
     */
    val defaultAction: aws.sdk.kotlin.services.appsync.model.DefaultAction? = builder.defaultAction
    /**
     * The user pool ID.
     */
    val userPoolId: kotlin.String? = builder.userPoolId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.UserPoolConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UserPoolConfig(")
        append("appIdClientRegex=$appIdClientRegex,")
        append("awsRegion=$awsRegion,")
        append("defaultAction=$defaultAction,")
        append("userPoolId=$userPoolId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appIdClientRegex?.hashCode() ?: 0
        result = 31 * result + (awsRegion?.hashCode() ?: 0)
        result = 31 * result + (defaultAction?.hashCode() ?: 0)
        result = 31 * result + (userPoolId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UserPoolConfig

        if (appIdClientRegex != other.appIdClientRegex) return false
        if (awsRegion != other.awsRegion) return false
        if (defaultAction != other.defaultAction) return false
        if (userPoolId != other.userPoolId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.UserPoolConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * A regular expression for validating the incoming Amazon Cognito user pool app client
         * ID.
         */
        var appIdClientRegex: kotlin.String? = null
        /**
         * The Amazon Web Services Region in which the user pool was created.
         */
        var awsRegion: kotlin.String? = null
        /**
         * The action that you want your GraphQL API to take when a request that uses Amazon Cognito user pool authentication doesn't match the Amazon Cognito user pool
         * configuration.
         */
        var defaultAction: aws.sdk.kotlin.services.appsync.model.DefaultAction? = null
        /**
         * The user pool ID.
         */
        var userPoolId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.UserPoolConfig) : this() {
            this.appIdClientRegex = x.appIdClientRegex
            this.awsRegion = x.awsRegion
            this.defaultAction = x.defaultAction
            this.userPoolId = x.userPoolId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.UserPoolConfig = UserPoolConfig(this)
    }
}
