// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * Describes a resolver.
 */
class Resolver private constructor(builder: Builder) {
    /**
     * The caching configuration for the resolver.
     */
    val cachingConfig: aws.sdk.kotlin.services.appsync.model.CachingConfig? = builder.cachingConfig
    /**
     * The resolver data source name.
     */
    val dataSourceName: kotlin.String? = builder.dataSourceName
    /**
     * The resolver field name.
     */
    val fieldName: kotlin.String? = builder.fieldName
    /**
     * The resolver type.
     * UNIT: A UNIT resolver type. A UNIT resolver is
     * the default resolver type. You can use a UNIT resolver to run a GraphQL query against
     * a single data source.
     * PIPELINE: A PIPELINE resolver type. You can
     * use a PIPELINE resolver to invoke a series of Function objects in a
     * serial manner. You can use a pipeline resolver to run a GraphQL query against
     * multiple data sources.
     */
    val kind: aws.sdk.kotlin.services.appsync.model.ResolverKind? = builder.kind
    /**
     * The maximum batching size for a resolver.
     */
    val maxBatchSize: kotlin.Int = builder.maxBatchSize
    /**
     * The PipelineConfig.
     */
    val pipelineConfig: aws.sdk.kotlin.services.appsync.model.PipelineConfig? = builder.pipelineConfig
    /**
     * The request mapping template.
     */
    val requestMappingTemplate: kotlin.String? = builder.requestMappingTemplate
    /**
     * The resolver Amazon Resource Name (ARN).
     */
    val resolverArn: kotlin.String? = builder.resolverArn
    /**
     * The response mapping template.
     */
    val responseMappingTemplate: kotlin.String? = builder.responseMappingTemplate
    /**
     * The SyncConfig for a resolver attached to a versioned data source.
     */
    val syncConfig: aws.sdk.kotlin.services.appsync.model.SyncConfig? = builder.syncConfig
    /**
     * The resolver type name.
     */
    val typeName: kotlin.String? = builder.typeName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.Resolver = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Resolver(")
        append("cachingConfig=$cachingConfig,")
        append("dataSourceName=$dataSourceName,")
        append("fieldName=$fieldName,")
        append("kind=$kind,")
        append("maxBatchSize=$maxBatchSize,")
        append("pipelineConfig=$pipelineConfig,")
        append("requestMappingTemplate=$requestMappingTemplate,")
        append("resolverArn=$resolverArn,")
        append("responseMappingTemplate=$responseMappingTemplate,")
        append("syncConfig=$syncConfig,")
        append("typeName=$typeName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cachingConfig?.hashCode() ?: 0
        result = 31 * result + (dataSourceName?.hashCode() ?: 0)
        result = 31 * result + (fieldName?.hashCode() ?: 0)
        result = 31 * result + (kind?.hashCode() ?: 0)
        result = 31 * result + (maxBatchSize)
        result = 31 * result + (pipelineConfig?.hashCode() ?: 0)
        result = 31 * result + (requestMappingTemplate?.hashCode() ?: 0)
        result = 31 * result + (resolverArn?.hashCode() ?: 0)
        result = 31 * result + (responseMappingTemplate?.hashCode() ?: 0)
        result = 31 * result + (syncConfig?.hashCode() ?: 0)
        result = 31 * result + (typeName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Resolver

        if (cachingConfig != other.cachingConfig) return false
        if (dataSourceName != other.dataSourceName) return false
        if (fieldName != other.fieldName) return false
        if (kind != other.kind) return false
        if (maxBatchSize != other.maxBatchSize) return false
        if (pipelineConfig != other.pipelineConfig) return false
        if (requestMappingTemplate != other.requestMappingTemplate) return false
        if (resolverArn != other.resolverArn) return false
        if (responseMappingTemplate != other.responseMappingTemplate) return false
        if (syncConfig != other.syncConfig) return false
        if (typeName != other.typeName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.Resolver = Builder(this).apply(block).build()

    class Builder {
        /**
         * The caching configuration for the resolver.
         */
        var cachingConfig: aws.sdk.kotlin.services.appsync.model.CachingConfig? = null
        /**
         * The resolver data source name.
         */
        var dataSourceName: kotlin.String? = null
        /**
         * The resolver field name.
         */
        var fieldName: kotlin.String? = null
        /**
         * The resolver type.
         * UNIT: A UNIT resolver type. A UNIT resolver is
         * the default resolver type. You can use a UNIT resolver to run a GraphQL query against
         * a single data source.
         * PIPELINE: A PIPELINE resolver type. You can
         * use a PIPELINE resolver to invoke a series of Function objects in a
         * serial manner. You can use a pipeline resolver to run a GraphQL query against
         * multiple data sources.
         */
        var kind: aws.sdk.kotlin.services.appsync.model.ResolverKind? = null
        /**
         * The maximum batching size for a resolver.
         */
        var maxBatchSize: kotlin.Int = 0
        /**
         * The PipelineConfig.
         */
        var pipelineConfig: aws.sdk.kotlin.services.appsync.model.PipelineConfig? = null
        /**
         * The request mapping template.
         */
        var requestMappingTemplate: kotlin.String? = null
        /**
         * The resolver Amazon Resource Name (ARN).
         */
        var resolverArn: kotlin.String? = null
        /**
         * The response mapping template.
         */
        var responseMappingTemplate: kotlin.String? = null
        /**
         * The SyncConfig for a resolver attached to a versioned data source.
         */
        var syncConfig: aws.sdk.kotlin.services.appsync.model.SyncConfig? = null
        /**
         * The resolver type name.
         */
        var typeName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.Resolver) : this() {
            this.cachingConfig = x.cachingConfig
            this.dataSourceName = x.dataSourceName
            this.fieldName = x.fieldName
            this.kind = x.kind
            this.maxBatchSize = x.maxBatchSize
            this.pipelineConfig = x.pipelineConfig
            this.requestMappingTemplate = x.requestMappingTemplate
            this.resolverArn = x.resolverArn
            this.responseMappingTemplate = x.responseMappingTemplate
            this.syncConfig = x.syncConfig
            this.typeName = x.typeName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.Resolver = Resolver(this)

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.CachingConfig] inside the given [block]
         */
        fun cachingConfig(block: aws.sdk.kotlin.services.appsync.model.CachingConfig.Builder.() -> kotlin.Unit) {
            this.cachingConfig = aws.sdk.kotlin.services.appsync.model.CachingConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.PipelineConfig] inside the given [block]
         */
        fun pipelineConfig(block: aws.sdk.kotlin.services.appsync.model.PipelineConfig.Builder.() -> kotlin.Unit) {
            this.pipelineConfig = aws.sdk.kotlin.services.appsync.model.PipelineConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.SyncConfig] inside the given [block]
         */
        fun syncConfig(block: aws.sdk.kotlin.services.appsync.model.SyncConfig.Builder.() -> kotlin.Unit) {
            this.syncConfig = aws.sdk.kotlin.services.appsync.model.SyncConfig.invoke(block)
        }
    }
}
