// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * Describes an OpenID Connect (OIDC) configuration.
 */
class OpenIdConnectConfig private constructor(builder: Builder) {
    /**
     * The number of milliseconds that a token is valid after being authenticated.
     */
    val authTtl: kotlin.Long = builder.authTtl
    /**
     * The client identifier of the relying party at the OpenID identity provider. This
     * identifier is typically obtained when the relying party is registered with the OpenID
     * identity provider. You can specify a regular expression so that AppSync can
     * validate against multiple client identifiers at a time.
     */
    val clientId: kotlin.String? = builder.clientId
    /**
     * The number of milliseconds that a token is valid after it's issued to a user.
     */
    val iatTtl: kotlin.Long = builder.iatTtl
    /**
     * The issuer for the OIDC configuration. The issuer returned by discovery must exactly
     * match the value of iss in the ID token.
     */
    val issuer: kotlin.String? = builder.issuer

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OpenIdConnectConfig(")
        append("authTtl=$authTtl,")
        append("clientId=$clientId,")
        append("iatTtl=$iatTtl,")
        append("issuer=$issuer)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authTtl.hashCode()
        result = 31 * result + (clientId?.hashCode() ?: 0)
        result = 31 * result + (iatTtl.hashCode())
        result = 31 * result + (issuer?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OpenIdConnectConfig

        if (authTtl != other.authTtl) return false
        if (clientId != other.clientId) return false
        if (iatTtl != other.iatTtl) return false
        if (issuer != other.issuer) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The number of milliseconds that a token is valid after being authenticated.
         */
        var authTtl: kotlin.Long = 0L
        /**
         * The client identifier of the relying party at the OpenID identity provider. This
         * identifier is typically obtained when the relying party is registered with the OpenID
         * identity provider. You can specify a regular expression so that AppSync can
         * validate against multiple client identifiers at a time.
         */
        var clientId: kotlin.String? = null
        /**
         * The number of milliseconds that a token is valid after it's issued to a user.
         */
        var iatTtl: kotlin.Long = 0L
        /**
         * The issuer for the OIDC configuration. The issuer returned by discovery must exactly
         * match the value of iss in the ID token.
         */
        var issuer: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig) : this() {
            this.authTtl = x.authTtl
            this.clientId = x.clientId
            this.iatTtl = x.iatTtl
            this.issuer = x.issuer
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig = OpenIdConnectConfig(this)
    }
}
