// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * A LambdaAuthorizerConfig specifies how to authorize AppSync
 * API access when using the AWS_LAMBDA authorizer mode. Be aware that an AppSync API can have only one Lambda authorizer configured at a
 * time.
 */
class LambdaAuthorizerConfig private constructor(builder: Builder) {
    /**
     * The number of seconds a response should be cached for. The default is 5 minutes (300
     * seconds). The Lambda function can override this by returning a
     * ttlOverride key in its response. A value of 0 disables caching of
     * responses.
     */
    val authorizerResultTtlInSeconds: kotlin.Int = builder.authorizerResultTtlInSeconds
    /**
     * The Amazon Resource Name (ARN) of the Lambda function to be called for
     * authorization. This can be a standard Lambda ARN, a version ARN
     * (.../v3), or an alias ARN.
     * Note: This Lambda function must have the
     * following resource-based policy assigned to it. When configuring Lambda
     * authorizers in the console, this is done for you. To use the Command Line Interface
     * (CLI), run the following:
     * aws lambda add-permission --function-name
     * "arn:aws:lambda:us-east-2:111122223333:function:my-function" --statement-id "appsync"
     * --principal appsync.amazonaws.com --action lambda:InvokeFunction
     */
    val authorizerUri: kotlin.String? = builder.authorizerUri
    /**
     * A regular expression for validation of tokens before the Lambda function is
     * called.
     */
    val identityValidationExpression: kotlin.String? = builder.identityValidationExpression

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaAuthorizerConfig(")
        append("authorizerResultTtlInSeconds=$authorizerResultTtlInSeconds,")
        append("authorizerUri=$authorizerUri,")
        append("identityValidationExpression=$identityValidationExpression)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authorizerResultTtlInSeconds
        result = 31 * result + (authorizerUri?.hashCode() ?: 0)
        result = 31 * result + (identityValidationExpression?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LambdaAuthorizerConfig

        if (authorizerResultTtlInSeconds != other.authorizerResultTtlInSeconds) return false
        if (authorizerUri != other.authorizerUri) return false
        if (identityValidationExpression != other.identityValidationExpression) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The number of seconds a response should be cached for. The default is 5 minutes (300
         * seconds). The Lambda function can override this by returning a
         * ttlOverride key in its response. A value of 0 disables caching of
         * responses.
         */
        var authorizerResultTtlInSeconds: kotlin.Int = 0
        /**
         * The Amazon Resource Name (ARN) of the Lambda function to be called for
         * authorization. This can be a standard Lambda ARN, a version ARN
         * (.../v3), or an alias ARN.
         * Note: This Lambda function must have the
         * following resource-based policy assigned to it. When configuring Lambda
         * authorizers in the console, this is done for you. To use the Command Line Interface
         * (CLI), run the following:
         * aws lambda add-permission --function-name
         * "arn:aws:lambda:us-east-2:111122223333:function:my-function" --statement-id "appsync"
         * --principal appsync.amazonaws.com --action lambda:InvokeFunction
         */
        var authorizerUri: kotlin.String? = null
        /**
         * A regular expression for validation of tokens before the Lambda function is
         * called.
         */
        var identityValidationExpression: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig) : this() {
            this.authorizerResultTtlInSeconds = x.authorizerResultTtlInSeconds
            this.authorizerUri = x.authorizerUri
            this.identityValidationExpression = x.identityValidationExpression
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig = LambdaAuthorizerConfig(this)
    }
}
