// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * Describes a GraphQL API.
 */
class GraphqlApi private constructor(builder: Builder) {
    /**
     * A list of additional authentication providers for the GraphqlApi
     * API.
     */
    val additionalAuthenticationProviders: List<AdditionalAuthenticationProvider>? = builder.additionalAuthenticationProviders
    /**
     * The API ID.
     */
    val apiId: kotlin.String? = builder.apiId
    /**
     * The Amazon Resource Name (ARN).
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The authentication type.
     */
    val authenticationType: aws.sdk.kotlin.services.appsync.model.AuthenticationType? = builder.authenticationType
    /**
     * Configuration for Lambda function authorization.
     */
    val lambdaAuthorizerConfig: aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig? = builder.lambdaAuthorizerConfig
    /**
     * The Amazon CloudWatch Logs configuration.
     */
    val logConfig: aws.sdk.kotlin.services.appsync.model.LogConfig? = builder.logConfig
    /**
     * The API name.
     */
    val name: kotlin.String? = builder.name
    /**
     * The OpenID Connect configuration.
     */
    val openIdConnectConfig: aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig? = builder.openIdConnectConfig
    /**
     * The tags.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The URIs.
     */
    val uris: Map<String, String>? = builder.uris
    /**
     * The Amazon Cognito user pool configuration.
     */
    val userPoolConfig: aws.sdk.kotlin.services.appsync.model.UserPoolConfig? = builder.userPoolConfig
    /**
     * The ARN of the WAF access control list (ACL) associated with this
     * GraphqlApi, if one exists.
     */
    val wafWebAclArn: kotlin.String? = builder.wafWebAclArn
    /**
     * A flag indicating whether to use X-Ray tracing for this
     * GraphqlApi.
     */
    val xrayEnabled: kotlin.Boolean = builder.xrayEnabled

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.GraphqlApi = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GraphqlApi(")
        append("additionalAuthenticationProviders=$additionalAuthenticationProviders,")
        append("apiId=$apiId,")
        append("arn=$arn,")
        append("authenticationType=$authenticationType,")
        append("lambdaAuthorizerConfig=$lambdaAuthorizerConfig,")
        append("logConfig=$logConfig,")
        append("name=$name,")
        append("openIdConnectConfig=$openIdConnectConfig,")
        append("tags=$tags,")
        append("uris=$uris,")
        append("userPoolConfig=$userPoolConfig,")
        append("wafWebAclArn=$wafWebAclArn,")
        append("xrayEnabled=$xrayEnabled)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalAuthenticationProviders?.hashCode() ?: 0
        result = 31 * result + (apiId?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (authenticationType?.hashCode() ?: 0)
        result = 31 * result + (lambdaAuthorizerConfig?.hashCode() ?: 0)
        result = 31 * result + (logConfig?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (openIdConnectConfig?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (uris?.hashCode() ?: 0)
        result = 31 * result + (userPoolConfig?.hashCode() ?: 0)
        result = 31 * result + (wafWebAclArn?.hashCode() ?: 0)
        result = 31 * result + (xrayEnabled.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GraphqlApi

        if (additionalAuthenticationProviders != other.additionalAuthenticationProviders) return false
        if (apiId != other.apiId) return false
        if (arn != other.arn) return false
        if (authenticationType != other.authenticationType) return false
        if (lambdaAuthorizerConfig != other.lambdaAuthorizerConfig) return false
        if (logConfig != other.logConfig) return false
        if (name != other.name) return false
        if (openIdConnectConfig != other.openIdConnectConfig) return false
        if (tags != other.tags) return false
        if (uris != other.uris) return false
        if (userPoolConfig != other.userPoolConfig) return false
        if (wafWebAclArn != other.wafWebAclArn) return false
        if (xrayEnabled != other.xrayEnabled) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.GraphqlApi = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of additional authentication providers for the GraphqlApi
         * API.
         */
        var additionalAuthenticationProviders: List<AdditionalAuthenticationProvider>? = null
        /**
         * The API ID.
         */
        var apiId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN).
         */
        var arn: kotlin.String? = null
        /**
         * The authentication type.
         */
        var authenticationType: aws.sdk.kotlin.services.appsync.model.AuthenticationType? = null
        /**
         * Configuration for Lambda function authorization.
         */
        var lambdaAuthorizerConfig: aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig? = null
        /**
         * The Amazon CloudWatch Logs configuration.
         */
        var logConfig: aws.sdk.kotlin.services.appsync.model.LogConfig? = null
        /**
         * The API name.
         */
        var name: kotlin.String? = null
        /**
         * The OpenID Connect configuration.
         */
        var openIdConnectConfig: aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig? = null
        /**
         * The tags.
         */
        var tags: Map<String, String>? = null
        /**
         * The URIs.
         */
        var uris: Map<String, String>? = null
        /**
         * The Amazon Cognito user pool configuration.
         */
        var userPoolConfig: aws.sdk.kotlin.services.appsync.model.UserPoolConfig? = null
        /**
         * The ARN of the WAF access control list (ACL) associated with this
         * GraphqlApi, if one exists.
         */
        var wafWebAclArn: kotlin.String? = null
        /**
         * A flag indicating whether to use X-Ray tracing for this
         * GraphqlApi.
         */
        var xrayEnabled: kotlin.Boolean = false

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.GraphqlApi) : this() {
            this.additionalAuthenticationProviders = x.additionalAuthenticationProviders
            this.apiId = x.apiId
            this.arn = x.arn
            this.authenticationType = x.authenticationType
            this.lambdaAuthorizerConfig = x.lambdaAuthorizerConfig
            this.logConfig = x.logConfig
            this.name = x.name
            this.openIdConnectConfig = x.openIdConnectConfig
            this.tags = x.tags
            this.uris = x.uris
            this.userPoolConfig = x.userPoolConfig
            this.wafWebAclArn = x.wafWebAclArn
            this.xrayEnabled = x.xrayEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.GraphqlApi = GraphqlApi(this)

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig] inside the given [block]
         */
        fun lambdaAuthorizerConfig(block: aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig.Builder.() -> kotlin.Unit) {
            this.lambdaAuthorizerConfig = aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.LogConfig] inside the given [block]
         */
        fun logConfig(block: aws.sdk.kotlin.services.appsync.model.LogConfig.Builder.() -> kotlin.Unit) {
            this.logConfig = aws.sdk.kotlin.services.appsync.model.LogConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig] inside the given [block]
         */
        fun openIdConnectConfig(block: aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig.Builder.() -> kotlin.Unit) {
            this.openIdConnectConfig = aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.UserPoolConfig] inside the given [block]
         */
        fun userPoolConfig(block: aws.sdk.kotlin.services.appsync.model.UserPoolConfig.Builder.() -> kotlin.Unit) {
            this.userPoolConfig = aws.sdk.kotlin.services.appsync.model.UserPoolConfig.invoke(block)
        }
    }
}
