// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * A function is a reusable entity. You can use multiple functions to compose the resolver
 * logic.
 */
class FunctionConfiguration private constructor(builder: Builder) {
    /**
     * The name of the DataSource.
     */
    val dataSourceName: kotlin.String? = builder.dataSourceName
    /**
     * The Function description.
     */
    val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name (ARN) of the Function object.
     */
    val functionArn: kotlin.String? = builder.functionArn
    /**
     * A unique ID representing the Function object.
     */
    val functionId: kotlin.String? = builder.functionId
    /**
     * The version of the request mapping template. Currently, only the 2018-05-29 version of
     * the template is supported.
     */
    val functionVersion: kotlin.String? = builder.functionVersion
    /**
     * The maximum batching size for a resolver.
     */
    val maxBatchSize: kotlin.Int = builder.maxBatchSize
    /**
     * The name of the Function object.
     */
    val name: kotlin.String? = builder.name
    /**
     * The Function request mapping template. Functions support only the
     * 2018-05-29 version of the request mapping template.
     */
    val requestMappingTemplate: kotlin.String? = builder.requestMappingTemplate
    /**
     * The Function response mapping template.
     */
    val responseMappingTemplate: kotlin.String? = builder.responseMappingTemplate
    /**
     * Describes a Sync configuration for a resolver.
     * Specifies which Conflict Detection strategy and Resolution strategy to use when the
     * resolver is invoked.
     */
    val syncConfig: aws.sdk.kotlin.services.appsync.model.SyncConfig? = builder.syncConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.FunctionConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FunctionConfiguration(")
        append("dataSourceName=$dataSourceName,")
        append("description=$description,")
        append("functionArn=$functionArn,")
        append("functionId=$functionId,")
        append("functionVersion=$functionVersion,")
        append("maxBatchSize=$maxBatchSize,")
        append("name=$name,")
        append("requestMappingTemplate=$requestMappingTemplate,")
        append("responseMappingTemplate=$responseMappingTemplate,")
        append("syncConfig=$syncConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSourceName?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (functionArn?.hashCode() ?: 0)
        result = 31 * result + (functionId?.hashCode() ?: 0)
        result = 31 * result + (functionVersion?.hashCode() ?: 0)
        result = 31 * result + (maxBatchSize)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (requestMappingTemplate?.hashCode() ?: 0)
        result = 31 * result + (responseMappingTemplate?.hashCode() ?: 0)
        result = 31 * result + (syncConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FunctionConfiguration

        if (dataSourceName != other.dataSourceName) return false
        if (description != other.description) return false
        if (functionArn != other.functionArn) return false
        if (functionId != other.functionId) return false
        if (functionVersion != other.functionVersion) return false
        if (maxBatchSize != other.maxBatchSize) return false
        if (name != other.name) return false
        if (requestMappingTemplate != other.requestMappingTemplate) return false
        if (responseMappingTemplate != other.responseMappingTemplate) return false
        if (syncConfig != other.syncConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.FunctionConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the DataSource.
         */
        var dataSourceName: kotlin.String? = null
        /**
         * The Function description.
         */
        var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Function object.
         */
        var functionArn: kotlin.String? = null
        /**
         * A unique ID representing the Function object.
         */
        var functionId: kotlin.String? = null
        /**
         * The version of the request mapping template. Currently, only the 2018-05-29 version of
         * the template is supported.
         */
        var functionVersion: kotlin.String? = null
        /**
         * The maximum batching size for a resolver.
         */
        var maxBatchSize: kotlin.Int = 0
        /**
         * The name of the Function object.
         */
        var name: kotlin.String? = null
        /**
         * The Function request mapping template. Functions support only the
         * 2018-05-29 version of the request mapping template.
         */
        var requestMappingTemplate: kotlin.String? = null
        /**
         * The Function response mapping template.
         */
        var responseMappingTemplate: kotlin.String? = null
        /**
         * Describes a Sync configuration for a resolver.
         * Specifies which Conflict Detection strategy and Resolution strategy to use when the
         * resolver is invoked.
         */
        var syncConfig: aws.sdk.kotlin.services.appsync.model.SyncConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.FunctionConfiguration) : this() {
            this.dataSourceName = x.dataSourceName
            this.description = x.description
            this.functionArn = x.functionArn
            this.functionId = x.functionId
            this.functionVersion = x.functionVersion
            this.maxBatchSize = x.maxBatchSize
            this.name = x.name
            this.requestMappingTemplate = x.requestMappingTemplate
            this.responseMappingTemplate = x.responseMappingTemplate
            this.syncConfig = x.syncConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.FunctionConfiguration = FunctionConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.SyncConfig] inside the given [block]
         */
        fun syncConfig(block: aws.sdk.kotlin.services.appsync.model.SyncConfig.Builder.() -> kotlin.Unit) {
            this.syncConfig = aws.sdk.kotlin.services.appsync.model.SyncConfig.invoke(block)
        }
    }
}
