// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * Describes a data source.
 */
class DataSource private constructor(builder: Builder) {
    /**
     * The data source Amazon Resource Name (ARN).
     */
    val dataSourceArn: kotlin.String? = builder.dataSourceArn
    /**
     * The description of the data source.
     */
    val description: kotlin.String? = builder.description
    /**
     * DynamoDB settings.
     */
    val dynamodbConfig: aws.sdk.kotlin.services.appsync.model.DynamodbDataSourceConfig? = builder.dynamodbConfig
    /**
     * Amazon OpenSearch Service settings.
     */
    val elasticsearchConfig: aws.sdk.kotlin.services.appsync.model.ElasticsearchDataSourceConfig? = builder.elasticsearchConfig
    /**
     * HTTP endpoint settings.
     */
    val httpConfig: aws.sdk.kotlin.services.appsync.model.HttpDataSourceConfig? = builder.httpConfig
    /**
     * Lambda settings.
     */
    val lambdaConfig: aws.sdk.kotlin.services.appsync.model.LambdaDataSourceConfig? = builder.lambdaConfig
    /**
     * The name of the data source.
     */
    val name: kotlin.String? = builder.name
    /**
     * Amazon OpenSearch Service settings.
     */
    val openSearchServiceConfig: aws.sdk.kotlin.services.appsync.model.OpenSearchServiceDataSourceConfig? = builder.openSearchServiceConfig
    /**
     * Relational database settings.
     */
    val relationalDatabaseConfig: aws.sdk.kotlin.services.appsync.model.RelationalDatabaseDataSourceConfig? = builder.relationalDatabaseConfig
    /**
     * The Identity and Access Management (IAM) service role Amazon Resource Name (ARN)
     * for the data source. The system assumes this role when accessing the data source.
     */
    val serviceRoleArn: kotlin.String? = builder.serviceRoleArn
    /**
     * The type of the data source.
     * AWS_LAMBDA: The data source is an Lambda function.
     * AMAZON_DYNAMODB: The data source is an Amazon DynamoDB table.
     * AMAZON_ELASTICSEARCH: The data source is an
     * Amazon OpenSearch Service domain.
     * AMAZON_OPENSEARCH_SERVICE: The data source is
     * an Amazon OpenSearch Service domain.
     * NONE: There is no data source. Use this type
     * when you want to invoke a GraphQL operation without connecting to a data source, such
     * as when you're performing data transformation with resolvers or invoking a
     * subscription from a mutation.
     * HTTP: The data source is an HTTP
     * endpoint.
     * RELATIONAL_DATABASE: The data source is a
     * relational database.
     */
    val type: aws.sdk.kotlin.services.appsync.model.DataSourceType? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.DataSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataSource(")
        append("dataSourceArn=$dataSourceArn,")
        append("description=$description,")
        append("dynamodbConfig=$dynamodbConfig,")
        append("elasticsearchConfig=$elasticsearchConfig,")
        append("httpConfig=$httpConfig,")
        append("lambdaConfig=$lambdaConfig,")
        append("name=$name,")
        append("openSearchServiceConfig=$openSearchServiceConfig,")
        append("relationalDatabaseConfig=$relationalDatabaseConfig,")
        append("serviceRoleArn=$serviceRoleArn,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSourceArn?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dynamodbConfig?.hashCode() ?: 0)
        result = 31 * result + (elasticsearchConfig?.hashCode() ?: 0)
        result = 31 * result + (httpConfig?.hashCode() ?: 0)
        result = 31 * result + (lambdaConfig?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (openSearchServiceConfig?.hashCode() ?: 0)
        result = 31 * result + (relationalDatabaseConfig?.hashCode() ?: 0)
        result = 31 * result + (serviceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataSource

        if (dataSourceArn != other.dataSourceArn) return false
        if (description != other.description) return false
        if (dynamodbConfig != other.dynamodbConfig) return false
        if (elasticsearchConfig != other.elasticsearchConfig) return false
        if (httpConfig != other.httpConfig) return false
        if (lambdaConfig != other.lambdaConfig) return false
        if (name != other.name) return false
        if (openSearchServiceConfig != other.openSearchServiceConfig) return false
        if (relationalDatabaseConfig != other.relationalDatabaseConfig) return false
        if (serviceRoleArn != other.serviceRoleArn) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.DataSource = Builder(this).apply(block).build()

    class Builder {
        /**
         * The data source Amazon Resource Name (ARN).
         */
        var dataSourceArn: kotlin.String? = null
        /**
         * The description of the data source.
         */
        var description: kotlin.String? = null
        /**
         * DynamoDB settings.
         */
        var dynamodbConfig: aws.sdk.kotlin.services.appsync.model.DynamodbDataSourceConfig? = null
        /**
         * Amazon OpenSearch Service settings.
         */
        var elasticsearchConfig: aws.sdk.kotlin.services.appsync.model.ElasticsearchDataSourceConfig? = null
        /**
         * HTTP endpoint settings.
         */
        var httpConfig: aws.sdk.kotlin.services.appsync.model.HttpDataSourceConfig? = null
        /**
         * Lambda settings.
         */
        var lambdaConfig: aws.sdk.kotlin.services.appsync.model.LambdaDataSourceConfig? = null
        /**
         * The name of the data source.
         */
        var name: kotlin.String? = null
        /**
         * Amazon OpenSearch Service settings.
         */
        var openSearchServiceConfig: aws.sdk.kotlin.services.appsync.model.OpenSearchServiceDataSourceConfig? = null
        /**
         * Relational database settings.
         */
        var relationalDatabaseConfig: aws.sdk.kotlin.services.appsync.model.RelationalDatabaseDataSourceConfig? = null
        /**
         * The Identity and Access Management (IAM) service role Amazon Resource Name (ARN)
         * for the data source. The system assumes this role when accessing the data source.
         */
        var serviceRoleArn: kotlin.String? = null
        /**
         * The type of the data source.
         * AWS_LAMBDA: The data source is an Lambda function.
         * AMAZON_DYNAMODB: The data source is an Amazon DynamoDB table.
         * AMAZON_ELASTICSEARCH: The data source is an
         * Amazon OpenSearch Service domain.
         * AMAZON_OPENSEARCH_SERVICE: The data source is
         * an Amazon OpenSearch Service domain.
         * NONE: There is no data source. Use this type
         * when you want to invoke a GraphQL operation without connecting to a data source, such
         * as when you're performing data transformation with resolvers or invoking a
         * subscription from a mutation.
         * HTTP: The data source is an HTTP
         * endpoint.
         * RELATIONAL_DATABASE: The data source is a
         * relational database.
         */
        var type: aws.sdk.kotlin.services.appsync.model.DataSourceType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.DataSource) : this() {
            this.dataSourceArn = x.dataSourceArn
            this.description = x.description
            this.dynamodbConfig = x.dynamodbConfig
            this.elasticsearchConfig = x.elasticsearchConfig
            this.httpConfig = x.httpConfig
            this.lambdaConfig = x.lambdaConfig
            this.name = x.name
            this.openSearchServiceConfig = x.openSearchServiceConfig
            this.relationalDatabaseConfig = x.relationalDatabaseConfig
            this.serviceRoleArn = x.serviceRoleArn
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.DataSource = DataSource(this)

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.DynamodbDataSourceConfig] inside the given [block]
         */
        fun dynamodbConfig(block: aws.sdk.kotlin.services.appsync.model.DynamodbDataSourceConfig.Builder.() -> kotlin.Unit) {
            this.dynamodbConfig = aws.sdk.kotlin.services.appsync.model.DynamodbDataSourceConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.ElasticsearchDataSourceConfig] inside the given [block]
         */
        fun elasticsearchConfig(block: aws.sdk.kotlin.services.appsync.model.ElasticsearchDataSourceConfig.Builder.() -> kotlin.Unit) {
            this.elasticsearchConfig = aws.sdk.kotlin.services.appsync.model.ElasticsearchDataSourceConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.HttpDataSourceConfig] inside the given [block]
         */
        fun httpConfig(block: aws.sdk.kotlin.services.appsync.model.HttpDataSourceConfig.Builder.() -> kotlin.Unit) {
            this.httpConfig = aws.sdk.kotlin.services.appsync.model.HttpDataSourceConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.LambdaDataSourceConfig] inside the given [block]
         */
        fun lambdaConfig(block: aws.sdk.kotlin.services.appsync.model.LambdaDataSourceConfig.Builder.() -> kotlin.Unit) {
            this.lambdaConfig = aws.sdk.kotlin.services.appsync.model.LambdaDataSourceConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.OpenSearchServiceDataSourceConfig] inside the given [block]
         */
        fun openSearchServiceConfig(block: aws.sdk.kotlin.services.appsync.model.OpenSearchServiceDataSourceConfig.Builder.() -> kotlin.Unit) {
            this.openSearchServiceConfig = aws.sdk.kotlin.services.appsync.model.OpenSearchServiceDataSourceConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.RelationalDatabaseDataSourceConfig] inside the given [block]
         */
        fun relationalDatabaseConfig(block: aws.sdk.kotlin.services.appsync.model.RelationalDatabaseDataSourceConfig.Builder.() -> kotlin.Unit) {
            this.relationalDatabaseConfig = aws.sdk.kotlin.services.appsync.model.RelationalDatabaseDataSourceConfig.invoke(block)
        }
    }
}
