// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



class CreateGraphqlApiRequest private constructor(builder: Builder) {
    /**
     * A list of additional authentication providers for the GraphqlApi
     * API.
     */
    val additionalAuthenticationProviders: List<AdditionalAuthenticationProvider>? = builder.additionalAuthenticationProviders
    /**
     * The authentication type: API key, Identity and Access Management (IAM), OpenID
     * Connect (OIDC), Amazon Cognito user pools, or Lambda.
     */
    val authenticationType: aws.sdk.kotlin.services.appsync.model.AuthenticationType? = builder.authenticationType
    /**
     * Configuration for Lambda function authorization.
     */
    val lambdaAuthorizerConfig: aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig? = builder.lambdaAuthorizerConfig
    /**
     * The Amazon CloudWatch Logs configuration.
     */
    val logConfig: aws.sdk.kotlin.services.appsync.model.LogConfig? = builder.logConfig
    /**
     * A user-supplied name for the GraphqlApi.
     */
    val name: kotlin.String? = builder.name
    /**
     * The OIDC configuration.
     */
    val openIdConnectConfig: aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig? = builder.openIdConnectConfig
    /**
     * A TagMap object.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The Amazon Cognito user pool configuration.
     */
    val userPoolConfig: aws.sdk.kotlin.services.appsync.model.UserPoolConfig? = builder.userPoolConfig
    /**
     * A flag indicating whether to use X-Ray tracing for the
     * GraphqlApi.
     */
    val xrayEnabled: kotlin.Boolean = builder.xrayEnabled

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.CreateGraphqlApiRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateGraphqlApiRequest(")
        append("additionalAuthenticationProviders=$additionalAuthenticationProviders,")
        append("authenticationType=$authenticationType,")
        append("lambdaAuthorizerConfig=$lambdaAuthorizerConfig,")
        append("logConfig=$logConfig,")
        append("name=$name,")
        append("openIdConnectConfig=$openIdConnectConfig,")
        append("tags=$tags,")
        append("userPoolConfig=$userPoolConfig,")
        append("xrayEnabled=$xrayEnabled)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalAuthenticationProviders?.hashCode() ?: 0
        result = 31 * result + (authenticationType?.hashCode() ?: 0)
        result = 31 * result + (lambdaAuthorizerConfig?.hashCode() ?: 0)
        result = 31 * result + (logConfig?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (openIdConnectConfig?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (userPoolConfig?.hashCode() ?: 0)
        result = 31 * result + (xrayEnabled.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateGraphqlApiRequest

        if (additionalAuthenticationProviders != other.additionalAuthenticationProviders) return false
        if (authenticationType != other.authenticationType) return false
        if (lambdaAuthorizerConfig != other.lambdaAuthorizerConfig) return false
        if (logConfig != other.logConfig) return false
        if (name != other.name) return false
        if (openIdConnectConfig != other.openIdConnectConfig) return false
        if (tags != other.tags) return false
        if (userPoolConfig != other.userPoolConfig) return false
        if (xrayEnabled != other.xrayEnabled) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.CreateGraphqlApiRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of additional authentication providers for the GraphqlApi
         * API.
         */
        var additionalAuthenticationProviders: List<AdditionalAuthenticationProvider>? = null
        /**
         * The authentication type: API key, Identity and Access Management (IAM), OpenID
         * Connect (OIDC), Amazon Cognito user pools, or Lambda.
         */
        var authenticationType: aws.sdk.kotlin.services.appsync.model.AuthenticationType? = null
        /**
         * Configuration for Lambda function authorization.
         */
        var lambdaAuthorizerConfig: aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig? = null
        /**
         * The Amazon CloudWatch Logs configuration.
         */
        var logConfig: aws.sdk.kotlin.services.appsync.model.LogConfig? = null
        /**
         * A user-supplied name for the GraphqlApi.
         */
        var name: kotlin.String? = null
        /**
         * The OIDC configuration.
         */
        var openIdConnectConfig: aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig? = null
        /**
         * A TagMap object.
         */
        var tags: Map<String, String>? = null
        /**
         * The Amazon Cognito user pool configuration.
         */
        var userPoolConfig: aws.sdk.kotlin.services.appsync.model.UserPoolConfig? = null
        /**
         * A flag indicating whether to use X-Ray tracing for the
         * GraphqlApi.
         */
        var xrayEnabled: kotlin.Boolean = false

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.CreateGraphqlApiRequest) : this() {
            this.additionalAuthenticationProviders = x.additionalAuthenticationProviders
            this.authenticationType = x.authenticationType
            this.lambdaAuthorizerConfig = x.lambdaAuthorizerConfig
            this.logConfig = x.logConfig
            this.name = x.name
            this.openIdConnectConfig = x.openIdConnectConfig
            this.tags = x.tags
            this.userPoolConfig = x.userPoolConfig
            this.xrayEnabled = x.xrayEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.CreateGraphqlApiRequest = CreateGraphqlApiRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig] inside the given [block]
         */
        fun lambdaAuthorizerConfig(block: aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig.Builder.() -> kotlin.Unit) {
            this.lambdaAuthorizerConfig = aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.LogConfig] inside the given [block]
         */
        fun logConfig(block: aws.sdk.kotlin.services.appsync.model.LogConfig.Builder.() -> kotlin.Unit) {
            this.logConfig = aws.sdk.kotlin.services.appsync.model.LogConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig] inside the given [block]
         */
        fun openIdConnectConfig(block: aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig.Builder.() -> kotlin.Unit) {
            this.openIdConnectConfig = aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.UserPoolConfig] inside the given [block]
         */
        fun userPoolConfig(block: aws.sdk.kotlin.services.appsync.model.UserPoolConfig.Builder.() -> kotlin.Unit) {
            this.userPoolConfig = aws.sdk.kotlin.services.appsync.model.UserPoolConfig.invoke(block)
        }
    }
}
