// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * Represents the input of a CreateApiCache operation.
 */
class CreateApiCacheRequest private constructor(builder: Builder) {
    /**
     * Caching behavior.
     * FULL_REQUEST_CACHING: All requests are fully
     * cached.
     * PER_RESOLVER_CACHING: Individual resolvers
     * that you specify are cached.
     */
    val apiCachingBehavior: aws.sdk.kotlin.services.appsync.model.ApiCachingBehavior? = builder.apiCachingBehavior
    /**
     * The GraphQL API ID.
     */
    val apiId: kotlin.String? = builder.apiId
    /**
     * At-rest encryption flag for cache. You cannot update this setting after creation.
     */
    val atRestEncryptionEnabled: kotlin.Boolean = builder.atRestEncryptionEnabled
    /**
     * Transit encryption flag when connecting to cache. You cannot update this setting after
     * creation.
     */
    val transitEncryptionEnabled: kotlin.Boolean = builder.transitEncryptionEnabled
    /**
     * TTL in seconds for cache entries.
     * Valid values are 1–3,600 seconds.
     */
    val ttl: kotlin.Long = builder.ttl
    /**
     * The cache instance type. Valid values are
     * SMALL
     * MEDIUM
     * LARGE
     * XLARGE
     * LARGE_2X
     * LARGE_4X
     * LARGE_8X (not available in all regions)
     * LARGE_12X
     * Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.
     * The following legacy instance types are available, but their use is discouraged:
     * T2_SMALL: A t2.small instance type.
     * T2_MEDIUM: A t2.medium instance type.
     * R4_LARGE: A r4.large instance type.
     * R4_XLARGE: A r4.xlarge instance type.
     * R4_2XLARGE: A r4.2xlarge instance type.
     * R4_4XLARGE: A r4.4xlarge instance type.
     * R4_8XLARGE: A r4.8xlarge instance type.
     */
    val type: aws.sdk.kotlin.services.appsync.model.ApiCacheType? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.CreateApiCacheRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateApiCacheRequest(")
        append("apiCachingBehavior=$apiCachingBehavior,")
        append("apiId=$apiId,")
        append("atRestEncryptionEnabled=$atRestEncryptionEnabled,")
        append("transitEncryptionEnabled=$transitEncryptionEnabled,")
        append("ttl=$ttl,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiCachingBehavior?.hashCode() ?: 0
        result = 31 * result + (apiId?.hashCode() ?: 0)
        result = 31 * result + (atRestEncryptionEnabled.hashCode())
        result = 31 * result + (transitEncryptionEnabled.hashCode())
        result = 31 * result + (ttl.hashCode())
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateApiCacheRequest

        if (apiCachingBehavior != other.apiCachingBehavior) return false
        if (apiId != other.apiId) return false
        if (atRestEncryptionEnabled != other.atRestEncryptionEnabled) return false
        if (transitEncryptionEnabled != other.transitEncryptionEnabled) return false
        if (ttl != other.ttl) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.CreateApiCacheRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Caching behavior.
         * FULL_REQUEST_CACHING: All requests are fully
         * cached.
         * PER_RESOLVER_CACHING: Individual resolvers
         * that you specify are cached.
         */
        var apiCachingBehavior: aws.sdk.kotlin.services.appsync.model.ApiCachingBehavior? = null
        /**
         * The GraphQL API ID.
         */
        var apiId: kotlin.String? = null
        /**
         * At-rest encryption flag for cache. You cannot update this setting after creation.
         */
        var atRestEncryptionEnabled: kotlin.Boolean = false
        /**
         * Transit encryption flag when connecting to cache. You cannot update this setting after
         * creation.
         */
        var transitEncryptionEnabled: kotlin.Boolean = false
        /**
         * TTL in seconds for cache entries.
         * Valid values are 1–3,600 seconds.
         */
        var ttl: kotlin.Long = 0L
        /**
         * The cache instance type. Valid values are
         * SMALL
         * MEDIUM
         * LARGE
         * XLARGE
         * LARGE_2X
         * LARGE_4X
         * LARGE_8X (not available in all regions)
         * LARGE_12X
         * Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.
         * The following legacy instance types are available, but their use is discouraged:
         * T2_SMALL: A t2.small instance type.
         * T2_MEDIUM: A t2.medium instance type.
         * R4_LARGE: A r4.large instance type.
         * R4_XLARGE: A r4.xlarge instance type.
         * R4_2XLARGE: A r4.2xlarge instance type.
         * R4_4XLARGE: A r4.4xlarge instance type.
         * R4_8XLARGE: A r4.8xlarge instance type.
         */
        var type: aws.sdk.kotlin.services.appsync.model.ApiCacheType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.CreateApiCacheRequest) : this() {
            this.apiCachingBehavior = x.apiCachingBehavior
            this.apiId = x.apiId
            this.atRestEncryptionEnabled = x.atRestEncryptionEnabled
            this.transitEncryptionEnabled = x.transitEncryptionEnabled
            this.ttl = x.ttl
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.CreateApiCacheRequest = CreateApiCacheRequest(this)
    }
}
