// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync

import aws.sdk.kotlin.runtime.auth.signing.AwsSigV4SigningMiddleware
import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.appsync.model.*
import aws.sdk.kotlin.services.appsync.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.middleware.Retry
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "AppSync"
const val ServiceApiVersion: String = "2017-07-25"
const val SdkVersion: String = "0.11.0-beta"

internal class DefaultAppSyncClient(override val config: AppSyncClient.Config) : AppSyncClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Maps an endpoint to your custom domain.
     */
    override suspend fun associateApi(input: AssociateApiRequest): AssociateApiResponse {
        val op = SdkHttpOperation.build<AssociateApiRequest, AssociateApiResponse> {
            serializer = AssociateApiOperationSerializer()
            deserializer = AssociateApiOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateApi"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a cache for the GraphQL API.
     */
    override suspend fun createApiCache(input: CreateApiCacheRequest): CreateApiCacheResponse {
        val op = SdkHttpOperation.build<CreateApiCacheRequest, CreateApiCacheResponse> {
            serializer = CreateApiCacheOperationSerializer()
            deserializer = CreateApiCacheOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateApiCache"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a unique key that you can distribute to clients who invoke your API.
     */
    override suspend fun createApiKey(input: CreateApiKeyRequest): CreateApiKeyResponse {
        val op = SdkHttpOperation.build<CreateApiKeyRequest, CreateApiKeyResponse> {
            serializer = CreateApiKeyOperationSerializer()
            deserializer = CreateApiKeyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateApiKey"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a DataSource object.
     */
    override suspend fun createDataSource(input: CreateDataSourceRequest): CreateDataSourceResponse {
        val op = SdkHttpOperation.build<CreateDataSourceRequest, CreateDataSourceResponse> {
            serializer = CreateDataSourceOperationSerializer()
            deserializer = CreateDataSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDataSource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a custom DomainName object.
     */
    override suspend fun createDomainName(input: CreateDomainNameRequest): CreateDomainNameResponse {
        val op = SdkHttpOperation.build<CreateDomainNameRequest, CreateDomainNameResponse> {
            serializer = CreateDomainNameOperationSerializer()
            deserializer = CreateDomainNameOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDomainName"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Function object.
     * A function is a reusable entity. You can use multiple functions to compose the resolver
     * logic.
     */
    override suspend fun createFunction(input: CreateFunctionRequest): CreateFunctionResponse {
        val op = SdkHttpOperation.build<CreateFunctionRequest, CreateFunctionResponse> {
            serializer = CreateFunctionOperationSerializer()
            deserializer = CreateFunctionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateFunction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a GraphqlApi object.
     */
    override suspend fun createGraphqlApi(input: CreateGraphqlApiRequest): CreateGraphqlApiResponse {
        val op = SdkHttpOperation.build<CreateGraphqlApiRequest, CreateGraphqlApiResponse> {
            serializer = CreateGraphqlApiOperationSerializer()
            deserializer = CreateGraphqlApiOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateGraphqlApi"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Resolver object.
     * A resolver converts incoming requests into a format that a data source can understand,
     * and converts the data source's responses into GraphQL.
     */
    override suspend fun createResolver(input: CreateResolverRequest): CreateResolverResponse {
        val op = SdkHttpOperation.build<CreateResolverRequest, CreateResolverResponse> {
            serializer = CreateResolverOperationSerializer()
            deserializer = CreateResolverOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateResolver"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Type object.
     */
    override suspend fun createType(input: CreateTypeRequest): CreateTypeResponse {
        val op = SdkHttpOperation.build<CreateTypeRequest, CreateTypeResponse> {
            serializer = CreateTypeOperationSerializer()
            deserializer = CreateTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateType"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an ApiCache object.
     */
    override suspend fun deleteApiCache(input: DeleteApiCacheRequest): DeleteApiCacheResponse {
        val op = SdkHttpOperation.build<DeleteApiCacheRequest, DeleteApiCacheResponse> {
            serializer = DeleteApiCacheOperationSerializer()
            deserializer = DeleteApiCacheOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteApiCache"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an API key.
     */
    override suspend fun deleteApiKey(input: DeleteApiKeyRequest): DeleteApiKeyResponse {
        val op = SdkHttpOperation.build<DeleteApiKeyRequest, DeleteApiKeyResponse> {
            serializer = DeleteApiKeyOperationSerializer()
            deserializer = DeleteApiKeyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteApiKey"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a DataSource object.
     */
    override suspend fun deleteDataSource(input: DeleteDataSourceRequest): DeleteDataSourceResponse {
        val op = SdkHttpOperation.build<DeleteDataSourceRequest, DeleteDataSourceResponse> {
            serializer = DeleteDataSourceOperationSerializer()
            deserializer = DeleteDataSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDataSource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a custom DomainName object.
     */
    override suspend fun deleteDomainName(input: DeleteDomainNameRequest): DeleteDomainNameResponse {
        val op = SdkHttpOperation.build<DeleteDomainNameRequest, DeleteDomainNameResponse> {
            serializer = DeleteDomainNameOperationSerializer()
            deserializer = DeleteDomainNameOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDomainName"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a Function.
     */
    override suspend fun deleteFunction(input: DeleteFunctionRequest): DeleteFunctionResponse {
        val op = SdkHttpOperation.build<DeleteFunctionRequest, DeleteFunctionResponse> {
            serializer = DeleteFunctionOperationSerializer()
            deserializer = DeleteFunctionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteFunction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a GraphqlApi object.
     */
    override suspend fun deleteGraphqlApi(input: DeleteGraphqlApiRequest): DeleteGraphqlApiResponse {
        val op = SdkHttpOperation.build<DeleteGraphqlApiRequest, DeleteGraphqlApiResponse> {
            serializer = DeleteGraphqlApiOperationSerializer()
            deserializer = DeleteGraphqlApiOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteGraphqlApi"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a Resolver object.
     */
    override suspend fun deleteResolver(input: DeleteResolverRequest): DeleteResolverResponse {
        val op = SdkHttpOperation.build<DeleteResolverRequest, DeleteResolverResponse> {
            serializer = DeleteResolverOperationSerializer()
            deserializer = DeleteResolverOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteResolver"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a Type object.
     */
    override suspend fun deleteType(input: DeleteTypeRequest): DeleteTypeResponse {
        val op = SdkHttpOperation.build<DeleteTypeRequest, DeleteTypeResponse> {
            serializer = DeleteTypeOperationSerializer()
            deserializer = DeleteTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteType"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes an ApiAssociation object from a custom domain.
     */
    override suspend fun disassociateApi(input: DisassociateApiRequest): DisassociateApiResponse {
        val op = SdkHttpOperation.build<DisassociateApiRequest, DisassociateApiResponse> {
            serializer = DisassociateApiOperationSerializer()
            deserializer = DisassociateApiOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateApi"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Flushes an ApiCache object.
     */
    override suspend fun flushApiCache(input: FlushApiCacheRequest): FlushApiCacheResponse {
        val op = SdkHttpOperation.build<FlushApiCacheRequest, FlushApiCacheResponse> {
            serializer = FlushApiCacheOperationSerializer()
            deserializer = FlushApiCacheOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "FlushApiCache"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves an ApiAssociation object.
     */
    override suspend fun getApiAssociation(input: GetApiAssociationRequest): GetApiAssociationResponse {
        val op = SdkHttpOperation.build<GetApiAssociationRequest, GetApiAssociationResponse> {
            serializer = GetApiAssociationOperationSerializer()
            deserializer = GetApiAssociationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetApiAssociation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves an ApiCache object.
     */
    override suspend fun getApiCache(input: GetApiCacheRequest): GetApiCacheResponse {
        val op = SdkHttpOperation.build<GetApiCacheRequest, GetApiCacheResponse> {
            serializer = GetApiCacheOperationSerializer()
            deserializer = GetApiCacheOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetApiCache"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a DataSource object.
     */
    override suspend fun getDataSource(input: GetDataSourceRequest): GetDataSourceResponse {
        val op = SdkHttpOperation.build<GetDataSourceRequest, GetDataSourceResponse> {
            serializer = GetDataSourceOperationSerializer()
            deserializer = GetDataSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDataSource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a custom DomainName object.
     */
    override suspend fun getDomainName(input: GetDomainNameRequest): GetDomainNameResponse {
        val op = SdkHttpOperation.build<GetDomainNameRequest, GetDomainNameResponse> {
            serializer = GetDomainNameOperationSerializer()
            deserializer = GetDomainNameOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDomainName"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get a Function.
     */
    override suspend fun getFunction(input: GetFunctionRequest): GetFunctionResponse {
        val op = SdkHttpOperation.build<GetFunctionRequest, GetFunctionResponse> {
            serializer = GetFunctionOperationSerializer()
            deserializer = GetFunctionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFunction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a GraphqlApi object.
     */
    override suspend fun getGraphqlApi(input: GetGraphqlApiRequest): GetGraphqlApiResponse {
        val op = SdkHttpOperation.build<GetGraphqlApiRequest, GetGraphqlApiResponse> {
            serializer = GetGraphqlApiOperationSerializer()
            deserializer = GetGraphqlApiOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetGraphqlApi"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the introspection schema for a GraphQL API.
     */
    override suspend fun getIntrospectionSchema(input: GetIntrospectionSchemaRequest): GetIntrospectionSchemaResponse {
        val op = SdkHttpOperation.build<GetIntrospectionSchemaRequest, GetIntrospectionSchemaResponse> {
            serializer = GetIntrospectionSchemaOperationSerializer()
            deserializer = GetIntrospectionSchemaOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetIntrospectionSchema"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a Resolver object.
     */
    override suspend fun getResolver(input: GetResolverRequest): GetResolverResponse {
        val op = SdkHttpOperation.build<GetResolverRequest, GetResolverResponse> {
            serializer = GetResolverOperationSerializer()
            deserializer = GetResolverOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetResolver"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the current status of a schema creation operation.
     */
    override suspend fun getSchemaCreationStatus(input: GetSchemaCreationStatusRequest): GetSchemaCreationStatusResponse {
        val op = SdkHttpOperation.build<GetSchemaCreationStatusRequest, GetSchemaCreationStatusResponse> {
            serializer = GetSchemaCreationStatusOperationSerializer()
            deserializer = GetSchemaCreationStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSchemaCreationStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a Type object.
     */
    override suspend fun getType(input: GetTypeRequest): GetTypeResponse {
        val op = SdkHttpOperation.build<GetTypeRequest, GetTypeResponse> {
            serializer = GetTypeOperationSerializer()
            deserializer = GetTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetType"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the API keys for a given API.
     * API keys are deleted automatically 60 days after they expire. However, they may still
     * be included in the response until they have actually been deleted. You can safely call
     * DeleteApiKey to manually delete a key before it's automatically
     * deleted.
     */
    override suspend fun listApiKeys(input: ListApiKeysRequest): ListApiKeysResponse {
        val op = SdkHttpOperation.build<ListApiKeysRequest, ListApiKeysResponse> {
            serializer = ListApiKeysOperationSerializer()
            deserializer = ListApiKeysOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListApiKeys"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the data sources for a given API.
     */
    override suspend fun listDataSources(input: ListDataSourcesRequest): ListDataSourcesResponse {
        val op = SdkHttpOperation.build<ListDataSourcesRequest, ListDataSourcesResponse> {
            serializer = ListDataSourcesOperationSerializer()
            deserializer = ListDataSourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDataSources"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists multiple custom domain names.
     */
    override suspend fun listDomainNames(input: ListDomainNamesRequest): ListDomainNamesResponse {
        val op = SdkHttpOperation.build<ListDomainNamesRequest, ListDomainNamesResponse> {
            serializer = ListDomainNamesOperationSerializer()
            deserializer = ListDomainNamesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDomainNames"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List multiple functions.
     */
    override suspend fun listFunctions(input: ListFunctionsRequest): ListFunctionsResponse {
        val op = SdkHttpOperation.build<ListFunctionsRequest, ListFunctionsResponse> {
            serializer = ListFunctionsOperationSerializer()
            deserializer = ListFunctionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFunctions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists your GraphQL APIs.
     */
    override suspend fun listGraphqlApis(input: ListGraphqlApisRequest): ListGraphqlApisResponse {
        val op = SdkHttpOperation.build<ListGraphqlApisRequest, ListGraphqlApisResponse> {
            serializer = ListGraphqlApisOperationSerializer()
            deserializer = ListGraphqlApisOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListGraphqlApis"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the resolvers for a given API and type.
     */
    override suspend fun listResolvers(input: ListResolversRequest): ListResolversResponse {
        val op = SdkHttpOperation.build<ListResolversRequest, ListResolversResponse> {
            serializer = ListResolversOperationSerializer()
            deserializer = ListResolversOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListResolvers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List the resolvers that are associated with a specific function.
     */
    override suspend fun listResolversByFunction(input: ListResolversByFunctionRequest): ListResolversByFunctionResponse {
        val op = SdkHttpOperation.build<ListResolversByFunctionRequest, ListResolversByFunctionResponse> {
            serializer = ListResolversByFunctionOperationSerializer()
            deserializer = ListResolversByFunctionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListResolversByFunction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags for a resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the types for a given API.
     */
    override suspend fun listTypes(input: ListTypesRequest): ListTypesResponse {
        val op = SdkHttpOperation.build<ListTypesRequest, ListTypesResponse> {
            serializer = ListTypesOperationSerializer()
            deserializer = ListTypesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTypes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds a new schema to your GraphQL API.
     * This operation is asynchronous. Use  to
     * determine when it has completed.
     */
    override suspend fun startSchemaCreation(input: StartSchemaCreationRequest): StartSchemaCreationResponse {
        val op = SdkHttpOperation.build<StartSchemaCreationRequest, StartSchemaCreationResponse> {
            serializer = StartSchemaCreationOperationSerializer()
            deserializer = StartSchemaCreationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartSchemaCreation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Tags a resource with user-supplied tags.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Untags a resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the cache for the GraphQL API.
     */
    override suspend fun updateApiCache(input: UpdateApiCacheRequest): UpdateApiCacheResponse {
        val op = SdkHttpOperation.build<UpdateApiCacheRequest, UpdateApiCacheResponse> {
            serializer = UpdateApiCacheOperationSerializer()
            deserializer = UpdateApiCacheOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateApiCache"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an API key. You can update the key as long as it's not deleted.
     */
    override suspend fun updateApiKey(input: UpdateApiKeyRequest): UpdateApiKeyResponse {
        val op = SdkHttpOperation.build<UpdateApiKeyRequest, UpdateApiKeyResponse> {
            serializer = UpdateApiKeyOperationSerializer()
            deserializer = UpdateApiKeyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateApiKey"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a DataSource object.
     */
    override suspend fun updateDataSource(input: UpdateDataSourceRequest): UpdateDataSourceResponse {
        val op = SdkHttpOperation.build<UpdateDataSourceRequest, UpdateDataSourceResponse> {
            serializer = UpdateDataSourceOperationSerializer()
            deserializer = UpdateDataSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDataSource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a custom DomainName object.
     */
    override suspend fun updateDomainName(input: UpdateDomainNameRequest): UpdateDomainNameResponse {
        val op = SdkHttpOperation.build<UpdateDomainNameRequest, UpdateDomainNameResponse> {
            serializer = UpdateDomainNameOperationSerializer()
            deserializer = UpdateDomainNameOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDomainName"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a Function object.
     */
    override suspend fun updateFunction(input: UpdateFunctionRequest): UpdateFunctionResponse {
        val op = SdkHttpOperation.build<UpdateFunctionRequest, UpdateFunctionResponse> {
            serializer = UpdateFunctionOperationSerializer()
            deserializer = UpdateFunctionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateFunction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a GraphqlApi object.
     */
    override suspend fun updateGraphqlApi(input: UpdateGraphqlApiRequest): UpdateGraphqlApiResponse {
        val op = SdkHttpOperation.build<UpdateGraphqlApiRequest, UpdateGraphqlApiResponse> {
            serializer = UpdateGraphqlApiOperationSerializer()
            deserializer = UpdateGraphqlApiOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateGraphqlApi"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a Resolver object.
     */
    override suspend fun updateResolver(input: UpdateResolverRequest): UpdateResolverResponse {
        val op = SdkHttpOperation.build<UpdateResolverRequest, UpdateResolverResponse> {
            serializer = UpdateResolverOperationSerializer()
            deserializer = UpdateResolverOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateResolver"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a Type object.
     */
    override suspend fun updateType(input: UpdateTypeRequest): UpdateTypeResponse {
        val op = SdkHttpOperation.build<UpdateTypeRequest, UpdateTypeResponse> {
            serializer = UpdateTypeOperationSerializer()
            deserializer = UpdateTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateType"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "appsync"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
