// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.appsync.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.appsync.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * AppSync provides API actions for creating and interacting with data
 * sources using GraphQL from your application.
 */
interface AppSyncClient : SdkClient {

    override val serviceName: String
        get() = "AppSync"
    /**
     * AppSyncClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.Builder.() -> Unit = {}): AppSyncClient {
            val config = Config.Builder().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
                sdkLogMode = sharedConfig?.sdkLogMode ?: SdkLogMode.Default
            }.apply(block).build()
            return DefaultAppSyncClient(config)
        }

        operator fun invoke(config: Config): AppSyncClient = DefaultAppSyncClient(config)

        /**
         * Construct a [AppSyncClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): AppSyncClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return AppSyncClient(sharedConfig)
        }
    }

    class Config private constructor(builder: Builder): AwsClientConfig, HttpClientConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Maps an endpoint to your custom domain.
     */
    suspend fun associateApi(input: AssociateApiRequest): AssociateApiResponse

    /**
     * Maps an endpoint to your custom domain.
     */
    suspend fun associateApi(block: AssociateApiRequest.Builder.() -> Unit) = associateApi(AssociateApiRequest.Builder().apply(block).build())

    /**
     * Creates a cache for the GraphQL API.
     */
    suspend fun createApiCache(input: CreateApiCacheRequest): CreateApiCacheResponse

    /**
     * Creates a cache for the GraphQL API.
     */
    suspend fun createApiCache(block: CreateApiCacheRequest.Builder.() -> Unit) = createApiCache(CreateApiCacheRequest.Builder().apply(block).build())

    /**
     * Creates a unique key that you can distribute to clients who invoke your API.
     */
    suspend fun createApiKey(input: CreateApiKeyRequest): CreateApiKeyResponse

    /**
     * Creates a unique key that you can distribute to clients who invoke your API.
     */
    suspend fun createApiKey(block: CreateApiKeyRequest.Builder.() -> Unit) = createApiKey(CreateApiKeyRequest.Builder().apply(block).build())

    /**
     * Creates a DataSource object.
     */
    suspend fun createDataSource(input: CreateDataSourceRequest): CreateDataSourceResponse

    /**
     * Creates a DataSource object.
     */
    suspend fun createDataSource(block: CreateDataSourceRequest.Builder.() -> Unit) = createDataSource(CreateDataSourceRequest.Builder().apply(block).build())

    /**
     * Creates a custom DomainName object.
     */
    suspend fun createDomainName(input: CreateDomainNameRequest): CreateDomainNameResponse

    /**
     * Creates a custom DomainName object.
     */
    suspend fun createDomainName(block: CreateDomainNameRequest.Builder.() -> Unit) = createDomainName(CreateDomainNameRequest.Builder().apply(block).build())

    /**
     * Creates a Function object.
     * A function is a reusable entity. You can use multiple functions to compose the resolver
     * logic.
     */
    suspend fun createFunction(input: CreateFunctionRequest): CreateFunctionResponse

    /**
     * Creates a Function object.
     * A function is a reusable entity. You can use multiple functions to compose the resolver
     * logic.
     */
    suspend fun createFunction(block: CreateFunctionRequest.Builder.() -> Unit) = createFunction(CreateFunctionRequest.Builder().apply(block).build())

    /**
     * Creates a GraphqlApi object.
     */
    suspend fun createGraphqlApi(input: CreateGraphqlApiRequest): CreateGraphqlApiResponse

    /**
     * Creates a GraphqlApi object.
     */
    suspend fun createGraphqlApi(block: CreateGraphqlApiRequest.Builder.() -> Unit) = createGraphqlApi(CreateGraphqlApiRequest.Builder().apply(block).build())

    /**
     * Creates a Resolver object.
     * A resolver converts incoming requests into a format that a data source can understand,
     * and converts the data source's responses into GraphQL.
     */
    suspend fun createResolver(input: CreateResolverRequest): CreateResolverResponse

    /**
     * Creates a Resolver object.
     * A resolver converts incoming requests into a format that a data source can understand,
     * and converts the data source's responses into GraphQL.
     */
    suspend fun createResolver(block: CreateResolverRequest.Builder.() -> Unit) = createResolver(CreateResolverRequest.Builder().apply(block).build())

    /**
     * Creates a Type object.
     */
    suspend fun createType(input: CreateTypeRequest): CreateTypeResponse

    /**
     * Creates a Type object.
     */
    suspend fun createType(block: CreateTypeRequest.Builder.() -> Unit) = createType(CreateTypeRequest.Builder().apply(block).build())

    /**
     * Deletes an ApiCache object.
     */
    suspend fun deleteApiCache(input: DeleteApiCacheRequest): DeleteApiCacheResponse

    /**
     * Deletes an ApiCache object.
     */
    suspend fun deleteApiCache(block: DeleteApiCacheRequest.Builder.() -> Unit) = deleteApiCache(DeleteApiCacheRequest.Builder().apply(block).build())

    /**
     * Deletes an API key.
     */
    suspend fun deleteApiKey(input: DeleteApiKeyRequest): DeleteApiKeyResponse

    /**
     * Deletes an API key.
     */
    suspend fun deleteApiKey(block: DeleteApiKeyRequest.Builder.() -> Unit) = deleteApiKey(DeleteApiKeyRequest.Builder().apply(block).build())

    /**
     * Deletes a DataSource object.
     */
    suspend fun deleteDataSource(input: DeleteDataSourceRequest): DeleteDataSourceResponse

    /**
     * Deletes a DataSource object.
     */
    suspend fun deleteDataSource(block: DeleteDataSourceRequest.Builder.() -> Unit) = deleteDataSource(DeleteDataSourceRequest.Builder().apply(block).build())

    /**
     * Deletes a custom DomainName object.
     */
    suspend fun deleteDomainName(input: DeleteDomainNameRequest): DeleteDomainNameResponse

    /**
     * Deletes a custom DomainName object.
     */
    suspend fun deleteDomainName(block: DeleteDomainNameRequest.Builder.() -> Unit) = deleteDomainName(DeleteDomainNameRequest.Builder().apply(block).build())

    /**
     * Deletes a Function.
     */
    suspend fun deleteFunction(input: DeleteFunctionRequest): DeleteFunctionResponse

    /**
     * Deletes a Function.
     */
    suspend fun deleteFunction(block: DeleteFunctionRequest.Builder.() -> Unit) = deleteFunction(DeleteFunctionRequest.Builder().apply(block).build())

    /**
     * Deletes a GraphqlApi object.
     */
    suspend fun deleteGraphqlApi(input: DeleteGraphqlApiRequest): DeleteGraphqlApiResponse

    /**
     * Deletes a GraphqlApi object.
     */
    suspend fun deleteGraphqlApi(block: DeleteGraphqlApiRequest.Builder.() -> Unit) = deleteGraphqlApi(DeleteGraphqlApiRequest.Builder().apply(block).build())

    /**
     * Deletes a Resolver object.
     */
    suspend fun deleteResolver(input: DeleteResolverRequest): DeleteResolverResponse

    /**
     * Deletes a Resolver object.
     */
    suspend fun deleteResolver(block: DeleteResolverRequest.Builder.() -> Unit) = deleteResolver(DeleteResolverRequest.Builder().apply(block).build())

    /**
     * Deletes a Type object.
     */
    suspend fun deleteType(input: DeleteTypeRequest): DeleteTypeResponse

    /**
     * Deletes a Type object.
     */
    suspend fun deleteType(block: DeleteTypeRequest.Builder.() -> Unit) = deleteType(DeleteTypeRequest.Builder().apply(block).build())

    /**
     * Removes an ApiAssociation object from a custom domain.
     */
    suspend fun disassociateApi(input: DisassociateApiRequest): DisassociateApiResponse

    /**
     * Removes an ApiAssociation object from a custom domain.
     */
    suspend fun disassociateApi(block: DisassociateApiRequest.Builder.() -> Unit) = disassociateApi(DisassociateApiRequest.Builder().apply(block).build())

    /**
     * Flushes an ApiCache object.
     */
    suspend fun flushApiCache(input: FlushApiCacheRequest): FlushApiCacheResponse

    /**
     * Flushes an ApiCache object.
     */
    suspend fun flushApiCache(block: FlushApiCacheRequest.Builder.() -> Unit) = flushApiCache(FlushApiCacheRequest.Builder().apply(block).build())

    /**
     * Retrieves an ApiAssociation object.
     */
    suspend fun getApiAssociation(input: GetApiAssociationRequest): GetApiAssociationResponse

    /**
     * Retrieves an ApiAssociation object.
     */
    suspend fun getApiAssociation(block: GetApiAssociationRequest.Builder.() -> Unit) = getApiAssociation(GetApiAssociationRequest.Builder().apply(block).build())

    /**
     * Retrieves an ApiCache object.
     */
    suspend fun getApiCache(input: GetApiCacheRequest): GetApiCacheResponse

    /**
     * Retrieves an ApiCache object.
     */
    suspend fun getApiCache(block: GetApiCacheRequest.Builder.() -> Unit) = getApiCache(GetApiCacheRequest.Builder().apply(block).build())

    /**
     * Retrieves a DataSource object.
     */
    suspend fun getDataSource(input: GetDataSourceRequest): GetDataSourceResponse

    /**
     * Retrieves a DataSource object.
     */
    suspend fun getDataSource(block: GetDataSourceRequest.Builder.() -> Unit) = getDataSource(GetDataSourceRequest.Builder().apply(block).build())

    /**
     * Retrieves a custom DomainName object.
     */
    suspend fun getDomainName(input: GetDomainNameRequest): GetDomainNameResponse

    /**
     * Retrieves a custom DomainName object.
     */
    suspend fun getDomainName(block: GetDomainNameRequest.Builder.() -> Unit) = getDomainName(GetDomainNameRequest.Builder().apply(block).build())

    /**
     * Get a Function.
     */
    suspend fun getFunction(input: GetFunctionRequest): GetFunctionResponse

    /**
     * Get a Function.
     */
    suspend fun getFunction(block: GetFunctionRequest.Builder.() -> Unit) = getFunction(GetFunctionRequest.Builder().apply(block).build())

    /**
     * Retrieves a GraphqlApi object.
     */
    suspend fun getGraphqlApi(input: GetGraphqlApiRequest): GetGraphqlApiResponse

    /**
     * Retrieves a GraphqlApi object.
     */
    suspend fun getGraphqlApi(block: GetGraphqlApiRequest.Builder.() -> Unit) = getGraphqlApi(GetGraphqlApiRequest.Builder().apply(block).build())

    /**
     * Retrieves the introspection schema for a GraphQL API.
     */
    suspend fun getIntrospectionSchema(input: GetIntrospectionSchemaRequest): GetIntrospectionSchemaResponse

    /**
     * Retrieves the introspection schema for a GraphQL API.
     */
    suspend fun getIntrospectionSchema(block: GetIntrospectionSchemaRequest.Builder.() -> Unit) = getIntrospectionSchema(GetIntrospectionSchemaRequest.Builder().apply(block).build())

    /**
     * Retrieves a Resolver object.
     */
    suspend fun getResolver(input: GetResolverRequest): GetResolverResponse

    /**
     * Retrieves a Resolver object.
     */
    suspend fun getResolver(block: GetResolverRequest.Builder.() -> Unit) = getResolver(GetResolverRequest.Builder().apply(block).build())

    /**
     * Retrieves the current status of a schema creation operation.
     */
    suspend fun getSchemaCreationStatus(input: GetSchemaCreationStatusRequest): GetSchemaCreationStatusResponse

    /**
     * Retrieves the current status of a schema creation operation.
     */
    suspend fun getSchemaCreationStatus(block: GetSchemaCreationStatusRequest.Builder.() -> Unit) = getSchemaCreationStatus(GetSchemaCreationStatusRequest.Builder().apply(block).build())

    /**
     * Retrieves a Type object.
     */
    suspend fun getType(input: GetTypeRequest): GetTypeResponse

    /**
     * Retrieves a Type object.
     */
    suspend fun getType(block: GetTypeRequest.Builder.() -> Unit) = getType(GetTypeRequest.Builder().apply(block).build())

    /**
     * Lists the API keys for a given API.
     * API keys are deleted automatically 60 days after they expire. However, they may still
     * be included in the response until they have actually been deleted. You can safely call
     * DeleteApiKey to manually delete a key before it's automatically
     * deleted.
     */
    suspend fun listApiKeys(input: ListApiKeysRequest): ListApiKeysResponse

    /**
     * Lists the API keys for a given API.
     * API keys are deleted automatically 60 days after they expire. However, they may still
     * be included in the response until they have actually been deleted. You can safely call
     * DeleteApiKey to manually delete a key before it's automatically
     * deleted.
     */
    suspend fun listApiKeys(block: ListApiKeysRequest.Builder.() -> Unit) = listApiKeys(ListApiKeysRequest.Builder().apply(block).build())

    /**
     * Lists the data sources for a given API.
     */
    suspend fun listDataSources(input: ListDataSourcesRequest): ListDataSourcesResponse

    /**
     * Lists the data sources for a given API.
     */
    suspend fun listDataSources(block: ListDataSourcesRequest.Builder.() -> Unit) = listDataSources(ListDataSourcesRequest.Builder().apply(block).build())

    /**
     * Lists multiple custom domain names.
     */
    suspend fun listDomainNames(input: ListDomainNamesRequest): ListDomainNamesResponse

    /**
     * Lists multiple custom domain names.
     */
    suspend fun listDomainNames(block: ListDomainNamesRequest.Builder.() -> Unit) = listDomainNames(ListDomainNamesRequest.Builder().apply(block).build())

    /**
     * List multiple functions.
     */
    suspend fun listFunctions(input: ListFunctionsRequest): ListFunctionsResponse

    /**
     * List multiple functions.
     */
    suspend fun listFunctions(block: ListFunctionsRequest.Builder.() -> Unit) = listFunctions(ListFunctionsRequest.Builder().apply(block).build())

    /**
     * Lists your GraphQL APIs.
     */
    suspend fun listGraphqlApis(input: ListGraphqlApisRequest): ListGraphqlApisResponse

    /**
     * Lists your GraphQL APIs.
     */
    suspend fun listGraphqlApis(block: ListGraphqlApisRequest.Builder.() -> Unit) = listGraphqlApis(ListGraphqlApisRequest.Builder().apply(block).build())

    /**
     * Lists the resolvers for a given API and type.
     */
    suspend fun listResolvers(input: ListResolversRequest): ListResolversResponse

    /**
     * Lists the resolvers for a given API and type.
     */
    suspend fun listResolvers(block: ListResolversRequest.Builder.() -> Unit) = listResolvers(ListResolversRequest.Builder().apply(block).build())

    /**
     * List the resolvers that are associated with a specific function.
     */
    suspend fun listResolversByFunction(input: ListResolversByFunctionRequest): ListResolversByFunctionResponse

    /**
     * List the resolvers that are associated with a specific function.
     */
    suspend fun listResolversByFunction(block: ListResolversByFunctionRequest.Builder.() -> Unit) = listResolversByFunction(ListResolversByFunctionRequest.Builder().apply(block).build())

    /**
     * Lists the tags for a resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the tags for a resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Lists the types for a given API.
     */
    suspend fun listTypes(input: ListTypesRequest): ListTypesResponse

    /**
     * Lists the types for a given API.
     */
    suspend fun listTypes(block: ListTypesRequest.Builder.() -> Unit) = listTypes(ListTypesRequest.Builder().apply(block).build())

    /**
     * Adds a new schema to your GraphQL API.
     * This operation is asynchronous. Use  to
     * determine when it has completed.
     */
    suspend fun startSchemaCreation(input: StartSchemaCreationRequest): StartSchemaCreationResponse

    /**
     * Adds a new schema to your GraphQL API.
     * This operation is asynchronous. Use  to
     * determine when it has completed.
     */
    suspend fun startSchemaCreation(block: StartSchemaCreationRequest.Builder.() -> Unit) = startSchemaCreation(StartSchemaCreationRequest.Builder().apply(block).build())

    /**
     * Tags a resource with user-supplied tags.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Tags a resource with user-supplied tags.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Untags a resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Untags a resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates the cache for the GraphQL API.
     */
    suspend fun updateApiCache(input: UpdateApiCacheRequest): UpdateApiCacheResponse

    /**
     * Updates the cache for the GraphQL API.
     */
    suspend fun updateApiCache(block: UpdateApiCacheRequest.Builder.() -> Unit) = updateApiCache(UpdateApiCacheRequest.Builder().apply(block).build())

    /**
     * Updates an API key. You can update the key as long as it's not deleted.
     */
    suspend fun updateApiKey(input: UpdateApiKeyRequest): UpdateApiKeyResponse

    /**
     * Updates an API key. You can update the key as long as it's not deleted.
     */
    suspend fun updateApiKey(block: UpdateApiKeyRequest.Builder.() -> Unit) = updateApiKey(UpdateApiKeyRequest.Builder().apply(block).build())

    /**
     * Updates a DataSource object.
     */
    suspend fun updateDataSource(input: UpdateDataSourceRequest): UpdateDataSourceResponse

    /**
     * Updates a DataSource object.
     */
    suspend fun updateDataSource(block: UpdateDataSourceRequest.Builder.() -> Unit) = updateDataSource(UpdateDataSourceRequest.Builder().apply(block).build())

    /**
     * Updates a custom DomainName object.
     */
    suspend fun updateDomainName(input: UpdateDomainNameRequest): UpdateDomainNameResponse

    /**
     * Updates a custom DomainName object.
     */
    suspend fun updateDomainName(block: UpdateDomainNameRequest.Builder.() -> Unit) = updateDomainName(UpdateDomainNameRequest.Builder().apply(block).build())

    /**
     * Updates a Function object.
     */
    suspend fun updateFunction(input: UpdateFunctionRequest): UpdateFunctionResponse

    /**
     * Updates a Function object.
     */
    suspend fun updateFunction(block: UpdateFunctionRequest.Builder.() -> Unit) = updateFunction(UpdateFunctionRequest.Builder().apply(block).build())

    /**
     * Updates a GraphqlApi object.
     */
    suspend fun updateGraphqlApi(input: UpdateGraphqlApiRequest): UpdateGraphqlApiResponse

    /**
     * Updates a GraphqlApi object.
     */
    suspend fun updateGraphqlApi(block: UpdateGraphqlApiRequest.Builder.() -> Unit) = updateGraphqlApi(UpdateGraphqlApiRequest.Builder().apply(block).build())

    /**
     * Updates a Resolver object.
     */
    suspend fun updateResolver(input: UpdateResolverRequest): UpdateResolverResponse

    /**
     * Updates a Resolver object.
     */
    suspend fun updateResolver(block: UpdateResolverRequest.Builder.() -> Unit) = updateResolver(UpdateResolverRequest.Builder().apply(block).build())

    /**
     * Updates a Type object.
     */
    suspend fun updateType(input: UpdateTypeRequest): UpdateTypeResponse

    /**
     * Updates a Type object.
     */
    suspend fun updateType(block: UpdateTypeRequest.Builder.() -> Unit) = updateType(UpdateTypeRequest.Builder().apply(block).build())
}
