// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.serde

import aws.sdk.kotlin.services.appsync.model.ApiCacheType
import aws.sdk.kotlin.services.appsync.model.ApiCachingBehavior
import aws.sdk.kotlin.services.appsync.model.CacheHealthMetricsConfig
import aws.sdk.kotlin.services.appsync.model.UpdateApiCacheRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateApiCacheOperationSerializer: HttpSerializer.NonStreaming<UpdateApiCacheRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateApiCacheRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.apiId) { "apiId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v1"))
                add(PercentEncoding.Path.encode("apis"))
                add(PercentEncoding.SmithyLabel.encode(input.apiId))
                add(PercentEncoding.Path.encode("ApiCaches"))
                add(PercentEncoding.Path.encode("update"))
            }
        }

        val payload = serializeUpdateApiCacheOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateApiCacheOperationBody(context: ExecutionContext, input: UpdateApiCacheRequest): ByteArray {
    val serializer = JsonSerializer()
    val APICACHINGBEHAVIOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("apiCachingBehavior"))
    val HEALTHMETRICSCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("healthMetricsConfig"))
    val TTL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("ttl"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APICACHINGBEHAVIOR_DESCRIPTOR)
        field(HEALTHMETRICSCONFIG_DESCRIPTOR)
        field(TTL_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.apiCachingBehavior?.let { field(APICACHINGBEHAVIOR_DESCRIPTOR, it.value) }
        input.healthMetricsConfig?.let { field(HEALTHMETRICSCONFIG_DESCRIPTOR, it.value) }
        input.ttl?.let { field(TTL_DESCRIPTOR, it) }
        input.type?.let { field(TYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
