// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the configuration of a source API. A source API is a GraphQL API that is linked to a merged API. There can be multiple source APIs attached to each merged API. When linked to a merged API, the source API's schema, data sources, and resolvers will be combined with other linked source API data to form a new, singular API.
 *
 * Source APIs can originate from your account or from other accounts via Amazon Web Services Resource Access Manager. For more information about sharing resources from other accounts, see [What is Amazon Web Services Resource Access Manager?](https://docs.aws.amazon.com/ram/latest/userguide/what-is.html) in the *Amazon Web Services Resource Access Manager* guide.
 */
public class SourceApiAssociation private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the source API association.
     */
    public val associationArn: kotlin.String? = builder.associationArn
    /**
     * The ID generated by the AppSync service for the source API association.
     */
    public val associationId: kotlin.String? = builder.associationId
    /**
     * The description field.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The datetime value of the last successful merge of the source API association. The result will be in UTC format and your local time zone.
     */
    public val lastSuccessfulMergeDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastSuccessfulMergeDate
    /**
     * The Amazon Resource Name (ARN) of the AppSync Merged API.
     */
    public val mergedApiArn: kotlin.String? = builder.mergedApiArn
    /**
     * The ID of the AppSync Merged API.
     */
    public val mergedApiId: kotlin.String? = builder.mergedApiId
    /**
     * The Amazon Resource Name (ARN) of the AppSync source API.
     */
    public val sourceApiArn: kotlin.String? = builder.sourceApiArn
    /**
     * The `SourceApiAssociationConfig` object data.
     */
    public val sourceApiAssociationConfig: aws.sdk.kotlin.services.appsync.model.SourceApiAssociationConfig? = builder.sourceApiAssociationConfig
    /**
     * The state of the source API association.
     */
    public val sourceApiAssociationStatus: aws.sdk.kotlin.services.appsync.model.SourceApiAssociationStatus? = builder.sourceApiAssociationStatus
    /**
     * The detailed message related to the current state of the source API association.
     */
    public val sourceApiAssociationStatusDetail: kotlin.String? = builder.sourceApiAssociationStatusDetail
    /**
     * The ID of the AppSync source API.
     */
    public val sourceApiId: kotlin.String? = builder.sourceApiId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.SourceApiAssociation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SourceApiAssociation(")
        append("associationArn=$associationArn,")
        append("associationId=$associationId,")
        append("description=$description,")
        append("lastSuccessfulMergeDate=$lastSuccessfulMergeDate,")
        append("mergedApiArn=$mergedApiArn,")
        append("mergedApiId=$mergedApiId,")
        append("sourceApiArn=$sourceApiArn,")
        append("sourceApiAssociationConfig=$sourceApiAssociationConfig,")
        append("sourceApiAssociationStatus=$sourceApiAssociationStatus,")
        append("sourceApiAssociationStatusDetail=$sourceApiAssociationStatusDetail,")
        append("sourceApiId=$sourceApiId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationArn?.hashCode() ?: 0
        result = 31 * result + (this.associationId?.hashCode() ?: 0)
        result = 31 * result + (this.description?.hashCode() ?: 0)
        result = 31 * result + (this.lastSuccessfulMergeDate?.hashCode() ?: 0)
        result = 31 * result + (this.mergedApiArn?.hashCode() ?: 0)
        result = 31 * result + (this.mergedApiId?.hashCode() ?: 0)
        result = 31 * result + (this.sourceApiArn?.hashCode() ?: 0)
        result = 31 * result + (this.sourceApiAssociationConfig?.hashCode() ?: 0)
        result = 31 * result + (this.sourceApiAssociationStatus?.hashCode() ?: 0)
        result = 31 * result + (this.sourceApiAssociationStatusDetail?.hashCode() ?: 0)
        result = 31 * result + (this.sourceApiId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SourceApiAssociation

        if (associationArn != other.associationArn) return false
        if (associationId != other.associationId) return false
        if (description != other.description) return false
        if (lastSuccessfulMergeDate != other.lastSuccessfulMergeDate) return false
        if (mergedApiArn != other.mergedApiArn) return false
        if (mergedApiId != other.mergedApiId) return false
        if (sourceApiArn != other.sourceApiArn) return false
        if (sourceApiAssociationConfig != other.sourceApiAssociationConfig) return false
        if (sourceApiAssociationStatus != other.sourceApiAssociationStatus) return false
        if (sourceApiAssociationStatusDetail != other.sourceApiAssociationStatusDetail) return false
        if (sourceApiId != other.sourceApiId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.SourceApiAssociation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the source API association.
         */
        public var associationArn: kotlin.String? = null
        /**
         * The ID generated by the AppSync service for the source API association.
         */
        public var associationId: kotlin.String? = null
        /**
         * The description field.
         */
        public var description: kotlin.String? = null
        /**
         * The datetime value of the last successful merge of the source API association. The result will be in UTC format and your local time zone.
         */
        public var lastSuccessfulMergeDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the AppSync Merged API.
         */
        public var mergedApiArn: kotlin.String? = null
        /**
         * The ID of the AppSync Merged API.
         */
        public var mergedApiId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the AppSync source API.
         */
        public var sourceApiArn: kotlin.String? = null
        /**
         * The `SourceApiAssociationConfig` object data.
         */
        public var sourceApiAssociationConfig: aws.sdk.kotlin.services.appsync.model.SourceApiAssociationConfig? = null
        /**
         * The state of the source API association.
         */
        public var sourceApiAssociationStatus: aws.sdk.kotlin.services.appsync.model.SourceApiAssociationStatus? = null
        /**
         * The detailed message related to the current state of the source API association.
         */
        public var sourceApiAssociationStatusDetail: kotlin.String? = null
        /**
         * The ID of the AppSync source API.
         */
        public var sourceApiId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.SourceApiAssociation) : this() {
            this.associationArn = x.associationArn
            this.associationId = x.associationId
            this.description = x.description
            this.lastSuccessfulMergeDate = x.lastSuccessfulMergeDate
            this.mergedApiArn = x.mergedApiArn
            this.mergedApiId = x.mergedApiId
            this.sourceApiArn = x.sourceApiArn
            this.sourceApiAssociationConfig = x.sourceApiAssociationConfig
            this.sourceApiAssociationStatus = x.sourceApiAssociationStatus
            this.sourceApiAssociationStatusDetail = x.sourceApiAssociationStatusDetail
            this.sourceApiId = x.sourceApiId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.SourceApiAssociation = SourceApiAssociation(this)

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.SourceApiAssociationConfig] inside the given [block]
         */
        public fun sourceApiAssociationConfig(block: aws.sdk.kotlin.services.appsync.model.SourceApiAssociationConfig.Builder.() -> kotlin.Unit) {
            this.sourceApiAssociationConfig = aws.sdk.kotlin.services.appsync.model.SourceApiAssociationConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
