// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model

import aws.smithy.kotlin.runtime.SdkDsl

public class PutGraphqlApiEnvironmentVariablesRequest private constructor(builder: Builder) {
    /**
     * The ID of the API to which the environmental variable list will be written.
     */
    public val apiId: kotlin.String? = builder.apiId
    /**
     * The list of environmental variables to add to the API.
     *
     * When creating an environmental variable key-value pair, it must follow the additional constraints below:
     * + Keys must begin with a letter.
     * + Keys must be at least two characters long.
     * + Keys can only contain letters, numbers, and the underscore character (_).
     * + Values can be up to 512 characters long.
     * + You can configure up to 50 key-value pairs in a GraphQL API.
     *
     * You can create a list of environmental variables by adding it to the `environmentVariables` payload as a list in the format `{"key1":"value1","key2":"value2", …}`. Note that each call of the `PutGraphqlApiEnvironmentVariables` action will result in the overwriting of the existing environmental variable list of that API. This means the existing environmental variables will be lost. To avoid this, you must include all existing and new environmental variables in the list each time you call this action.
     */
    public val environmentVariables: Map<String, String>? = builder.environmentVariables

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.PutGraphqlApiEnvironmentVariablesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutGraphqlApiEnvironmentVariablesRequest(")
        append("apiId=$apiId,")
        append("environmentVariables=$environmentVariables")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiId?.hashCode() ?: 0
        result = 31 * result + (this.environmentVariables?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutGraphqlApiEnvironmentVariablesRequest

        if (apiId != other.apiId) return false
        if (environmentVariables != other.environmentVariables) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.PutGraphqlApiEnvironmentVariablesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the API to which the environmental variable list will be written.
         */
        public var apiId: kotlin.String? = null
        /**
         * The list of environmental variables to add to the API.
         *
         * When creating an environmental variable key-value pair, it must follow the additional constraints below:
         * + Keys must begin with a letter.
         * + Keys must be at least two characters long.
         * + Keys can only contain letters, numbers, and the underscore character (_).
         * + Values can be up to 512 characters long.
         * + You can configure up to 50 key-value pairs in a GraphQL API.
         *
         * You can create a list of environmental variables by adding it to the `environmentVariables` payload as a list in the format `{"key1":"value1","key2":"value2", …}`. Note that each call of the `PutGraphqlApiEnvironmentVariables` action will result in the overwriting of the existing environmental variable list of that API. This means the existing environmental variables will be lost. To avoid this, you must include all existing and new environmental variables in the list each time you call this action.
         */
        public var environmentVariables: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.PutGraphqlApiEnvironmentVariablesRequest) : this() {
            this.apiId = x.apiId
            this.environmentVariables = x.environmentVariables
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.PutGraphqlApiEnvironmentVariablesRequest = PutGraphqlApiEnvironmentVariablesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
