// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the authorization configuration for connections, message publishing, message subscriptions, and logging for an Event API.
 */
public class EventConfig private constructor(builder: Builder) {
    /**
     * A list of authorization providers.
     */
    public val authProviders: List<AuthProvider> = requireNotNull(builder.authProviders) { "A non-null value must be provided for authProviders" }
    /**
     * A list of valid authorization modes for the Event API connections.
     */
    public val connectionAuthModes: List<AuthMode> = requireNotNull(builder.connectionAuthModes) { "A non-null value must be provided for connectionAuthModes" }
    /**
     * A list of valid authorization modes for the Event API publishing.
     */
    public val defaultPublishAuthModes: List<AuthMode> = requireNotNull(builder.defaultPublishAuthModes) { "A non-null value must be provided for defaultPublishAuthModes" }
    /**
     * A list of valid authorization modes for the Event API subscriptions.
     */
    public val defaultSubscribeAuthModes: List<AuthMode> = requireNotNull(builder.defaultSubscribeAuthModes) { "A non-null value must be provided for defaultSubscribeAuthModes" }
    /**
     * The CloudWatch Logs configuration for the Event API.
     */
    public val logConfig: aws.sdk.kotlin.services.appsync.model.EventLogConfig? = builder.logConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.EventConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EventConfig(")
        append("authProviders=$authProviders,")
        append("connectionAuthModes=$connectionAuthModes,")
        append("defaultPublishAuthModes=$defaultPublishAuthModes,")
        append("defaultSubscribeAuthModes=$defaultSubscribeAuthModes,")
        append("logConfig=$logConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authProviders.hashCode()
        result = 31 * result + (this.connectionAuthModes.hashCode())
        result = 31 * result + (this.defaultPublishAuthModes.hashCode())
        result = 31 * result + (this.defaultSubscribeAuthModes.hashCode())
        result = 31 * result + (this.logConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EventConfig

        if (authProviders != other.authProviders) return false
        if (connectionAuthModes != other.connectionAuthModes) return false
        if (defaultPublishAuthModes != other.defaultPublishAuthModes) return false
        if (defaultSubscribeAuthModes != other.defaultSubscribeAuthModes) return false
        if (logConfig != other.logConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.EventConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of authorization providers.
         */
        public var authProviders: List<AuthProvider>? = null
        /**
         * A list of valid authorization modes for the Event API connections.
         */
        public var connectionAuthModes: List<AuthMode>? = null
        /**
         * A list of valid authorization modes for the Event API publishing.
         */
        public var defaultPublishAuthModes: List<AuthMode>? = null
        /**
         * A list of valid authorization modes for the Event API subscriptions.
         */
        public var defaultSubscribeAuthModes: List<AuthMode>? = null
        /**
         * The CloudWatch Logs configuration for the Event API.
         */
        public var logConfig: aws.sdk.kotlin.services.appsync.model.EventLogConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.EventConfig) : this() {
            this.authProviders = x.authProviders
            this.connectionAuthModes = x.connectionAuthModes
            this.defaultPublishAuthModes = x.defaultPublishAuthModes
            this.defaultSubscribeAuthModes = x.defaultSubscribeAuthModes
            this.logConfig = x.logConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.EventConfig = EventConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.EventLogConfig] inside the given [block]
         */
        public fun logConfig(block: aws.sdk.kotlin.services.appsync.model.EventLogConfig.Builder.() -> kotlin.Unit) {
            this.logConfig = aws.sdk.kotlin.services.appsync.model.EventLogConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (authProviders == null) authProviders = emptyList()
            if (connectionAuthModes == null) connectionAuthModes = emptyList()
            if (defaultPublishAuthModes == null) defaultPublishAuthModes = emptyList()
            if (defaultSubscribeAuthModes == null) defaultSubscribeAuthModes = emptyList()
            return this
        }
    }
}
