// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Enables and controls the enhanced metrics feature. Enhanced metrics emit granular data on API usage and performance such as AppSync request and error counts, latency, and cache hits/misses. All enhanced metric data is sent to your CloudWatch account, and you can configure the types of data that will be sent.
 *
 * Enhanced metrics can be configured at the resolver, data source, and operation levels. `EnhancedMetricsConfig` contains three required parameters, each controlling one of these categories:
 * + `resolverLevelMetricsBehavior`: Controls how resolver metrics will be emitted to CloudWatch. Resolver metrics include:
 *    + GraphQL errors: The number of GraphQL errors that occurred.
 *    + Requests: The number of invocations that occurred during a request.
 *    + Latency: The time to complete a resolver invocation.
 *    + Cache hits: The number of cache hits during a request.
 *    + Cache misses: The number of cache misses during a request.
 * These metrics can be emitted to CloudWatch per resolver or for all resolvers in the request. Metrics will be recorded by API ID and resolver name. `resolverLevelMetricsBehavior` accepts one of these values at a time:
 *    + `FULL_REQUEST_RESOLVER_METRICS`: Records and emits metric data for all resolvers in the request.
 *    + `PER_RESOLVER_METRICS`: Records and emits metric data for resolvers that have the `metricsConfig` value set to `ENABLED`.
 * + `dataSourceLevelMetricsBehavior`: Controls how data source metrics will be emitted to CloudWatch. Data source metrics include:
 *    + Requests: The number of invocations that occured during a request.
 *    + Latency: The time to complete a data source invocation.
 *    + Errors: The number of errors that occurred during a data source invocation.
 * These metrics can be emitted to CloudWatch per data source or for all data sources in the request. Metrics will be recorded by API ID and data source name. `dataSourceLevelMetricsBehavior` accepts one of these values at a time:
 *    + `FULL_REQUEST_DATA_SOURCE_METRICS`: Records and emits metric data for all data sources in the request.
 *    + `PER_DATA_SOURCE_METRICS`: Records and emits metric data for data sources that have the `metricsConfig` value set to `ENABLED`.
 * + `operationLevelMetricsConfig`: Controls how operation metrics will be emitted to CloudWatch. Operation metrics include:
 *    + Requests: The number of times a specified GraphQL operation was called.
 *    + GraphQL errors: The number of GraphQL errors that occurred during a specified GraphQL operation.
 * Metrics will be recorded by API ID and operation name. You can set the value to `ENABLED` or `DISABLED`.
 */
public class EnhancedMetricsConfig private constructor(builder: Builder) {
    /**
     * Controls how data source metrics will be emitted to CloudWatch. Data source metrics include:
     * + Requests: The number of invocations that occured during a request.
     * + Latency: The time to complete a data source invocation.
     * + Errors: The number of errors that occurred during a data source invocation.
     *
     * These metrics can be emitted to CloudWatch per data source or for all data sources in the request. Metrics will be recorded by API ID and data source name. `dataSourceLevelMetricsBehavior` accepts one of these values at a time:
     * + `FULL_REQUEST_DATA_SOURCE_METRICS`: Records and emits metric data for all data sources in the request.
     * + `PER_DATA_SOURCE_METRICS`: Records and emits metric data for data sources that have the `metricsConfig` value set to `ENABLED`.
     */
    public val dataSourceLevelMetricsBehavior: aws.sdk.kotlin.services.appsync.model.DataSourceLevelMetricsBehavior = requireNotNull(builder.dataSourceLevelMetricsBehavior) { "A non-null value must be provided for dataSourceLevelMetricsBehavior" }
    /**
     * Controls how operation metrics will be emitted to CloudWatch. Operation metrics include:
     * + Requests: The number of times a specified GraphQL operation was called.
     * + GraphQL errors: The number of GraphQL errors that occurred during a specified GraphQL operation.
     *
     * Metrics will be recorded by API ID and operation name. You can set the value to `ENABLED` or `DISABLED`.
     */
    public val operationLevelMetricsConfig: aws.sdk.kotlin.services.appsync.model.OperationLevelMetricsConfig = requireNotNull(builder.operationLevelMetricsConfig) { "A non-null value must be provided for operationLevelMetricsConfig" }
    /**
     * Controls how resolver metrics will be emitted to CloudWatch. Resolver metrics include:
     * + GraphQL errors: The number of GraphQL errors that occurred.
     * + Requests: The number of invocations that occurred during a request.
     * + Latency: The time to complete a resolver invocation.
     * + Cache hits: The number of cache hits during a request.
     * + Cache misses: The number of cache misses during a request.
     *
     * These metrics can be emitted to CloudWatch per resolver or for all resolvers in the request. Metrics will be recorded by API ID and resolver name. `resolverLevelMetricsBehavior` accepts one of these values at a time:
     * + `FULL_REQUEST_RESOLVER_METRICS`: Records and emits metric data for all resolvers in the request.
     * + `PER_RESOLVER_METRICS`: Records and emits metric data for resolvers that have the `metricsConfig` value set to `ENABLED`.
     */
    public val resolverLevelMetricsBehavior: aws.sdk.kotlin.services.appsync.model.ResolverLevelMetricsBehavior = requireNotNull(builder.resolverLevelMetricsBehavior) { "A non-null value must be provided for resolverLevelMetricsBehavior" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.EnhancedMetricsConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EnhancedMetricsConfig(")
        append("dataSourceLevelMetricsBehavior=$dataSourceLevelMetricsBehavior,")
        append("operationLevelMetricsConfig=$operationLevelMetricsConfig,")
        append("resolverLevelMetricsBehavior=$resolverLevelMetricsBehavior")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSourceLevelMetricsBehavior.hashCode()
        result = 31 * result + (this.operationLevelMetricsConfig.hashCode())
        result = 31 * result + (this.resolverLevelMetricsBehavior.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EnhancedMetricsConfig

        if (dataSourceLevelMetricsBehavior != other.dataSourceLevelMetricsBehavior) return false
        if (operationLevelMetricsConfig != other.operationLevelMetricsConfig) return false
        if (resolverLevelMetricsBehavior != other.resolverLevelMetricsBehavior) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.EnhancedMetricsConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Controls how data source metrics will be emitted to CloudWatch. Data source metrics include:
         * + Requests: The number of invocations that occured during a request.
         * + Latency: The time to complete a data source invocation.
         * + Errors: The number of errors that occurred during a data source invocation.
         *
         * These metrics can be emitted to CloudWatch per data source or for all data sources in the request. Metrics will be recorded by API ID and data source name. `dataSourceLevelMetricsBehavior` accepts one of these values at a time:
         * + `FULL_REQUEST_DATA_SOURCE_METRICS`: Records and emits metric data for all data sources in the request.
         * + `PER_DATA_SOURCE_METRICS`: Records and emits metric data for data sources that have the `metricsConfig` value set to `ENABLED`.
         */
        public var dataSourceLevelMetricsBehavior: aws.sdk.kotlin.services.appsync.model.DataSourceLevelMetricsBehavior? = null
        /**
         * Controls how operation metrics will be emitted to CloudWatch. Operation metrics include:
         * + Requests: The number of times a specified GraphQL operation was called.
         * + GraphQL errors: The number of GraphQL errors that occurred during a specified GraphQL operation.
         *
         * Metrics will be recorded by API ID and operation name. You can set the value to `ENABLED` or `DISABLED`.
         */
        public var operationLevelMetricsConfig: aws.sdk.kotlin.services.appsync.model.OperationLevelMetricsConfig? = null
        /**
         * Controls how resolver metrics will be emitted to CloudWatch. Resolver metrics include:
         * + GraphQL errors: The number of GraphQL errors that occurred.
         * + Requests: The number of invocations that occurred during a request.
         * + Latency: The time to complete a resolver invocation.
         * + Cache hits: The number of cache hits during a request.
         * + Cache misses: The number of cache misses during a request.
         *
         * These metrics can be emitted to CloudWatch per resolver or for all resolvers in the request. Metrics will be recorded by API ID and resolver name. `resolverLevelMetricsBehavior` accepts one of these values at a time:
         * + `FULL_REQUEST_RESOLVER_METRICS`: Records and emits metric data for all resolvers in the request.
         * + `PER_RESOLVER_METRICS`: Records and emits metric data for resolvers that have the `metricsConfig` value set to `ENABLED`.
         */
        public var resolverLevelMetricsBehavior: aws.sdk.kotlin.services.appsync.model.ResolverLevelMetricsBehavior? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.EnhancedMetricsConfig) : this() {
            this.dataSourceLevelMetricsBehavior = x.dataSourceLevelMetricsBehavior
            this.operationLevelMetricsConfig = x.operationLevelMetricsConfig
            this.resolverLevelMetricsBehavior = x.resolverLevelMetricsBehavior
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.EnhancedMetricsConfig = EnhancedMetricsConfig(this)

        internal fun correctErrors(): Builder {
            if (dataSourceLevelMetricsBehavior == null) dataSourceLevelMetricsBehavior = DataSourceLevelMetricsBehavior.SdkUnknown("no value provided")
            if (operationLevelMetricsConfig == null) operationLevelMetricsConfig = OperationLevelMetricsConfig.SdkUnknown("no value provided")
            if (resolverLevelMetricsBehavior == null) resolverLevelMetricsBehavior = ResolverLevelMetricsBehavior.SdkUnknown("no value provided")
            return this
        }
    }
}
