// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the type data for each field retrieved from the introspection.
 */
public class DataSourceIntrospectionModelFieldType private constructor(builder: Builder) {
    /**
     * Specifies the classification of data. For example, this could be set to values like `Scalar` or `NonNull` to indicate a fundamental property of the field.
     *
     * Valid values include:
     * + `Scalar`: Indicates the value is a primitive type (scalar).
     * + `NonNull`: Indicates the field cannot be `null`.
     * + `List`: Indicates the field contains a list.
     */
    public val kind: kotlin.String? = builder.kind
    /**
     * The name of the data type that represents the field. For example, `String` is a valid `name` value.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The `DataSourceIntrospectionModelFieldType` object data. The `type` is only present if `DataSourceIntrospectionModelFieldType.kind` is set to `NonNull` or `List`.
     *
     * The `type` typically contains its own `kind` and `name` fields to represent the actual type data. For instance, `type` could contain a `kind` value of `Scalar` with a `name` value of `String`. The values `Scalar` and `String` will be collectively stored in the `values` field.
     */
    public val type: aws.sdk.kotlin.services.appsync.model.DataSourceIntrospectionModelFieldType? = builder.type
    /**
     * The values of the `type` field. This field represents the AppSync data type equivalent of the introspected field.
     */
    public val values: List<String>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.DataSourceIntrospectionModelFieldType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataSourceIntrospectionModelFieldType(")
        append("kind=$kind,")
        append("name=$name,")
        append("type=$type,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kind?.hashCode() ?: 0
        result = 31 * result + (this.name?.hashCode() ?: 0)
        result = 31 * result + (this.type?.hashCode() ?: 0)
        result = 31 * result + (this.values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataSourceIntrospectionModelFieldType

        if (kind != other.kind) return false
        if (name != other.name) return false
        if (type != other.type) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.DataSourceIntrospectionModelFieldType = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the classification of data. For example, this could be set to values like `Scalar` or `NonNull` to indicate a fundamental property of the field.
         *
         * Valid values include:
         * + `Scalar`: Indicates the value is a primitive type (scalar).
         * + `NonNull`: Indicates the field cannot be `null`.
         * + `List`: Indicates the field contains a list.
         */
        public var kind: kotlin.String? = null
        /**
         * The name of the data type that represents the field. For example, `String` is a valid `name` value.
         */
        public var name: kotlin.String? = null
        /**
         * The `DataSourceIntrospectionModelFieldType` object data. The `type` is only present if `DataSourceIntrospectionModelFieldType.kind` is set to `NonNull` or `List`.
         *
         * The `type` typically contains its own `kind` and `name` fields to represent the actual type data. For instance, `type` could contain a `kind` value of `Scalar` with a `name` value of `String`. The values `Scalar` and `String` will be collectively stored in the `values` field.
         */
        public var type: aws.sdk.kotlin.services.appsync.model.DataSourceIntrospectionModelFieldType? = null
        /**
         * The values of the `type` field. This field represents the AppSync data type equivalent of the introspected field.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.DataSourceIntrospectionModelFieldType) : this() {
            this.kind = x.kind
            this.name = x.name
            this.type = x.type
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.DataSourceIntrospectionModelFieldType = DataSourceIntrospectionModelFieldType(this)

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.DataSourceIntrospectionModelFieldType] inside the given [block]
         */
        public fun type(block: aws.sdk.kotlin.services.appsync.model.DataSourceIntrospectionModelFieldType.Builder.() -> kotlin.Unit) {
            this.type = aws.sdk.kotlin.services.appsync.model.DataSourceIntrospectionModelFieldType.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
