// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateGraphqlApiRequest private constructor(builder: Builder) {
    /**
     * A list of additional authentication providers for the `GraphqlApi` API.
     */
    public val additionalAuthenticationProviders: List<AdditionalAuthenticationProvider>? = builder.additionalAuthenticationProviders
    /**
     * The value that indicates whether the GraphQL API is a standard API (`GRAPHQL`) or merged API (`MERGED`).
     */
    public val apiType: aws.sdk.kotlin.services.appsync.model.GraphQlApiType? = builder.apiType
    /**
     * The authentication type: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon Cognito user pools, or Lambda.
     */
    public val authenticationType: aws.sdk.kotlin.services.appsync.model.AuthenticationType? = builder.authenticationType
    /**
     * The `enhancedMetricsConfig` object.
     */
    public val enhancedMetricsConfig: aws.sdk.kotlin.services.appsync.model.EnhancedMetricsConfig? = builder.enhancedMetricsConfig
    /**
     * Sets the value of the GraphQL API to enable (`ENABLED`) or disable (`DISABLED`) introspection. If no value is provided, the introspection configuration will be set to `ENABLED` by default. This field will produce an error if the operation attempts to use the introspection feature while this field is disabled.
     *
     * For more information about introspection, see [GraphQL introspection](https://graphql.org/learn/introspection/).
     */
    public val introspectionConfig: aws.sdk.kotlin.services.appsync.model.GraphQlApiIntrospectionConfig? = builder.introspectionConfig
    /**
     * Configuration for Lambda function authorization.
     */
    public val lambdaAuthorizerConfig: aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig? = builder.lambdaAuthorizerConfig
    /**
     * The Amazon CloudWatch Logs configuration.
     */
    public val logConfig: aws.sdk.kotlin.services.appsync.model.LogConfig? = builder.logConfig
    /**
     * The Identity and Access Management service role ARN for a merged API. The AppSync service assumes this role on behalf of the Merged API to validate access to source APIs at runtime and to prompt the `AUTO_MERGE` to update the merged API endpoint with the source API changes automatically.
     */
    public val mergedApiExecutionRoleArn: kotlin.String? = builder.mergedApiExecutionRoleArn
    /**
     * A user-supplied name for the `GraphqlApi`.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The OIDC configuration.
     */
    public val openIdConnectConfig: aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig? = builder.openIdConnectConfig
    /**
     * The owner contact information for an API resource.
     *
     * This field accepts any string input with a length of 0 - 256 characters.
     */
    public val ownerContact: kotlin.String? = builder.ownerContact
    /**
     * The maximum depth a query can have in a single request. Depth refers to the amount of nested levels allowed in the body of query. The default value is `0` (or unspecified), which indicates there's no depth limit. If you set a limit, it can be between `1` and `75` nested levels. This field will produce a limit error if the operation falls out of bounds.
     *
     * Note that fields can still be set to nullable or non-nullable. If a non-nullable field produces an error, the error will be thrown upwards to the first nullable field available.
     */
    public val queryDepthLimit: kotlin.Int? = builder.queryDepthLimit
    /**
     * The maximum number of resolvers that can be invoked in a single request. The default value is `0` (or unspecified), which will set the limit to `10000`. When specified, the limit value can be between `1` and `10000`. This field will produce a limit error if the operation falls out of bounds.
     */
    public val resolverCountLimit: kotlin.Int? = builder.resolverCountLimit
    /**
     * A `TagMap` object.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The Amazon Cognito user pool configuration.
     */
    public val userPoolConfig: aws.sdk.kotlin.services.appsync.model.UserPoolConfig? = builder.userPoolConfig
    /**
     * Sets the value of the GraphQL API to public (`GLOBAL`) or private (`PRIVATE`). If no value is provided, the visibility will be set to `GLOBAL` by default. This value cannot be changed once the API has been created.
     */
    public val visibility: aws.sdk.kotlin.services.appsync.model.GraphQlApiVisibility? = builder.visibility
    /**
     * A flag indicating whether to use X-Ray tracing for the `GraphqlApi`.
     */
    public val xrayEnabled: kotlin.Boolean? = builder.xrayEnabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.CreateGraphqlApiRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateGraphqlApiRequest(")
        append("additionalAuthenticationProviders=$additionalAuthenticationProviders,")
        append("apiType=$apiType,")
        append("authenticationType=$authenticationType,")
        append("enhancedMetricsConfig=$enhancedMetricsConfig,")
        append("introspectionConfig=$introspectionConfig,")
        append("lambdaAuthorizerConfig=$lambdaAuthorizerConfig,")
        append("logConfig=$logConfig,")
        append("mergedApiExecutionRoleArn=$mergedApiExecutionRoleArn,")
        append("name=$name,")
        append("openIdConnectConfig=$openIdConnectConfig,")
        append("ownerContact=$ownerContact,")
        append("queryDepthLimit=$queryDepthLimit,")
        append("resolverCountLimit=$resolverCountLimit,")
        append("tags=$tags,")
        append("userPoolConfig=$userPoolConfig,")
        append("visibility=$visibility,")
        append("xrayEnabled=$xrayEnabled")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalAuthenticationProviders?.hashCode() ?: 0
        result = 31 * result + (this.apiType?.hashCode() ?: 0)
        result = 31 * result + (this.authenticationType?.hashCode() ?: 0)
        result = 31 * result + (this.enhancedMetricsConfig?.hashCode() ?: 0)
        result = 31 * result + (this.introspectionConfig?.hashCode() ?: 0)
        result = 31 * result + (this.lambdaAuthorizerConfig?.hashCode() ?: 0)
        result = 31 * result + (this.logConfig?.hashCode() ?: 0)
        result = 31 * result + (this.mergedApiExecutionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (this.name?.hashCode() ?: 0)
        result = 31 * result + (this.openIdConnectConfig?.hashCode() ?: 0)
        result = 31 * result + (this.ownerContact?.hashCode() ?: 0)
        result = 31 * result + (this.queryDepthLimit ?: 0)
        result = 31 * result + (this.resolverCountLimit ?: 0)
        result = 31 * result + (this.tags?.hashCode() ?: 0)
        result = 31 * result + (this.userPoolConfig?.hashCode() ?: 0)
        result = 31 * result + (this.visibility?.hashCode() ?: 0)
        result = 31 * result + (this.xrayEnabled?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateGraphqlApiRequest

        if (additionalAuthenticationProviders != other.additionalAuthenticationProviders) return false
        if (apiType != other.apiType) return false
        if (authenticationType != other.authenticationType) return false
        if (enhancedMetricsConfig != other.enhancedMetricsConfig) return false
        if (introspectionConfig != other.introspectionConfig) return false
        if (lambdaAuthorizerConfig != other.lambdaAuthorizerConfig) return false
        if (logConfig != other.logConfig) return false
        if (mergedApiExecutionRoleArn != other.mergedApiExecutionRoleArn) return false
        if (name != other.name) return false
        if (openIdConnectConfig != other.openIdConnectConfig) return false
        if (ownerContact != other.ownerContact) return false
        if (queryDepthLimit != other.queryDepthLimit) return false
        if (resolverCountLimit != other.resolverCountLimit) return false
        if (tags != other.tags) return false
        if (userPoolConfig != other.userPoolConfig) return false
        if (visibility != other.visibility) return false
        if (xrayEnabled != other.xrayEnabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.CreateGraphqlApiRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of additional authentication providers for the `GraphqlApi` API.
         */
        public var additionalAuthenticationProviders: List<AdditionalAuthenticationProvider>? = null
        /**
         * The value that indicates whether the GraphQL API is a standard API (`GRAPHQL`) or merged API (`MERGED`).
         */
        public var apiType: aws.sdk.kotlin.services.appsync.model.GraphQlApiType? = null
        /**
         * The authentication type: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon Cognito user pools, or Lambda.
         */
        public var authenticationType: aws.sdk.kotlin.services.appsync.model.AuthenticationType? = null
        /**
         * The `enhancedMetricsConfig` object.
         */
        public var enhancedMetricsConfig: aws.sdk.kotlin.services.appsync.model.EnhancedMetricsConfig? = null
        /**
         * Sets the value of the GraphQL API to enable (`ENABLED`) or disable (`DISABLED`) introspection. If no value is provided, the introspection configuration will be set to `ENABLED` by default. This field will produce an error if the operation attempts to use the introspection feature while this field is disabled.
         *
         * For more information about introspection, see [GraphQL introspection](https://graphql.org/learn/introspection/).
         */
        public var introspectionConfig: aws.sdk.kotlin.services.appsync.model.GraphQlApiIntrospectionConfig? = null
        /**
         * Configuration for Lambda function authorization.
         */
        public var lambdaAuthorizerConfig: aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig? = null
        /**
         * The Amazon CloudWatch Logs configuration.
         */
        public var logConfig: aws.sdk.kotlin.services.appsync.model.LogConfig? = null
        /**
         * The Identity and Access Management service role ARN for a merged API. The AppSync service assumes this role on behalf of the Merged API to validate access to source APIs at runtime and to prompt the `AUTO_MERGE` to update the merged API endpoint with the source API changes automatically.
         */
        public var mergedApiExecutionRoleArn: kotlin.String? = null
        /**
         * A user-supplied name for the `GraphqlApi`.
         */
        public var name: kotlin.String? = null
        /**
         * The OIDC configuration.
         */
        public var openIdConnectConfig: aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig? = null
        /**
         * The owner contact information for an API resource.
         *
         * This field accepts any string input with a length of 0 - 256 characters.
         */
        public var ownerContact: kotlin.String? = null
        /**
         * The maximum depth a query can have in a single request. Depth refers to the amount of nested levels allowed in the body of query. The default value is `0` (or unspecified), which indicates there's no depth limit. If you set a limit, it can be between `1` and `75` nested levels. This field will produce a limit error if the operation falls out of bounds.
         *
         * Note that fields can still be set to nullable or non-nullable. If a non-nullable field produces an error, the error will be thrown upwards to the first nullable field available.
         */
        public var queryDepthLimit: kotlin.Int? = null
        /**
         * The maximum number of resolvers that can be invoked in a single request. The default value is `0` (or unspecified), which will set the limit to `10000`. When specified, the limit value can be between `1` and `10000`. This field will produce a limit error if the operation falls out of bounds.
         */
        public var resolverCountLimit: kotlin.Int? = null
        /**
         * A `TagMap` object.
         */
        public var tags: Map<String, String>? = null
        /**
         * The Amazon Cognito user pool configuration.
         */
        public var userPoolConfig: aws.sdk.kotlin.services.appsync.model.UserPoolConfig? = null
        /**
         * Sets the value of the GraphQL API to public (`GLOBAL`) or private (`PRIVATE`). If no value is provided, the visibility will be set to `GLOBAL` by default. This value cannot be changed once the API has been created.
         */
        public var visibility: aws.sdk.kotlin.services.appsync.model.GraphQlApiVisibility? = null
        /**
         * A flag indicating whether to use X-Ray tracing for the `GraphqlApi`.
         */
        public var xrayEnabled: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.CreateGraphqlApiRequest) : this() {
            this.additionalAuthenticationProviders = x.additionalAuthenticationProviders
            this.apiType = x.apiType
            this.authenticationType = x.authenticationType
            this.enhancedMetricsConfig = x.enhancedMetricsConfig
            this.introspectionConfig = x.introspectionConfig
            this.lambdaAuthorizerConfig = x.lambdaAuthorizerConfig
            this.logConfig = x.logConfig
            this.mergedApiExecutionRoleArn = x.mergedApiExecutionRoleArn
            this.name = x.name
            this.openIdConnectConfig = x.openIdConnectConfig
            this.ownerContact = x.ownerContact
            this.queryDepthLimit = x.queryDepthLimit
            this.resolverCountLimit = x.resolverCountLimit
            this.tags = x.tags
            this.userPoolConfig = x.userPoolConfig
            this.visibility = x.visibility
            this.xrayEnabled = x.xrayEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.CreateGraphqlApiRequest = CreateGraphqlApiRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.EnhancedMetricsConfig] inside the given [block]
         */
        public fun enhancedMetricsConfig(block: aws.sdk.kotlin.services.appsync.model.EnhancedMetricsConfig.Builder.() -> kotlin.Unit) {
            this.enhancedMetricsConfig = aws.sdk.kotlin.services.appsync.model.EnhancedMetricsConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig] inside the given [block]
         */
        public fun lambdaAuthorizerConfig(block: aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig.Builder.() -> kotlin.Unit) {
            this.lambdaAuthorizerConfig = aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.LogConfig] inside the given [block]
         */
        public fun logConfig(block: aws.sdk.kotlin.services.appsync.model.LogConfig.Builder.() -> kotlin.Unit) {
            this.logConfig = aws.sdk.kotlin.services.appsync.model.LogConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig] inside the given [block]
         */
        public fun openIdConnectConfig(block: aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig.Builder.() -> kotlin.Unit) {
            this.openIdConnectConfig = aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.UserPoolConfig] inside the given [block]
         */
        public fun userPoolConfig(block: aws.sdk.kotlin.services.appsync.model.UserPoolConfig.Builder.() -> kotlin.Unit) {
            this.userPoolConfig = aws.sdk.kotlin.services.appsync.model.UserPoolConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
