// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateChannelNamespaceRequest private constructor(builder: Builder) {
    /**
     * The `Api` ID.
     */
    public val apiId: kotlin.String? = builder.apiId
    /**
     * The event handler functions that run custom business logic to process published events and subscribe requests.
     */
    public val codeHandlers: kotlin.String? = builder.codeHandlers
    /**
     * The configuration for the `OnPublish` and `OnSubscribe` handlers.
     */
    public val handlerConfigs: aws.sdk.kotlin.services.appsync.model.HandlerConfigs? = builder.handlerConfigs
    /**
     * The name of the `ChannelNamespace`. This name must be unique within the `Api`
     */
    public val name: kotlin.String? = builder.name
    /**
     * The authorization mode to use for publishing messages on the channel namespace. This configuration overrides the default `Api` authorization configuration.
     */
    public val publishAuthModes: List<AuthMode>? = builder.publishAuthModes
    /**
     * The authorization mode to use for subscribing to messages on the channel namespace. This configuration overrides the default `Api` authorization configuration.
     */
    public val subscribeAuthModes: List<AuthMode>? = builder.subscribeAuthModes
    /**
     * A map with keys of `TagKey` objects and values of `TagValue` objects.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.CreateChannelNamespaceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateChannelNamespaceRequest(")
        append("apiId=$apiId,")
        append("codeHandlers=$codeHandlers,")
        append("handlerConfigs=$handlerConfigs,")
        append("name=$name,")
        append("publishAuthModes=$publishAuthModes,")
        append("subscribeAuthModes=$subscribeAuthModes,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiId?.hashCode() ?: 0
        result = 31 * result + (this.codeHandlers?.hashCode() ?: 0)
        result = 31 * result + (this.handlerConfigs?.hashCode() ?: 0)
        result = 31 * result + (this.name?.hashCode() ?: 0)
        result = 31 * result + (this.publishAuthModes?.hashCode() ?: 0)
        result = 31 * result + (this.subscribeAuthModes?.hashCode() ?: 0)
        result = 31 * result + (this.tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateChannelNamespaceRequest

        if (apiId != other.apiId) return false
        if (codeHandlers != other.codeHandlers) return false
        if (handlerConfigs != other.handlerConfigs) return false
        if (name != other.name) return false
        if (publishAuthModes != other.publishAuthModes) return false
        if (subscribeAuthModes != other.subscribeAuthModes) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.CreateChannelNamespaceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The `Api` ID.
         */
        public var apiId: kotlin.String? = null
        /**
         * The event handler functions that run custom business logic to process published events and subscribe requests.
         */
        public var codeHandlers: kotlin.String? = null
        /**
         * The configuration for the `OnPublish` and `OnSubscribe` handlers.
         */
        public var handlerConfigs: aws.sdk.kotlin.services.appsync.model.HandlerConfigs? = null
        /**
         * The name of the `ChannelNamespace`. This name must be unique within the `Api`
         */
        public var name: kotlin.String? = null
        /**
         * The authorization mode to use for publishing messages on the channel namespace. This configuration overrides the default `Api` authorization configuration.
         */
        public var publishAuthModes: List<AuthMode>? = null
        /**
         * The authorization mode to use for subscribing to messages on the channel namespace. This configuration overrides the default `Api` authorization configuration.
         */
        public var subscribeAuthModes: List<AuthMode>? = null
        /**
         * A map with keys of `TagKey` objects and values of `TagValue` objects.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.CreateChannelNamespaceRequest) : this() {
            this.apiId = x.apiId
            this.codeHandlers = x.codeHandlers
            this.handlerConfigs = x.handlerConfigs
            this.name = x.name
            this.publishAuthModes = x.publishAuthModes
            this.subscribeAuthModes = x.subscribeAuthModes
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.CreateChannelNamespaceRequest = CreateChannelNamespaceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.HandlerConfigs] inside the given [block]
         */
        public fun handlerConfigs(block: aws.sdk.kotlin.services.appsync.model.HandlerConfigs.Builder.() -> kotlin.Unit) {
            this.handlerConfigs = aws.sdk.kotlin.services.appsync.model.HandlerConfigs.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
