// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the input of a `CreateApiCache` operation.
 */
public class CreateApiCacheRequest private constructor(builder: Builder) {
    /**
     * Caching behavior.
     * + **FULL_REQUEST_CACHING**: All requests from the same user are cached. Individual resolvers are automatically cached. All API calls will try to return responses from the cache.
     * + **PER_RESOLVER_CACHING**: Individual resolvers that you specify are cached.
     * + **OPERATION_LEVEL_CACHING**: Full requests are cached together and returned without executing resolvers.
     */
    public val apiCachingBehavior: aws.sdk.kotlin.services.appsync.model.ApiCachingBehavior? = builder.apiCachingBehavior
    /**
     * The GraphQL API ID.
     */
    public val apiId: kotlin.String? = builder.apiId
    /**
     * At-rest encryption flag for cache. You cannot update this setting after creation.
     */
    @Deprecated("atRestEncryptionEnabled attribute is deprecated. Encryption at rest is always enabled.")
    public val atRestEncryptionEnabled: kotlin.Boolean? = builder.atRestEncryptionEnabled
    /**
     * Controls how cache health metrics will be emitted to CloudWatch. Cache health metrics include:
     * + NetworkBandwidthOutAllowanceExceeded: The network packets dropped because the throughput exceeded the aggregated bandwidth limit. This is useful for diagnosing bottlenecks in a cache configuration.
     * + EngineCPUUtilization: The CPU utilization (percentage) allocated to the Redis process. This is useful for diagnosing bottlenecks in a cache configuration.
     *
     * Metrics will be recorded by API ID. You can set the value to `ENABLED` or `DISABLED`.
     */
    public val healthMetricsConfig: aws.sdk.kotlin.services.appsync.model.CacheHealthMetricsConfig? = builder.healthMetricsConfig
    /**
     * Transit encryption flag when connecting to cache. You cannot update this setting after creation.
     */
    @Deprecated("transitEncryptionEnabled attribute is deprecated. Encryption in transit is always enabled.")
    public val transitEncryptionEnabled: kotlin.Boolean? = builder.transitEncryptionEnabled
    /**
     * TTL in seconds for cache entries.
     *
     * Valid values are 1–3,600 seconds.
     */
    public val ttl: kotlin.Long? = builder.ttl
    /**
     * The cache instance type. Valid values are
     * + `SMALL`
     * + `MEDIUM`
     * + `LARGE`
     * + `XLARGE`
     * + `LARGE_2X`
     * + `LARGE_4X`
     * + `LARGE_8X` (not available in all regions)
     * + `LARGE_12X`
     *
     * Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.
     *
     * The following legacy instance types are available, but their use is discouraged:
     * + **T2_SMALL**: A t2.small instance type.
     * + **T2_MEDIUM**: A t2.medium instance type.
     * + **R4_LARGE**: A r4.large instance type.
     * + **R4_XLARGE**: A r4.xlarge instance type.
     * + **R4_2XLARGE**: A r4.2xlarge instance type.
     * + **R4_4XLARGE**: A r4.4xlarge instance type.
     * + **R4_8XLARGE**: A r4.8xlarge instance type.
     */
    public val type: aws.sdk.kotlin.services.appsync.model.ApiCacheType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.CreateApiCacheRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateApiCacheRequest(")
        append("apiCachingBehavior=$apiCachingBehavior,")
        append("apiId=$apiId,")
        append("atRestEncryptionEnabled=$atRestEncryptionEnabled,")
        append("healthMetricsConfig=$healthMetricsConfig,")
        append("transitEncryptionEnabled=$transitEncryptionEnabled,")
        append("ttl=$ttl,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiCachingBehavior?.hashCode() ?: 0
        result = 31 * result + (this.apiId?.hashCode() ?: 0)
        result = 31 * result + (this.atRestEncryptionEnabled?.hashCode() ?: 0)
        result = 31 * result + (this.healthMetricsConfig?.hashCode() ?: 0)
        result = 31 * result + (this.transitEncryptionEnabled?.hashCode() ?: 0)
        result = 31 * result + (this.ttl?.hashCode() ?: 0)
        result = 31 * result + (this.type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateApiCacheRequest

        if (apiCachingBehavior != other.apiCachingBehavior) return false
        if (apiId != other.apiId) return false
        if (atRestEncryptionEnabled != other.atRestEncryptionEnabled) return false
        if (healthMetricsConfig != other.healthMetricsConfig) return false
        if (transitEncryptionEnabled != other.transitEncryptionEnabled) return false
        if (ttl != other.ttl) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.CreateApiCacheRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Caching behavior.
         * + **FULL_REQUEST_CACHING**: All requests from the same user are cached. Individual resolvers are automatically cached. All API calls will try to return responses from the cache.
         * + **PER_RESOLVER_CACHING**: Individual resolvers that you specify are cached.
         * + **OPERATION_LEVEL_CACHING**: Full requests are cached together and returned without executing resolvers.
         */
        public var apiCachingBehavior: aws.sdk.kotlin.services.appsync.model.ApiCachingBehavior? = null
        /**
         * The GraphQL API ID.
         */
        public var apiId: kotlin.String? = null
        /**
         * At-rest encryption flag for cache. You cannot update this setting after creation.
         */
        @Deprecated("atRestEncryptionEnabled attribute is deprecated. Encryption at rest is always enabled.")
        public var atRestEncryptionEnabled: kotlin.Boolean? = null
        /**
         * Controls how cache health metrics will be emitted to CloudWatch. Cache health metrics include:
         * + NetworkBandwidthOutAllowanceExceeded: The network packets dropped because the throughput exceeded the aggregated bandwidth limit. This is useful for diagnosing bottlenecks in a cache configuration.
         * + EngineCPUUtilization: The CPU utilization (percentage) allocated to the Redis process. This is useful for diagnosing bottlenecks in a cache configuration.
         *
         * Metrics will be recorded by API ID. You can set the value to `ENABLED` or `DISABLED`.
         */
        public var healthMetricsConfig: aws.sdk.kotlin.services.appsync.model.CacheHealthMetricsConfig? = null
        /**
         * Transit encryption flag when connecting to cache. You cannot update this setting after creation.
         */
        @Deprecated("transitEncryptionEnabled attribute is deprecated. Encryption in transit is always enabled.")
        public var transitEncryptionEnabled: kotlin.Boolean? = null
        /**
         * TTL in seconds for cache entries.
         *
         * Valid values are 1–3,600 seconds.
         */
        public var ttl: kotlin.Long? = null
        /**
         * The cache instance type. Valid values are
         * + `SMALL`
         * + `MEDIUM`
         * + `LARGE`
         * + `XLARGE`
         * + `LARGE_2X`
         * + `LARGE_4X`
         * + `LARGE_8X` (not available in all regions)
         * + `LARGE_12X`
         *
         * Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.
         *
         * The following legacy instance types are available, but their use is discouraged:
         * + **T2_SMALL**: A t2.small instance type.
         * + **T2_MEDIUM**: A t2.medium instance type.
         * + **R4_LARGE**: A r4.large instance type.
         * + **R4_XLARGE**: A r4.xlarge instance type.
         * + **R4_2XLARGE**: A r4.2xlarge instance type.
         * + **R4_4XLARGE**: A r4.4xlarge instance type.
         * + **R4_8XLARGE**: A r4.8xlarge instance type.
         */
        public var type: aws.sdk.kotlin.services.appsync.model.ApiCacheType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.CreateApiCacheRequest) : this() {
            this.apiCachingBehavior = x.apiCachingBehavior
            this.apiId = x.apiId
            this.atRestEncryptionEnabled = x.atRestEncryptionEnabled
            this.healthMetricsConfig = x.healthMetricsConfig
            this.transitEncryptionEnabled = x.transitEncryptionEnabled
            this.ttl = x.ttl
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.CreateApiCacheRequest = CreateApiCacheRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
