// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes an authorization provider.
 */
public class AuthProvider private constructor(builder: Builder) {
    /**
     * The authorization type.
     */
    public val authType: aws.sdk.kotlin.services.appsync.model.AuthenticationType = requireNotNull(builder.authType) { "A non-null value must be provided for authType" }
    /**
     * Describes an Amazon Cognito user pool configuration.
     */
    public val cognitoConfig: aws.sdk.kotlin.services.appsync.model.CognitoConfig? = builder.cognitoConfig
    /**
     * A `LambdaAuthorizerConfig` specifies how to authorize AppSync API access when using the `AWS_LAMBDA` authorizer mode. Be aware that an AppSync API can have only one Lambda authorizer configured at a time.
     */
    public val lambdaAuthorizerConfig: aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig? = builder.lambdaAuthorizerConfig
    /**
     * Describes an OpenID Connect (OIDC) configuration.
     */
    public val openIdConnectConfig: aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig? = builder.openIdConnectConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.AuthProvider = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AuthProvider(")
        append("authType=$authType,")
        append("cognitoConfig=$cognitoConfig,")
        append("lambdaAuthorizerConfig=$lambdaAuthorizerConfig,")
        append("openIdConnectConfig=$openIdConnectConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authType.hashCode()
        result = 31 * result + (this.cognitoConfig?.hashCode() ?: 0)
        result = 31 * result + (this.lambdaAuthorizerConfig?.hashCode() ?: 0)
        result = 31 * result + (this.openIdConnectConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AuthProvider

        if (authType != other.authType) return false
        if (cognitoConfig != other.cognitoConfig) return false
        if (lambdaAuthorizerConfig != other.lambdaAuthorizerConfig) return false
        if (openIdConnectConfig != other.openIdConnectConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.AuthProvider = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The authorization type.
         */
        public var authType: aws.sdk.kotlin.services.appsync.model.AuthenticationType? = null
        /**
         * Describes an Amazon Cognito user pool configuration.
         */
        public var cognitoConfig: aws.sdk.kotlin.services.appsync.model.CognitoConfig? = null
        /**
         * A `LambdaAuthorizerConfig` specifies how to authorize AppSync API access when using the `AWS_LAMBDA` authorizer mode. Be aware that an AppSync API can have only one Lambda authorizer configured at a time.
         */
        public var lambdaAuthorizerConfig: aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig? = null
        /**
         * Describes an OpenID Connect (OIDC) configuration.
         */
        public var openIdConnectConfig: aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.AuthProvider) : this() {
            this.authType = x.authType
            this.cognitoConfig = x.cognitoConfig
            this.lambdaAuthorizerConfig = x.lambdaAuthorizerConfig
            this.openIdConnectConfig = x.openIdConnectConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.AuthProvider = AuthProvider(this)

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.CognitoConfig] inside the given [block]
         */
        public fun cognitoConfig(block: aws.sdk.kotlin.services.appsync.model.CognitoConfig.Builder.() -> kotlin.Unit) {
            this.cognitoConfig = aws.sdk.kotlin.services.appsync.model.CognitoConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig] inside the given [block]
         */
        public fun lambdaAuthorizerConfig(block: aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig.Builder.() -> kotlin.Unit) {
            this.lambdaAuthorizerConfig = aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig] inside the given [block]
         */
        public fun openIdConnectConfig(block: aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig.Builder.() -> kotlin.Unit) {
            this.openIdConnectConfig = aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (authType == null) authType = AuthenticationType.SdkUnknown("no value provided")
            return this
        }
    }
}
