// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an AppSync API. You can use `Api` for an AppSync API with your preferred configuration, such as an Event API that provides real-time message publishing and message subscriptions over WebSockets.
 */
public class Api private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the `Api`.
     */
    public val apiArn: kotlin.String? = builder.apiArn
    /**
     * The `Api` ID.
     */
    public val apiId: kotlin.String? = builder.apiId
    /**
     * The date and time that the `Api` was created.
     */
    public val created: aws.smithy.kotlin.runtime.time.Instant? = builder.created
    /**
     * The DNS records for the API. This will include an HTTP and a real-time endpoint.
     */
    public val dns: Map<String, String>? = builder.dns
    /**
     * The Event API configuration. This includes the default authorization configuration for connecting, publishing, and subscribing to an Event API.
     */
    public val eventConfig: aws.sdk.kotlin.services.appsync.model.EventConfig? = builder.eventConfig
    /**
     * The name of the `Api`.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The owner contact information for the `Api`
     */
    public val ownerContact: kotlin.String? = builder.ownerContact
    /**
     * A map with keys of `TagKey` objects and values of `TagValue` objects.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The Amazon Resource Name (ARN) of the WAF web access control list (web ACL) associated with this `Api`, if one exists.
     */
    public val wafWebAclArn: kotlin.String? = builder.wafWebAclArn
    /**
     * A flag indicating whether to use X-Ray tracing for this `Api`.
     */
    public val xrayEnabled: kotlin.Boolean = builder.xrayEnabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.Api = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Api(")
        append("apiArn=$apiArn,")
        append("apiId=$apiId,")
        append("created=$created,")
        append("dns=$dns,")
        append("eventConfig=$eventConfig,")
        append("name=$name,")
        append("ownerContact=$ownerContact,")
        append("tags=$tags,")
        append("wafWebAclArn=$wafWebAclArn,")
        append("xrayEnabled=$xrayEnabled")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiArn?.hashCode() ?: 0
        result = 31 * result + (this.apiId?.hashCode() ?: 0)
        result = 31 * result + (this.created?.hashCode() ?: 0)
        result = 31 * result + (this.dns?.hashCode() ?: 0)
        result = 31 * result + (this.eventConfig?.hashCode() ?: 0)
        result = 31 * result + (this.name?.hashCode() ?: 0)
        result = 31 * result + (this.ownerContact?.hashCode() ?: 0)
        result = 31 * result + (this.tags?.hashCode() ?: 0)
        result = 31 * result + (this.wafWebAclArn?.hashCode() ?: 0)
        result = 31 * result + (this.xrayEnabled.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Api

        if (apiArn != other.apiArn) return false
        if (apiId != other.apiId) return false
        if (created != other.created) return false
        if (dns != other.dns) return false
        if (eventConfig != other.eventConfig) return false
        if (name != other.name) return false
        if (ownerContact != other.ownerContact) return false
        if (tags != other.tags) return false
        if (wafWebAclArn != other.wafWebAclArn) return false
        if (xrayEnabled != other.xrayEnabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.Api = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the `Api`.
         */
        public var apiArn: kotlin.String? = null
        /**
         * The `Api` ID.
         */
        public var apiId: kotlin.String? = null
        /**
         * The date and time that the `Api` was created.
         */
        public var created: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The DNS records for the API. This will include an HTTP and a real-time endpoint.
         */
        public var dns: Map<String, String>? = null
        /**
         * The Event API configuration. This includes the default authorization configuration for connecting, publishing, and subscribing to an Event API.
         */
        public var eventConfig: aws.sdk.kotlin.services.appsync.model.EventConfig? = null
        /**
         * The name of the `Api`.
         */
        public var name: kotlin.String? = null
        /**
         * The owner contact information for the `Api`
         */
        public var ownerContact: kotlin.String? = null
        /**
         * A map with keys of `TagKey` objects and values of `TagValue` objects.
         */
        public var tags: Map<String, String>? = null
        /**
         * The Amazon Resource Name (ARN) of the WAF web access control list (web ACL) associated with this `Api`, if one exists.
         */
        public var wafWebAclArn: kotlin.String? = null
        /**
         * A flag indicating whether to use X-Ray tracing for this `Api`.
         */
        public var xrayEnabled: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.Api) : this() {
            this.apiArn = x.apiArn
            this.apiId = x.apiId
            this.created = x.created
            this.dns = x.dns
            this.eventConfig = x.eventConfig
            this.name = x.name
            this.ownerContact = x.ownerContact
            this.tags = x.tags
            this.wafWebAclArn = x.wafWebAclArn
            this.xrayEnabled = x.xrayEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.Api = Api(this)

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.EventConfig] inside the given [block]
         */
        public fun eventConfig(block: aws.sdk.kotlin.services.appsync.model.EventConfig.Builder.() -> kotlin.Unit) {
            this.eventConfig = aws.sdk.kotlin.services.appsync.model.EventConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
