// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.appsync.auth.AppSyncAuthSchemeProvider
import aws.sdk.kotlin.services.appsync.auth.DefaultAppSyncAuthSchemeProvider
import aws.sdk.kotlin.services.appsync.endpoints.AppSyncEndpointParameters
import aws.sdk.kotlin.services.appsync.endpoints.AppSyncEndpointProvider
import aws.sdk.kotlin.services.appsync.endpoints.DefaultAppSyncEndpointProvider
import aws.sdk.kotlin.services.appsync.model.AssociateApiRequest
import aws.sdk.kotlin.services.appsync.model.AssociateApiResponse
import aws.sdk.kotlin.services.appsync.model.AssociateMergedGraphqlApiRequest
import aws.sdk.kotlin.services.appsync.model.AssociateMergedGraphqlApiResponse
import aws.sdk.kotlin.services.appsync.model.AssociateSourceGraphqlApiRequest
import aws.sdk.kotlin.services.appsync.model.AssociateSourceGraphqlApiResponse
import aws.sdk.kotlin.services.appsync.model.CreateApiCacheRequest
import aws.sdk.kotlin.services.appsync.model.CreateApiCacheResponse
import aws.sdk.kotlin.services.appsync.model.CreateApiKeyRequest
import aws.sdk.kotlin.services.appsync.model.CreateApiKeyResponse
import aws.sdk.kotlin.services.appsync.model.CreateApiRequest
import aws.sdk.kotlin.services.appsync.model.CreateApiResponse
import aws.sdk.kotlin.services.appsync.model.CreateChannelNamespaceRequest
import aws.sdk.kotlin.services.appsync.model.CreateChannelNamespaceResponse
import aws.sdk.kotlin.services.appsync.model.CreateDataSourceRequest
import aws.sdk.kotlin.services.appsync.model.CreateDataSourceResponse
import aws.sdk.kotlin.services.appsync.model.CreateDomainNameRequest
import aws.sdk.kotlin.services.appsync.model.CreateDomainNameResponse
import aws.sdk.kotlin.services.appsync.model.CreateFunctionRequest
import aws.sdk.kotlin.services.appsync.model.CreateFunctionResponse
import aws.sdk.kotlin.services.appsync.model.CreateGraphqlApiRequest
import aws.sdk.kotlin.services.appsync.model.CreateGraphqlApiResponse
import aws.sdk.kotlin.services.appsync.model.CreateResolverRequest
import aws.sdk.kotlin.services.appsync.model.CreateResolverResponse
import aws.sdk.kotlin.services.appsync.model.CreateTypeRequest
import aws.sdk.kotlin.services.appsync.model.CreateTypeResponse
import aws.sdk.kotlin.services.appsync.model.DeleteApiCacheRequest
import aws.sdk.kotlin.services.appsync.model.DeleteApiCacheResponse
import aws.sdk.kotlin.services.appsync.model.DeleteApiKeyRequest
import aws.sdk.kotlin.services.appsync.model.DeleteApiKeyResponse
import aws.sdk.kotlin.services.appsync.model.DeleteApiRequest
import aws.sdk.kotlin.services.appsync.model.DeleteApiResponse
import aws.sdk.kotlin.services.appsync.model.DeleteChannelNamespaceRequest
import aws.sdk.kotlin.services.appsync.model.DeleteChannelNamespaceResponse
import aws.sdk.kotlin.services.appsync.model.DeleteDataSourceRequest
import aws.sdk.kotlin.services.appsync.model.DeleteDataSourceResponse
import aws.sdk.kotlin.services.appsync.model.DeleteDomainNameRequest
import aws.sdk.kotlin.services.appsync.model.DeleteDomainNameResponse
import aws.sdk.kotlin.services.appsync.model.DeleteFunctionRequest
import aws.sdk.kotlin.services.appsync.model.DeleteFunctionResponse
import aws.sdk.kotlin.services.appsync.model.DeleteGraphqlApiRequest
import aws.sdk.kotlin.services.appsync.model.DeleteGraphqlApiResponse
import aws.sdk.kotlin.services.appsync.model.DeleteResolverRequest
import aws.sdk.kotlin.services.appsync.model.DeleteResolverResponse
import aws.sdk.kotlin.services.appsync.model.DeleteTypeRequest
import aws.sdk.kotlin.services.appsync.model.DeleteTypeResponse
import aws.sdk.kotlin.services.appsync.model.DisassociateApiRequest
import aws.sdk.kotlin.services.appsync.model.DisassociateApiResponse
import aws.sdk.kotlin.services.appsync.model.DisassociateMergedGraphqlApiRequest
import aws.sdk.kotlin.services.appsync.model.DisassociateMergedGraphqlApiResponse
import aws.sdk.kotlin.services.appsync.model.DisassociateSourceGraphqlApiRequest
import aws.sdk.kotlin.services.appsync.model.DisassociateSourceGraphqlApiResponse
import aws.sdk.kotlin.services.appsync.model.EvaluateCodeRequest
import aws.sdk.kotlin.services.appsync.model.EvaluateCodeResponse
import aws.sdk.kotlin.services.appsync.model.EvaluateMappingTemplateRequest
import aws.sdk.kotlin.services.appsync.model.EvaluateMappingTemplateResponse
import aws.sdk.kotlin.services.appsync.model.FlushApiCacheRequest
import aws.sdk.kotlin.services.appsync.model.FlushApiCacheResponse
import aws.sdk.kotlin.services.appsync.model.GetApiAssociationRequest
import aws.sdk.kotlin.services.appsync.model.GetApiAssociationResponse
import aws.sdk.kotlin.services.appsync.model.GetApiCacheRequest
import aws.sdk.kotlin.services.appsync.model.GetApiCacheResponse
import aws.sdk.kotlin.services.appsync.model.GetApiRequest
import aws.sdk.kotlin.services.appsync.model.GetApiResponse
import aws.sdk.kotlin.services.appsync.model.GetChannelNamespaceRequest
import aws.sdk.kotlin.services.appsync.model.GetChannelNamespaceResponse
import aws.sdk.kotlin.services.appsync.model.GetDataSourceIntrospectionRequest
import aws.sdk.kotlin.services.appsync.model.GetDataSourceIntrospectionResponse
import aws.sdk.kotlin.services.appsync.model.GetDataSourceRequest
import aws.sdk.kotlin.services.appsync.model.GetDataSourceResponse
import aws.sdk.kotlin.services.appsync.model.GetDomainNameRequest
import aws.sdk.kotlin.services.appsync.model.GetDomainNameResponse
import aws.sdk.kotlin.services.appsync.model.GetFunctionRequest
import aws.sdk.kotlin.services.appsync.model.GetFunctionResponse
import aws.sdk.kotlin.services.appsync.model.GetGraphqlApiEnvironmentVariablesRequest
import aws.sdk.kotlin.services.appsync.model.GetGraphqlApiEnvironmentVariablesResponse
import aws.sdk.kotlin.services.appsync.model.GetGraphqlApiRequest
import aws.sdk.kotlin.services.appsync.model.GetGraphqlApiResponse
import aws.sdk.kotlin.services.appsync.model.GetIntrospectionSchemaRequest
import aws.sdk.kotlin.services.appsync.model.GetIntrospectionSchemaResponse
import aws.sdk.kotlin.services.appsync.model.GetResolverRequest
import aws.sdk.kotlin.services.appsync.model.GetResolverResponse
import aws.sdk.kotlin.services.appsync.model.GetSchemaCreationStatusRequest
import aws.sdk.kotlin.services.appsync.model.GetSchemaCreationStatusResponse
import aws.sdk.kotlin.services.appsync.model.GetSourceApiAssociationRequest
import aws.sdk.kotlin.services.appsync.model.GetSourceApiAssociationResponse
import aws.sdk.kotlin.services.appsync.model.GetTypeRequest
import aws.sdk.kotlin.services.appsync.model.GetTypeResponse
import aws.sdk.kotlin.services.appsync.model.ListApiKeysRequest
import aws.sdk.kotlin.services.appsync.model.ListApiKeysResponse
import aws.sdk.kotlin.services.appsync.model.ListApisRequest
import aws.sdk.kotlin.services.appsync.model.ListApisResponse
import aws.sdk.kotlin.services.appsync.model.ListChannelNamespacesRequest
import aws.sdk.kotlin.services.appsync.model.ListChannelNamespacesResponse
import aws.sdk.kotlin.services.appsync.model.ListDataSourcesRequest
import aws.sdk.kotlin.services.appsync.model.ListDataSourcesResponse
import aws.sdk.kotlin.services.appsync.model.ListDomainNamesRequest
import aws.sdk.kotlin.services.appsync.model.ListDomainNamesResponse
import aws.sdk.kotlin.services.appsync.model.ListFunctionsRequest
import aws.sdk.kotlin.services.appsync.model.ListFunctionsResponse
import aws.sdk.kotlin.services.appsync.model.ListGraphqlApisRequest
import aws.sdk.kotlin.services.appsync.model.ListGraphqlApisResponse
import aws.sdk.kotlin.services.appsync.model.ListResolversByFunctionRequest
import aws.sdk.kotlin.services.appsync.model.ListResolversByFunctionResponse
import aws.sdk.kotlin.services.appsync.model.ListResolversRequest
import aws.sdk.kotlin.services.appsync.model.ListResolversResponse
import aws.sdk.kotlin.services.appsync.model.ListSourceApiAssociationsRequest
import aws.sdk.kotlin.services.appsync.model.ListSourceApiAssociationsResponse
import aws.sdk.kotlin.services.appsync.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.appsync.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.appsync.model.ListTypesByAssociationRequest
import aws.sdk.kotlin.services.appsync.model.ListTypesByAssociationResponse
import aws.sdk.kotlin.services.appsync.model.ListTypesRequest
import aws.sdk.kotlin.services.appsync.model.ListTypesResponse
import aws.sdk.kotlin.services.appsync.model.PutGraphqlApiEnvironmentVariablesRequest
import aws.sdk.kotlin.services.appsync.model.PutGraphqlApiEnvironmentVariablesResponse
import aws.sdk.kotlin.services.appsync.model.StartDataSourceIntrospectionRequest
import aws.sdk.kotlin.services.appsync.model.StartDataSourceIntrospectionResponse
import aws.sdk.kotlin.services.appsync.model.StartSchemaCreationRequest
import aws.sdk.kotlin.services.appsync.model.StartSchemaCreationResponse
import aws.sdk.kotlin.services.appsync.model.StartSchemaMergeRequest
import aws.sdk.kotlin.services.appsync.model.StartSchemaMergeResponse
import aws.sdk.kotlin.services.appsync.model.TagResourceRequest
import aws.sdk.kotlin.services.appsync.model.TagResourceResponse
import aws.sdk.kotlin.services.appsync.model.UntagResourceRequest
import aws.sdk.kotlin.services.appsync.model.UntagResourceResponse
import aws.sdk.kotlin.services.appsync.model.UpdateApiCacheRequest
import aws.sdk.kotlin.services.appsync.model.UpdateApiCacheResponse
import aws.sdk.kotlin.services.appsync.model.UpdateApiKeyRequest
import aws.sdk.kotlin.services.appsync.model.UpdateApiKeyResponse
import aws.sdk.kotlin.services.appsync.model.UpdateApiRequest
import aws.sdk.kotlin.services.appsync.model.UpdateApiResponse
import aws.sdk.kotlin.services.appsync.model.UpdateChannelNamespaceRequest
import aws.sdk.kotlin.services.appsync.model.UpdateChannelNamespaceResponse
import aws.sdk.kotlin.services.appsync.model.UpdateDataSourceRequest
import aws.sdk.kotlin.services.appsync.model.UpdateDataSourceResponse
import aws.sdk.kotlin.services.appsync.model.UpdateDomainNameRequest
import aws.sdk.kotlin.services.appsync.model.UpdateDomainNameResponse
import aws.sdk.kotlin.services.appsync.model.UpdateFunctionRequest
import aws.sdk.kotlin.services.appsync.model.UpdateFunctionResponse
import aws.sdk.kotlin.services.appsync.model.UpdateGraphqlApiRequest
import aws.sdk.kotlin.services.appsync.model.UpdateGraphqlApiResponse
import aws.sdk.kotlin.services.appsync.model.UpdateResolverRequest
import aws.sdk.kotlin.services.appsync.model.UpdateResolverResponse
import aws.sdk.kotlin.services.appsync.model.UpdateSourceApiAssociationRequest
import aws.sdk.kotlin.services.appsync.model.UpdateSourceApiAssociationResponse
import aws.sdk.kotlin.services.appsync.model.UpdateTypeRequest
import aws.sdk.kotlin.services.appsync.model.UpdateTypeResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "AppSync"
public const val SdkVersion: String = "1.5.58"
public const val ServiceApiVersion: String = "2017-07-25"

/**
 * AppSync provides API actions for creating and interacting with data sources using GraphQL from your application.
 */
public interface AppSyncClient : SdkClient {
    /**
     * AppSyncClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, AppSyncClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "AppSync",
                "APPSYNC",
                "appsync",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, AppSyncClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): AppSyncClient = DefaultAppSyncClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: AppSyncEndpointProvider = builder.endpointProvider ?: DefaultAppSyncEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: AppSyncAuthSchemeProvider = builder.authSchemeProvider ?: DefaultAppSyncAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "AppSync"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: AppSyncEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: AppSyncAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Maps an endpoint to your custom domain.
     */
    public suspend fun associateApi(input: AssociateApiRequest): AssociateApiResponse

    /**
     * Creates an association between a Merged API and source API using the source API's identifier.
     */
    public suspend fun associateMergedGraphqlApi(input: AssociateMergedGraphqlApiRequest): AssociateMergedGraphqlApiResponse

    /**
     * Creates an association between a Merged API and source API using the Merged API's identifier.
     */
    public suspend fun associateSourceGraphqlApi(input: AssociateSourceGraphqlApiRequest): AssociateSourceGraphqlApiResponse

    /**
     * Creates an `Api` object. Use this operation to create an AppSync API with your preferred configuration, such as an Event API that provides real-time message publishing and message subscriptions over WebSockets.
     */
    public suspend fun createApi(input: CreateApiRequest): CreateApiResponse

    /**
     * Creates a cache for the GraphQL API.
     */
    public suspend fun createApiCache(input: CreateApiCacheRequest): CreateApiCacheResponse

    /**
     * Creates a unique key that you can distribute to clients who invoke your API.
     */
    public suspend fun createApiKey(input: CreateApiKeyRequest): CreateApiKeyResponse

    /**
     * Creates a `ChannelNamespace` for an `Api`.
     */
    public suspend fun createChannelNamespace(input: CreateChannelNamespaceRequest): CreateChannelNamespaceResponse

    /**
     * Creates a `DataSource` object.
     */
    public suspend fun createDataSource(input: CreateDataSourceRequest): CreateDataSourceResponse

    /**
     * Creates a custom `DomainName` object.
     */
    public suspend fun createDomainName(input: CreateDomainNameRequest): CreateDomainNameResponse

    /**
     * Creates a `Function` object.
     *
     * A function is a reusable entity. You can use multiple functions to compose the resolver logic.
     */
    public suspend fun createFunction(input: CreateFunctionRequest): CreateFunctionResponse

    /**
     * Creates a `GraphqlApi` object.
     */
    public suspend fun createGraphqlApi(input: CreateGraphqlApiRequest): CreateGraphqlApiResponse

    /**
     * Creates a `Resolver` object.
     *
     * A resolver converts incoming requests into a format that a data source can understand, and converts the data source's responses into GraphQL.
     */
    public suspend fun createResolver(input: CreateResolverRequest): CreateResolverResponse

    /**
     * Creates a `Type` object.
     */
    public suspend fun createType(input: CreateTypeRequest): CreateTypeResponse

    /**
     * Deletes an `Api` object
     */
    public suspend fun deleteApi(input: DeleteApiRequest): DeleteApiResponse

    /**
     * Deletes an `ApiCache` object.
     */
    public suspend fun deleteApiCache(input: DeleteApiCacheRequest): DeleteApiCacheResponse

    /**
     * Deletes an API key.
     */
    public suspend fun deleteApiKey(input: DeleteApiKeyRequest): DeleteApiKeyResponse

    /**
     * Deletes a `ChannelNamespace`.
     */
    public suspend fun deleteChannelNamespace(input: DeleteChannelNamespaceRequest): DeleteChannelNamespaceResponse

    /**
     * Deletes a `DataSource` object.
     */
    public suspend fun deleteDataSource(input: DeleteDataSourceRequest): DeleteDataSourceResponse

    /**
     * Deletes a custom `DomainName` object.
     */
    public suspend fun deleteDomainName(input: DeleteDomainNameRequest): DeleteDomainNameResponse

    /**
     * Deletes a `Function`.
     */
    public suspend fun deleteFunction(input: DeleteFunctionRequest): DeleteFunctionResponse

    /**
     * Deletes a `GraphqlApi` object.
     */
    public suspend fun deleteGraphqlApi(input: DeleteGraphqlApiRequest): DeleteGraphqlApiResponse

    /**
     * Deletes a `Resolver` object.
     */
    public suspend fun deleteResolver(input: DeleteResolverRequest): DeleteResolverResponse

    /**
     * Deletes a `Type` object.
     */
    public suspend fun deleteType(input: DeleteTypeRequest): DeleteTypeResponse

    /**
     * Removes an `ApiAssociation` object from a custom domain.
     */
    public suspend fun disassociateApi(input: DisassociateApiRequest): DisassociateApiResponse

    /**
     * Deletes an association between a Merged API and source API using the source API's identifier and the association ID.
     */
    public suspend fun disassociateMergedGraphqlApi(input: DisassociateMergedGraphqlApiRequest): DisassociateMergedGraphqlApiResponse

    /**
     * Deletes an association between a Merged API and source API using the Merged API's identifier and the association ID.
     */
    public suspend fun disassociateSourceGraphqlApi(input: DisassociateSourceGraphqlApiRequest): DisassociateSourceGraphqlApiResponse

    /**
     * Evaluates the given code and returns the response. The code definition requirements depend on the specified runtime. For `APPSYNC_JS` runtimes, the code defines the request and response functions. The request function takes the incoming request after a GraphQL operation is parsed and converts it into a request configuration for the selected data source operation. The response function interprets responses from the data source and maps it to the shape of the GraphQL field output type.
     */
    public suspend fun evaluateCode(input: EvaluateCodeRequest): EvaluateCodeResponse

    /**
     * Evaluates a given template and returns the response. The mapping template can be a request or response template.
     *
     * Request templates take the incoming request after a GraphQL operation is parsed and convert it into a request configuration for the selected data source operation. Response templates interpret responses from the data source and map it to the shape of the GraphQL field output type.
     *
     * Mapping templates are written in the Apache Velocity Template Language (VTL).
     */
    public suspend fun evaluateMappingTemplate(input: EvaluateMappingTemplateRequest): EvaluateMappingTemplateResponse

    /**
     * Flushes an `ApiCache` object.
     */
    public suspend fun flushApiCache(input: FlushApiCacheRequest): FlushApiCacheResponse

    /**
     * Retrieves an `Api` object.
     */
    public suspend fun getApi(input: GetApiRequest): GetApiResponse

    /**
     * Retrieves an `ApiAssociation` object.
     */
    public suspend fun getApiAssociation(input: GetApiAssociationRequest): GetApiAssociationResponse

    /**
     * Retrieves an `ApiCache` object.
     */
    public suspend fun getApiCache(input: GetApiCacheRequest): GetApiCacheResponse

    /**
     * Retrieves the channel namespace for a specified `Api`.
     */
    public suspend fun getChannelNamespace(input: GetChannelNamespaceRequest): GetChannelNamespaceResponse

    /**
     * Retrieves a `DataSource` object.
     */
    public suspend fun getDataSource(input: GetDataSourceRequest): GetDataSourceResponse

    /**
     * Retrieves the record of an existing introspection. If the retrieval is successful, the result of the instrospection will also be returned. If the retrieval fails the operation, an error message will be returned instead.
     */
    public suspend fun getDataSourceIntrospection(input: GetDataSourceIntrospectionRequest): GetDataSourceIntrospectionResponse

    /**
     * Retrieves a custom `DomainName` object.
     */
    public suspend fun getDomainName(input: GetDomainNameRequest): GetDomainNameResponse

    /**
     * Get a `Function`.
     */
    public suspend fun getFunction(input: GetFunctionRequest): GetFunctionResponse

    /**
     * Retrieves a `GraphqlApi` object.
     */
    public suspend fun getGraphqlApi(input: GetGraphqlApiRequest): GetGraphqlApiResponse

    /**
     * Retrieves the list of environmental variable key-value pairs associated with an API by its ID value.
     */
    public suspend fun getGraphqlApiEnvironmentVariables(input: GetGraphqlApiEnvironmentVariablesRequest): GetGraphqlApiEnvironmentVariablesResponse

    /**
     * Retrieves the introspection schema for a GraphQL API.
     */
    public suspend fun getIntrospectionSchema(input: GetIntrospectionSchemaRequest): GetIntrospectionSchemaResponse

    /**
     * Retrieves a `Resolver` object.
     */
    public suspend fun getResolver(input: GetResolverRequest): GetResolverResponse

    /**
     * Retrieves the current status of a schema creation operation.
     */
    public suspend fun getSchemaCreationStatus(input: GetSchemaCreationStatusRequest): GetSchemaCreationStatusResponse

    /**
     * Retrieves a `SourceApiAssociation` object.
     */
    public suspend fun getSourceApiAssociation(input: GetSourceApiAssociationRequest): GetSourceApiAssociationResponse

    /**
     * Retrieves a `Type` object.
     */
    public suspend fun getType(input: GetTypeRequest): GetTypeResponse

    /**
     * Lists the API keys for a given API.
     *
     * API keys are deleted automatically 60 days after they expire. However, they may still be included in the response until they have actually been deleted. You can safely call `DeleteApiKey` to manually delete a key before it's automatically deleted.
     */
    public suspend fun listApiKeys(input: ListApiKeysRequest): ListApiKeysResponse

    /**
     * Lists the APIs in your AppSync account.
     *
     * `ListApis` returns only the high level API details. For more detailed information about an API, use `GetApi`.
     */
    public suspend fun listApis(input: ListApisRequest = ListApisRequest { }): ListApisResponse

    /**
     * Lists the channel namespaces for a specified `Api`.
     *
     * `ListChannelNamespaces` returns only high level details for the channel namespace. To retrieve code handlers, use `GetChannelNamespace`.
     */
    public suspend fun listChannelNamespaces(input: ListChannelNamespacesRequest): ListChannelNamespacesResponse

    /**
     * Lists the data sources for a given API.
     */
    public suspend fun listDataSources(input: ListDataSourcesRequest): ListDataSourcesResponse

    /**
     * Lists multiple custom domain names.
     */
    public suspend fun listDomainNames(input: ListDomainNamesRequest = ListDomainNamesRequest { }): ListDomainNamesResponse

    /**
     * List multiple functions.
     */
    public suspend fun listFunctions(input: ListFunctionsRequest): ListFunctionsResponse

    /**
     * Lists your GraphQL APIs.
     */
    public suspend fun listGraphqlApis(input: ListGraphqlApisRequest = ListGraphqlApisRequest { }): ListGraphqlApisResponse

    /**
     * Lists the resolvers for a given API and type.
     */
    public suspend fun listResolvers(input: ListResolversRequest): ListResolversResponse

    /**
     * List the resolvers that are associated with a specific function.
     */
    public suspend fun listResolversByFunction(input: ListResolversByFunctionRequest): ListResolversByFunctionResponse

    /**
     * Lists the `SourceApiAssociationSummary` data.
     */
    public suspend fun listSourceApiAssociations(input: ListSourceApiAssociationsRequest): ListSourceApiAssociationsResponse

    /**
     * Lists the tags for a resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the types for a given API.
     */
    public suspend fun listTypes(input: ListTypesRequest): ListTypesResponse

    /**
     * Lists `Type` objects by the source API association ID.
     */
    public suspend fun listTypesByAssociation(input: ListTypesByAssociationRequest): ListTypesByAssociationResponse

    /**
     * Creates a list of environmental variables in an API by its ID value.
     *
     * When creating an environmental variable, it must follow the constraints below:
     * + Both JavaScript and VTL templates support environmental variables.
     * + Environmental variables are not evaluated before function invocation.
     * + Environmental variables only support string values.
     * + Any defined value in an environmental variable is considered a string literal and not expanded.
     * + Variable evaluations should ideally be performed in the function code.
     *
     * When creating an environmental variable key-value pair, it must follow the additional constraints below:
     * + Keys must begin with a letter.
     * + Keys must be at least two characters long.
     * + Keys can only contain letters, numbers, and the underscore character (_).
     * + Values can be up to 512 characters long.
     * + You can configure up to 50 key-value pairs in a GraphQL API.
     *
     * You can create a list of environmental variables by adding it to the `environmentVariables` payload as a list in the format `{"key1":"value1","key2":"value2", …}`. Note that each call of the `PutGraphqlApiEnvironmentVariables` action will result in the overwriting of the existing environmental variable list of that API. This means the existing environmental variables will be lost. To avoid this, you must include all existing and new environmental variables in the list each time you call this action.
     */
    public suspend fun putGraphqlApiEnvironmentVariables(input: PutGraphqlApiEnvironmentVariablesRequest): PutGraphqlApiEnvironmentVariablesResponse

    /**
     * Creates a new introspection. Returns the `introspectionId` of the new introspection after its creation.
     */
    public suspend fun startDataSourceIntrospection(input: StartDataSourceIntrospectionRequest = StartDataSourceIntrospectionRequest { }): StartDataSourceIntrospectionResponse

    /**
     * Adds a new schema to your GraphQL API.
     *
     * This operation is asynchronous. Use to determine when it has completed.
     */
    public suspend fun startSchemaCreation(input: StartSchemaCreationRequest): StartSchemaCreationResponse

    /**
     * Initiates a merge operation. Returns a status that shows the result of the merge operation.
     */
    public suspend fun startSchemaMerge(input: StartSchemaMergeRequest): StartSchemaMergeResponse

    /**
     * Tags a resource with user-supplied tags.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Untags a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an `Api`.
     */
    public suspend fun updateApi(input: UpdateApiRequest): UpdateApiResponse

    /**
     * Updates the cache for the GraphQL API.
     */
    public suspend fun updateApiCache(input: UpdateApiCacheRequest): UpdateApiCacheResponse

    /**
     * Updates an API key. You can update the key as long as it's not deleted.
     */
    public suspend fun updateApiKey(input: UpdateApiKeyRequest): UpdateApiKeyResponse

    /**
     * Updates a `ChannelNamespace` associated with an `Api`.
     */
    public suspend fun updateChannelNamespace(input: UpdateChannelNamespaceRequest): UpdateChannelNamespaceResponse

    /**
     * Updates a `DataSource` object.
     */
    public suspend fun updateDataSource(input: UpdateDataSourceRequest): UpdateDataSourceResponse

    /**
     * Updates a custom `DomainName` object.
     */
    public suspend fun updateDomainName(input: UpdateDomainNameRequest): UpdateDomainNameResponse

    /**
     * Updates a `Function` object.
     */
    public suspend fun updateFunction(input: UpdateFunctionRequest): UpdateFunctionResponse

    /**
     * Updates a `GraphqlApi` object.
     */
    public suspend fun updateGraphqlApi(input: UpdateGraphqlApiRequest): UpdateGraphqlApiResponse

    /**
     * Updates a `Resolver` object.
     */
    public suspend fun updateResolver(input: UpdateResolverRequest): UpdateResolverResponse

    /**
     * Updates some of the configuration choices of a particular source API association.
     */
    public suspend fun updateSourceApiAssociation(input: UpdateSourceApiAssociationRequest): UpdateSourceApiAssociationResponse

    /**
     * Updates a `Type` object.
     */
    public suspend fun updateType(input: UpdateTypeRequest): UpdateTypeResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun AppSyncClient.withConfig(block: AppSyncClient.Config.Builder.() -> Unit): AppSyncClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultAppSyncClient(newConfig)
}

/**
 * Maps an endpoint to your custom domain.
 */
public suspend inline fun AppSyncClient.associateApi(crossinline block: AssociateApiRequest.Builder.() -> Unit): AssociateApiResponse = associateApi(AssociateApiRequest.Builder().apply(block).build())

/**
 * Creates an association between a Merged API and source API using the source API's identifier.
 */
public suspend inline fun AppSyncClient.associateMergedGraphqlApi(crossinline block: AssociateMergedGraphqlApiRequest.Builder.() -> Unit): AssociateMergedGraphqlApiResponse = associateMergedGraphqlApi(AssociateMergedGraphqlApiRequest.Builder().apply(block).build())

/**
 * Creates an association between a Merged API and source API using the Merged API's identifier.
 */
public suspend inline fun AppSyncClient.associateSourceGraphqlApi(crossinline block: AssociateSourceGraphqlApiRequest.Builder.() -> Unit): AssociateSourceGraphqlApiResponse = associateSourceGraphqlApi(AssociateSourceGraphqlApiRequest.Builder().apply(block).build())

/**
 * Creates an `Api` object. Use this operation to create an AppSync API with your preferred configuration, such as an Event API that provides real-time message publishing and message subscriptions over WebSockets.
 */
public suspend inline fun AppSyncClient.createApi(crossinline block: CreateApiRequest.Builder.() -> Unit): CreateApiResponse = createApi(CreateApiRequest.Builder().apply(block).build())

/**
 * Creates a cache for the GraphQL API.
 */
public suspend inline fun AppSyncClient.createApiCache(crossinline block: CreateApiCacheRequest.Builder.() -> Unit): CreateApiCacheResponse = createApiCache(CreateApiCacheRequest.Builder().apply(block).build())

/**
 * Creates a unique key that you can distribute to clients who invoke your API.
 */
public suspend inline fun AppSyncClient.createApiKey(crossinline block: CreateApiKeyRequest.Builder.() -> Unit): CreateApiKeyResponse = createApiKey(CreateApiKeyRequest.Builder().apply(block).build())

/**
 * Creates a `ChannelNamespace` for an `Api`.
 */
public suspend inline fun AppSyncClient.createChannelNamespace(crossinline block: CreateChannelNamespaceRequest.Builder.() -> Unit): CreateChannelNamespaceResponse = createChannelNamespace(CreateChannelNamespaceRequest.Builder().apply(block).build())

/**
 * Creates a `DataSource` object.
 */
public suspend inline fun AppSyncClient.createDataSource(crossinline block: CreateDataSourceRequest.Builder.() -> Unit): CreateDataSourceResponse = createDataSource(CreateDataSourceRequest.Builder().apply(block).build())

/**
 * Creates a custom `DomainName` object.
 */
public suspend inline fun AppSyncClient.createDomainName(crossinline block: CreateDomainNameRequest.Builder.() -> Unit): CreateDomainNameResponse = createDomainName(CreateDomainNameRequest.Builder().apply(block).build())

/**
 * Creates a `Function` object.
 *
 * A function is a reusable entity. You can use multiple functions to compose the resolver logic.
 */
public suspend inline fun AppSyncClient.createFunction(crossinline block: CreateFunctionRequest.Builder.() -> Unit): CreateFunctionResponse = createFunction(CreateFunctionRequest.Builder().apply(block).build())

/**
 * Creates a `GraphqlApi` object.
 */
public suspend inline fun AppSyncClient.createGraphqlApi(crossinline block: CreateGraphqlApiRequest.Builder.() -> Unit): CreateGraphqlApiResponse = createGraphqlApi(CreateGraphqlApiRequest.Builder().apply(block).build())

/**
 * Creates a `Resolver` object.
 *
 * A resolver converts incoming requests into a format that a data source can understand, and converts the data source's responses into GraphQL.
 */
public suspend inline fun AppSyncClient.createResolver(crossinline block: CreateResolverRequest.Builder.() -> Unit): CreateResolverResponse = createResolver(CreateResolverRequest.Builder().apply(block).build())

/**
 * Creates a `Type` object.
 */
public suspend inline fun AppSyncClient.createType(crossinline block: CreateTypeRequest.Builder.() -> Unit): CreateTypeResponse = createType(CreateTypeRequest.Builder().apply(block).build())

/**
 * Deletes an `Api` object
 */
public suspend inline fun AppSyncClient.deleteApi(crossinline block: DeleteApiRequest.Builder.() -> Unit): DeleteApiResponse = deleteApi(DeleteApiRequest.Builder().apply(block).build())

/**
 * Deletes an `ApiCache` object.
 */
public suspend inline fun AppSyncClient.deleteApiCache(crossinline block: DeleteApiCacheRequest.Builder.() -> Unit): DeleteApiCacheResponse = deleteApiCache(DeleteApiCacheRequest.Builder().apply(block).build())

/**
 * Deletes an API key.
 */
public suspend inline fun AppSyncClient.deleteApiKey(crossinline block: DeleteApiKeyRequest.Builder.() -> Unit): DeleteApiKeyResponse = deleteApiKey(DeleteApiKeyRequest.Builder().apply(block).build())

/**
 * Deletes a `ChannelNamespace`.
 */
public suspend inline fun AppSyncClient.deleteChannelNamespace(crossinline block: DeleteChannelNamespaceRequest.Builder.() -> Unit): DeleteChannelNamespaceResponse = deleteChannelNamespace(DeleteChannelNamespaceRequest.Builder().apply(block).build())

/**
 * Deletes a `DataSource` object.
 */
public suspend inline fun AppSyncClient.deleteDataSource(crossinline block: DeleteDataSourceRequest.Builder.() -> Unit): DeleteDataSourceResponse = deleteDataSource(DeleteDataSourceRequest.Builder().apply(block).build())

/**
 * Deletes a custom `DomainName` object.
 */
public suspend inline fun AppSyncClient.deleteDomainName(crossinline block: DeleteDomainNameRequest.Builder.() -> Unit): DeleteDomainNameResponse = deleteDomainName(DeleteDomainNameRequest.Builder().apply(block).build())

/**
 * Deletes a `Function`.
 */
public suspend inline fun AppSyncClient.deleteFunction(crossinline block: DeleteFunctionRequest.Builder.() -> Unit): DeleteFunctionResponse = deleteFunction(DeleteFunctionRequest.Builder().apply(block).build())

/**
 * Deletes a `GraphqlApi` object.
 */
public suspend inline fun AppSyncClient.deleteGraphqlApi(crossinline block: DeleteGraphqlApiRequest.Builder.() -> Unit): DeleteGraphqlApiResponse = deleteGraphqlApi(DeleteGraphqlApiRequest.Builder().apply(block).build())

/**
 * Deletes a `Resolver` object.
 */
public suspend inline fun AppSyncClient.deleteResolver(crossinline block: DeleteResolverRequest.Builder.() -> Unit): DeleteResolverResponse = deleteResolver(DeleteResolverRequest.Builder().apply(block).build())

/**
 * Deletes a `Type` object.
 */
public suspend inline fun AppSyncClient.deleteType(crossinline block: DeleteTypeRequest.Builder.() -> Unit): DeleteTypeResponse = deleteType(DeleteTypeRequest.Builder().apply(block).build())

/**
 * Removes an `ApiAssociation` object from a custom domain.
 */
public suspend inline fun AppSyncClient.disassociateApi(crossinline block: DisassociateApiRequest.Builder.() -> Unit): DisassociateApiResponse = disassociateApi(DisassociateApiRequest.Builder().apply(block).build())

/**
 * Deletes an association between a Merged API and source API using the source API's identifier and the association ID.
 */
public suspend inline fun AppSyncClient.disassociateMergedGraphqlApi(crossinline block: DisassociateMergedGraphqlApiRequest.Builder.() -> Unit): DisassociateMergedGraphqlApiResponse = disassociateMergedGraphqlApi(DisassociateMergedGraphqlApiRequest.Builder().apply(block).build())

/**
 * Deletes an association between a Merged API and source API using the Merged API's identifier and the association ID.
 */
public suspend inline fun AppSyncClient.disassociateSourceGraphqlApi(crossinline block: DisassociateSourceGraphqlApiRequest.Builder.() -> Unit): DisassociateSourceGraphqlApiResponse = disassociateSourceGraphqlApi(DisassociateSourceGraphqlApiRequest.Builder().apply(block).build())

/**
 * Evaluates the given code and returns the response. The code definition requirements depend on the specified runtime. For `APPSYNC_JS` runtimes, the code defines the request and response functions. The request function takes the incoming request after a GraphQL operation is parsed and converts it into a request configuration for the selected data source operation. The response function interprets responses from the data source and maps it to the shape of the GraphQL field output type.
 */
public suspend inline fun AppSyncClient.evaluateCode(crossinline block: EvaluateCodeRequest.Builder.() -> Unit): EvaluateCodeResponse = evaluateCode(EvaluateCodeRequest.Builder().apply(block).build())

/**
 * Evaluates a given template and returns the response. The mapping template can be a request or response template.
 *
 * Request templates take the incoming request after a GraphQL operation is parsed and convert it into a request configuration for the selected data source operation. Response templates interpret responses from the data source and map it to the shape of the GraphQL field output type.
 *
 * Mapping templates are written in the Apache Velocity Template Language (VTL).
 */
public suspend inline fun AppSyncClient.evaluateMappingTemplate(crossinline block: EvaluateMappingTemplateRequest.Builder.() -> Unit): EvaluateMappingTemplateResponse = evaluateMappingTemplate(EvaluateMappingTemplateRequest.Builder().apply(block).build())

/**
 * Flushes an `ApiCache` object.
 */
public suspend inline fun AppSyncClient.flushApiCache(crossinline block: FlushApiCacheRequest.Builder.() -> Unit): FlushApiCacheResponse = flushApiCache(FlushApiCacheRequest.Builder().apply(block).build())

/**
 * Retrieves an `Api` object.
 */
public suspend inline fun AppSyncClient.getApi(crossinline block: GetApiRequest.Builder.() -> Unit): GetApiResponse = getApi(GetApiRequest.Builder().apply(block).build())

/**
 * Retrieves an `ApiAssociation` object.
 */
public suspend inline fun AppSyncClient.getApiAssociation(crossinline block: GetApiAssociationRequest.Builder.() -> Unit): GetApiAssociationResponse = getApiAssociation(GetApiAssociationRequest.Builder().apply(block).build())

/**
 * Retrieves an `ApiCache` object.
 */
public suspend inline fun AppSyncClient.getApiCache(crossinline block: GetApiCacheRequest.Builder.() -> Unit): GetApiCacheResponse = getApiCache(GetApiCacheRequest.Builder().apply(block).build())

/**
 * Retrieves the channel namespace for a specified `Api`.
 */
public suspend inline fun AppSyncClient.getChannelNamespace(crossinline block: GetChannelNamespaceRequest.Builder.() -> Unit): GetChannelNamespaceResponse = getChannelNamespace(GetChannelNamespaceRequest.Builder().apply(block).build())

/**
 * Retrieves a `DataSource` object.
 */
public suspend inline fun AppSyncClient.getDataSource(crossinline block: GetDataSourceRequest.Builder.() -> Unit): GetDataSourceResponse = getDataSource(GetDataSourceRequest.Builder().apply(block).build())

/**
 * Retrieves the record of an existing introspection. If the retrieval is successful, the result of the instrospection will also be returned. If the retrieval fails the operation, an error message will be returned instead.
 */
public suspend inline fun AppSyncClient.getDataSourceIntrospection(crossinline block: GetDataSourceIntrospectionRequest.Builder.() -> Unit): GetDataSourceIntrospectionResponse = getDataSourceIntrospection(GetDataSourceIntrospectionRequest.Builder().apply(block).build())

/**
 * Retrieves a custom `DomainName` object.
 */
public suspend inline fun AppSyncClient.getDomainName(crossinline block: GetDomainNameRequest.Builder.() -> Unit): GetDomainNameResponse = getDomainName(GetDomainNameRequest.Builder().apply(block).build())

/**
 * Get a `Function`.
 */
public suspend inline fun AppSyncClient.getFunction(crossinline block: GetFunctionRequest.Builder.() -> Unit): GetFunctionResponse = getFunction(GetFunctionRequest.Builder().apply(block).build())

/**
 * Retrieves a `GraphqlApi` object.
 */
public suspend inline fun AppSyncClient.getGraphqlApi(crossinline block: GetGraphqlApiRequest.Builder.() -> Unit): GetGraphqlApiResponse = getGraphqlApi(GetGraphqlApiRequest.Builder().apply(block).build())

/**
 * Retrieves the list of environmental variable key-value pairs associated with an API by its ID value.
 */
public suspend inline fun AppSyncClient.getGraphqlApiEnvironmentVariables(crossinline block: GetGraphqlApiEnvironmentVariablesRequest.Builder.() -> Unit): GetGraphqlApiEnvironmentVariablesResponse = getGraphqlApiEnvironmentVariables(GetGraphqlApiEnvironmentVariablesRequest.Builder().apply(block).build())

/**
 * Retrieves the introspection schema for a GraphQL API.
 */
public suspend inline fun AppSyncClient.getIntrospectionSchema(crossinline block: GetIntrospectionSchemaRequest.Builder.() -> Unit): GetIntrospectionSchemaResponse = getIntrospectionSchema(GetIntrospectionSchemaRequest.Builder().apply(block).build())

/**
 * Retrieves a `Resolver` object.
 */
public suspend inline fun AppSyncClient.getResolver(crossinline block: GetResolverRequest.Builder.() -> Unit): GetResolverResponse = getResolver(GetResolverRequest.Builder().apply(block).build())

/**
 * Retrieves the current status of a schema creation operation.
 */
public suspend inline fun AppSyncClient.getSchemaCreationStatus(crossinline block: GetSchemaCreationStatusRequest.Builder.() -> Unit): GetSchemaCreationStatusResponse = getSchemaCreationStatus(GetSchemaCreationStatusRequest.Builder().apply(block).build())

/**
 * Retrieves a `SourceApiAssociation` object.
 */
public suspend inline fun AppSyncClient.getSourceApiAssociation(crossinline block: GetSourceApiAssociationRequest.Builder.() -> Unit): GetSourceApiAssociationResponse = getSourceApiAssociation(GetSourceApiAssociationRequest.Builder().apply(block).build())

/**
 * Retrieves a `Type` object.
 */
public suspend inline fun AppSyncClient.getType(crossinline block: GetTypeRequest.Builder.() -> Unit): GetTypeResponse = getType(GetTypeRequest.Builder().apply(block).build())

/**
 * Lists the API keys for a given API.
 *
 * API keys are deleted automatically 60 days after they expire. However, they may still be included in the response until they have actually been deleted. You can safely call `DeleteApiKey` to manually delete a key before it's automatically deleted.
 */
public suspend inline fun AppSyncClient.listApiKeys(crossinline block: ListApiKeysRequest.Builder.() -> Unit): ListApiKeysResponse = listApiKeys(ListApiKeysRequest.Builder().apply(block).build())

/**
 * Lists the APIs in your AppSync account.
 *
 * `ListApis` returns only the high level API details. For more detailed information about an API, use `GetApi`.
 */
public suspend inline fun AppSyncClient.listApis(crossinline block: ListApisRequest.Builder.() -> Unit): ListApisResponse = listApis(ListApisRequest.Builder().apply(block).build())

/**
 * Lists the channel namespaces for a specified `Api`.
 *
 * `ListChannelNamespaces` returns only high level details for the channel namespace. To retrieve code handlers, use `GetChannelNamespace`.
 */
public suspend inline fun AppSyncClient.listChannelNamespaces(crossinline block: ListChannelNamespacesRequest.Builder.() -> Unit): ListChannelNamespacesResponse = listChannelNamespaces(ListChannelNamespacesRequest.Builder().apply(block).build())

/**
 * Lists the data sources for a given API.
 */
public suspend inline fun AppSyncClient.listDataSources(crossinline block: ListDataSourcesRequest.Builder.() -> Unit): ListDataSourcesResponse = listDataSources(ListDataSourcesRequest.Builder().apply(block).build())

/**
 * Lists multiple custom domain names.
 */
public suspend inline fun AppSyncClient.listDomainNames(crossinline block: ListDomainNamesRequest.Builder.() -> Unit): ListDomainNamesResponse = listDomainNames(ListDomainNamesRequest.Builder().apply(block).build())

/**
 * List multiple functions.
 */
public suspend inline fun AppSyncClient.listFunctions(crossinline block: ListFunctionsRequest.Builder.() -> Unit): ListFunctionsResponse = listFunctions(ListFunctionsRequest.Builder().apply(block).build())

/**
 * Lists your GraphQL APIs.
 */
public suspend inline fun AppSyncClient.listGraphqlApis(crossinline block: ListGraphqlApisRequest.Builder.() -> Unit): ListGraphqlApisResponse = listGraphqlApis(ListGraphqlApisRequest.Builder().apply(block).build())

/**
 * Lists the resolvers for a given API and type.
 */
public suspend inline fun AppSyncClient.listResolvers(crossinline block: ListResolversRequest.Builder.() -> Unit): ListResolversResponse = listResolvers(ListResolversRequest.Builder().apply(block).build())

/**
 * List the resolvers that are associated with a specific function.
 */
public suspend inline fun AppSyncClient.listResolversByFunction(crossinline block: ListResolversByFunctionRequest.Builder.() -> Unit): ListResolversByFunctionResponse = listResolversByFunction(ListResolversByFunctionRequest.Builder().apply(block).build())

/**
 * Lists the `SourceApiAssociationSummary` data.
 */
public suspend inline fun AppSyncClient.listSourceApiAssociations(crossinline block: ListSourceApiAssociationsRequest.Builder.() -> Unit): ListSourceApiAssociationsResponse = listSourceApiAssociations(ListSourceApiAssociationsRequest.Builder().apply(block).build())

/**
 * Lists the tags for a resource.
 */
public suspend inline fun AppSyncClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists the types for a given API.
 */
public suspend inline fun AppSyncClient.listTypes(crossinline block: ListTypesRequest.Builder.() -> Unit): ListTypesResponse = listTypes(ListTypesRequest.Builder().apply(block).build())

/**
 * Lists `Type` objects by the source API association ID.
 */
public suspend inline fun AppSyncClient.listTypesByAssociation(crossinline block: ListTypesByAssociationRequest.Builder.() -> Unit): ListTypesByAssociationResponse = listTypesByAssociation(ListTypesByAssociationRequest.Builder().apply(block).build())

/**
 * Creates a list of environmental variables in an API by its ID value.
 *
 * When creating an environmental variable, it must follow the constraints below:
 * + Both JavaScript and VTL templates support environmental variables.
 * + Environmental variables are not evaluated before function invocation.
 * + Environmental variables only support string values.
 * + Any defined value in an environmental variable is considered a string literal and not expanded.
 * + Variable evaluations should ideally be performed in the function code.
 *
 * When creating an environmental variable key-value pair, it must follow the additional constraints below:
 * + Keys must begin with a letter.
 * + Keys must be at least two characters long.
 * + Keys can only contain letters, numbers, and the underscore character (_).
 * + Values can be up to 512 characters long.
 * + You can configure up to 50 key-value pairs in a GraphQL API.
 *
 * You can create a list of environmental variables by adding it to the `environmentVariables` payload as a list in the format `{"key1":"value1","key2":"value2", …}`. Note that each call of the `PutGraphqlApiEnvironmentVariables` action will result in the overwriting of the existing environmental variable list of that API. This means the existing environmental variables will be lost. To avoid this, you must include all existing and new environmental variables in the list each time you call this action.
 */
public suspend inline fun AppSyncClient.putGraphqlApiEnvironmentVariables(crossinline block: PutGraphqlApiEnvironmentVariablesRequest.Builder.() -> Unit): PutGraphqlApiEnvironmentVariablesResponse = putGraphqlApiEnvironmentVariables(PutGraphqlApiEnvironmentVariablesRequest.Builder().apply(block).build())

/**
 * Creates a new introspection. Returns the `introspectionId` of the new introspection after its creation.
 */
public suspend inline fun AppSyncClient.startDataSourceIntrospection(crossinline block: StartDataSourceIntrospectionRequest.Builder.() -> Unit): StartDataSourceIntrospectionResponse = startDataSourceIntrospection(StartDataSourceIntrospectionRequest.Builder().apply(block).build())

/**
 * Adds a new schema to your GraphQL API.
 *
 * This operation is asynchronous. Use to determine when it has completed.
 */
public suspend inline fun AppSyncClient.startSchemaCreation(crossinline block: StartSchemaCreationRequest.Builder.() -> Unit): StartSchemaCreationResponse = startSchemaCreation(StartSchemaCreationRequest.Builder().apply(block).build())

/**
 * Initiates a merge operation. Returns a status that shows the result of the merge operation.
 */
public suspend inline fun AppSyncClient.startSchemaMerge(crossinline block: StartSchemaMergeRequest.Builder.() -> Unit): StartSchemaMergeResponse = startSchemaMerge(StartSchemaMergeRequest.Builder().apply(block).build())

/**
 * Tags a resource with user-supplied tags.
 */
public suspend inline fun AppSyncClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Untags a resource.
 */
public suspend inline fun AppSyncClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an `Api`.
 */
public suspend inline fun AppSyncClient.updateApi(crossinline block: UpdateApiRequest.Builder.() -> Unit): UpdateApiResponse = updateApi(UpdateApiRequest.Builder().apply(block).build())

/**
 * Updates the cache for the GraphQL API.
 */
public suspend inline fun AppSyncClient.updateApiCache(crossinline block: UpdateApiCacheRequest.Builder.() -> Unit): UpdateApiCacheResponse = updateApiCache(UpdateApiCacheRequest.Builder().apply(block).build())

/**
 * Updates an API key. You can update the key as long as it's not deleted.
 */
public suspend inline fun AppSyncClient.updateApiKey(crossinline block: UpdateApiKeyRequest.Builder.() -> Unit): UpdateApiKeyResponse = updateApiKey(UpdateApiKeyRequest.Builder().apply(block).build())

/**
 * Updates a `ChannelNamespace` associated with an `Api`.
 */
public suspend inline fun AppSyncClient.updateChannelNamespace(crossinline block: UpdateChannelNamespaceRequest.Builder.() -> Unit): UpdateChannelNamespaceResponse = updateChannelNamespace(UpdateChannelNamespaceRequest.Builder().apply(block).build())

/**
 * Updates a `DataSource` object.
 */
public suspend inline fun AppSyncClient.updateDataSource(crossinline block: UpdateDataSourceRequest.Builder.() -> Unit): UpdateDataSourceResponse = updateDataSource(UpdateDataSourceRequest.Builder().apply(block).build())

/**
 * Updates a custom `DomainName` object.
 */
public suspend inline fun AppSyncClient.updateDomainName(crossinline block: UpdateDomainNameRequest.Builder.() -> Unit): UpdateDomainNameResponse = updateDomainName(UpdateDomainNameRequest.Builder().apply(block).build())

/**
 * Updates a `Function` object.
 */
public suspend inline fun AppSyncClient.updateFunction(crossinline block: UpdateFunctionRequest.Builder.() -> Unit): UpdateFunctionResponse = updateFunction(UpdateFunctionRequest.Builder().apply(block).build())

/**
 * Updates a `GraphqlApi` object.
 */
public suspend inline fun AppSyncClient.updateGraphqlApi(crossinline block: UpdateGraphqlApiRequest.Builder.() -> Unit): UpdateGraphqlApiResponse = updateGraphqlApi(UpdateGraphqlApiRequest.Builder().apply(block).build())

/**
 * Updates a `Resolver` object.
 */
public suspend inline fun AppSyncClient.updateResolver(crossinline block: UpdateResolverRequest.Builder.() -> Unit): UpdateResolverResponse = updateResolver(UpdateResolverRequest.Builder().apply(block).build())

/**
 * Updates some of the configuration choices of a particular source API association.
 */
public suspend inline fun AppSyncClient.updateSourceApiAssociation(crossinline block: UpdateSourceApiAssociationRequest.Builder.() -> Unit): UpdateSourceApiAssociationResponse = updateSourceApiAssociation(UpdateSourceApiAssociationRequest.Builder().apply(block).build())

/**
 * Updates a `Type` object.
 */
public suspend inline fun AppSyncClient.updateType(crossinline block: UpdateTypeRequest.Builder.() -> Unit): UpdateTypeResponse = updateType(UpdateTypeRequest.Builder().apply(block).build())
