// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.serde

import aws.sdk.kotlin.services.appsync.model.AdditionalAuthenticationProvider
import aws.sdk.kotlin.services.appsync.model.AuthenticationType
import aws.sdk.kotlin.services.appsync.model.EnhancedMetricsConfig
import aws.sdk.kotlin.services.appsync.model.GraphQlApiIntrospectionConfig
import aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig
import aws.sdk.kotlin.services.appsync.model.LogConfig
import aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig
import aws.sdk.kotlin.services.appsync.model.UpdateGraphqlApiRequest
import aws.sdk.kotlin.services.appsync.model.UserPoolConfig
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateGraphqlApiOperationSerializer: HttpSerializer.NonStreaming<UpdateGraphqlApiRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateGraphqlApiRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.apiId) { "apiId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v1"))
                add(PercentEncoding.Path.encode("apis"))
                add(PercentEncoding.SmithyLabel.encode(input.apiId))
            }
        }

        val payload = serializeUpdateGraphqlApiOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateGraphqlApiOperationBody(context: ExecutionContext, input: UpdateGraphqlApiRequest): ByteArray {
    val serializer = JsonSerializer()
    val ADDITIONALAUTHENTICATIONPROVIDERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("additionalAuthenticationProviders"))
    val AUTHENTICATIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("authenticationType"))
    val ENHANCEDMETRICSCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("enhancedMetricsConfig"))
    val INTROSPECTIONCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("introspectionConfig"))
    val LAMBDAAUTHORIZERCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("lambdaAuthorizerConfig"))
    val LOGCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("logConfig"))
    val MERGEDAPIEXECUTIONROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("mergedApiExecutionRoleArn"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val OPENIDCONNECTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("openIDConnectConfig"))
    val OWNERCONTACT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ownerContact"))
    val QUERYDEPTHLIMIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("queryDepthLimit"))
    val RESOLVERCOUNTLIMIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("resolverCountLimit"))
    val USERPOOLCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("userPoolConfig"))
    val XRAYENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("xrayEnabled"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDITIONALAUTHENTICATIONPROVIDERS_DESCRIPTOR)
        field(AUTHENTICATIONTYPE_DESCRIPTOR)
        field(ENHANCEDMETRICSCONFIG_DESCRIPTOR)
        field(INTROSPECTIONCONFIG_DESCRIPTOR)
        field(LAMBDAAUTHORIZERCONFIG_DESCRIPTOR)
        field(LOGCONFIG_DESCRIPTOR)
        field(MERGEDAPIEXECUTIONROLEARN_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OPENIDCONNECTCONFIG_DESCRIPTOR)
        field(OWNERCONTACT_DESCRIPTOR)
        field(QUERYDEPTHLIMIT_DESCRIPTOR)
        field(RESOLVERCOUNTLIMIT_DESCRIPTOR)
        field(USERPOOLCONFIG_DESCRIPTOR)
        field(XRAYENABLED_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.additionalAuthenticationProviders != null) {
            listField(ADDITIONALAUTHENTICATIONPROVIDERS_DESCRIPTOR) {
                for (el0 in input.additionalAuthenticationProviders) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAdditionalAuthenticationProviderDocument))
                }
            }
        }
        input.authenticationType?.let { field(AUTHENTICATIONTYPE_DESCRIPTOR, it.value) }
        input.enhancedMetricsConfig?.let { field(ENHANCEDMETRICSCONFIG_DESCRIPTOR, it, ::serializeEnhancedMetricsConfigDocument) }
        input.introspectionConfig?.let { field(INTROSPECTIONCONFIG_DESCRIPTOR, it.value) }
        input.lambdaAuthorizerConfig?.let { field(LAMBDAAUTHORIZERCONFIG_DESCRIPTOR, it, ::serializeLambdaAuthorizerConfigDocument) }
        input.logConfig?.let { field(LOGCONFIG_DESCRIPTOR, it, ::serializeLogConfigDocument) }
        input.mergedApiExecutionRoleArn?.let { field(MERGEDAPIEXECUTIONROLEARN_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.openIdConnectConfig?.let { field(OPENIDCONNECTCONFIG_DESCRIPTOR, it, ::serializeOpenIdConnectConfigDocument) }
        input.ownerContact?.let { field(OWNERCONTACT_DESCRIPTOR, it) }
        input.queryDepthLimit?.let { field(QUERYDEPTHLIMIT_DESCRIPTOR, it) }
        input.resolverCountLimit?.let { field(RESOLVERCOUNTLIMIT_DESCRIPTOR, it) }
        input.userPoolConfig?.let { field(USERPOOLCONFIG_DESCRIPTOR, it, ::serializeUserPoolConfigDocument) }
        input.xrayEnabled?.let { field(XRAYENABLED_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
