// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.serde

import aws.sdk.kotlin.services.appsync.model.AuthMode
import aws.sdk.kotlin.services.appsync.model.HandlerConfigs
import aws.sdk.kotlin.services.appsync.model.UpdateChannelNamespaceRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateChannelNamespaceOperationSerializer: HttpSerializer.NonStreaming<UpdateChannelNamespaceRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateChannelNamespaceRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.apiId) { "apiId is bound to the URI and must not be null" }
            requireNotNull(input.name) { "name is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v2"))
                add(PercentEncoding.Path.encode("apis"))
                add(PercentEncoding.SmithyLabel.encode(input.apiId))
                add(PercentEncoding.Path.encode("channelNamespaces"))
                add(PercentEncoding.SmithyLabel.encode(input.name))
            }
        }

        val payload = serializeUpdateChannelNamespaceOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateChannelNamespaceOperationBody(context: ExecutionContext, input: UpdateChannelNamespaceRequest): ByteArray {
    val serializer = JsonSerializer()
    val CODEHANDLERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("codeHandlers"))
    val HANDLERCONFIGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("handlerConfigs"))
    val PUBLISHAUTHMODES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("publishAuthModes"))
    val SUBSCRIBEAUTHMODES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("subscribeAuthModes"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CODEHANDLERS_DESCRIPTOR)
        field(HANDLERCONFIGS_DESCRIPTOR)
        field(PUBLISHAUTHMODES_DESCRIPTOR)
        field(SUBSCRIBEAUTHMODES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.codeHandlers?.let { field(CODEHANDLERS_DESCRIPTOR, it) }
        input.handlerConfigs?.let { field(HANDLERCONFIGS_DESCRIPTOR, it, ::serializeHandlerConfigsDocument) }
        if (input.publishAuthModes != null) {
            listField(PUBLISHAUTHMODES_DESCRIPTOR) {
                for (el0 in input.publishAuthModes) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAuthModeDocument))
                }
            }
        }
        if (input.subscribeAuthModes != null) {
            listField(SUBSCRIBEAUTHMODES_DESCRIPTOR) {
                for (el0 in input.subscribeAuthModes) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAuthModeDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
