// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.serde

import aws.sdk.kotlin.services.appsync.model.EventConfig
import aws.sdk.kotlin.services.appsync.model.UpdateApiRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateApiOperationSerializer: HttpSerializer.NonStreaming<UpdateApiRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateApiRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.apiId) { "apiId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v2"))
                add(PercentEncoding.Path.encode("apis"))
                add(PercentEncoding.SmithyLabel.encode(input.apiId))
            }
        }

        val payload = serializeUpdateApiOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateApiOperationBody(context: ExecutionContext, input: UpdateApiRequest): ByteArray {
    val serializer = JsonSerializer()
    val EVENTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("eventConfig"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val OWNERCONTACT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ownerContact"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EVENTCONFIG_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OWNERCONTACT_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.eventConfig?.let { field(EVENTCONFIG_DESCRIPTOR, it, ::serializeEventConfigDocument) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.ownerContact?.let { field(OWNERCONTACT_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
