// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.serde

import aws.sdk.kotlin.services.appsync.model.AppSyncException
import aws.sdk.kotlin.services.appsync.model.EvaluateCodeErrorDetail
import aws.sdk.kotlin.services.appsync.model.EvaluateCodeResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class EvaluateCodeOperationDeserializer: HttpDeserializer.NonStreaming<EvaluateCodeResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): EvaluateCodeResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwEvaluateCodeError(context, call, payload)
        }
        val builder = EvaluateCodeResponse.Builder()

        if (payload != null) {
            deserializeEvaluateCodeOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwEvaluateCodeError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AppSyncException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> AppSyncException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeEvaluateCodeOperationBody(builder: EvaluateCodeResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("error"))
    val EVALUATIONRESULT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("evaluationResult"))
    val LOGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("logs"))
    val OUTERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("outErrors"))
    val STASH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stash"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ERROR_DESCRIPTOR)
        field(EVALUATIONRESULT_DESCRIPTOR)
        field(LOGS_DESCRIPTOR)
        field(OUTERRORS_DESCRIPTOR)
        field(STASH_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ERROR_DESCRIPTOR.index -> builder.error = deserializeEvaluateCodeErrorDetailDocument(deserializer)
                EVALUATIONRESULT_DESCRIPTOR.index -> builder.evaluationResult = deserializeString()
                LOGS_DESCRIPTOR.index -> builder.logs =
                    deserializer.deserializeList(LOGS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                OUTERRORS_DESCRIPTOR.index -> builder.outErrors = deserializeString()
                STASH_DESCRIPTOR.index -> builder.stash = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
