// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.paginators

import aws.sdk.kotlin.services.appsync.AppSyncClient
import aws.sdk.kotlin.services.appsync.model.Api
import aws.sdk.kotlin.services.appsync.model.ApiKey
import aws.sdk.kotlin.services.appsync.model.ChannelNamespace
import aws.sdk.kotlin.services.appsync.model.DataSource
import aws.sdk.kotlin.services.appsync.model.DomainNameConfig
import aws.sdk.kotlin.services.appsync.model.FunctionConfiguration
import aws.sdk.kotlin.services.appsync.model.GraphqlApi
import aws.sdk.kotlin.services.appsync.model.ListApiKeysRequest
import aws.sdk.kotlin.services.appsync.model.ListApiKeysResponse
import aws.sdk.kotlin.services.appsync.model.ListApisRequest
import aws.sdk.kotlin.services.appsync.model.ListApisResponse
import aws.sdk.kotlin.services.appsync.model.ListChannelNamespacesRequest
import aws.sdk.kotlin.services.appsync.model.ListChannelNamespacesResponse
import aws.sdk.kotlin.services.appsync.model.ListDataSourcesRequest
import aws.sdk.kotlin.services.appsync.model.ListDataSourcesResponse
import aws.sdk.kotlin.services.appsync.model.ListDomainNamesRequest
import aws.sdk.kotlin.services.appsync.model.ListDomainNamesResponse
import aws.sdk.kotlin.services.appsync.model.ListFunctionsRequest
import aws.sdk.kotlin.services.appsync.model.ListFunctionsResponse
import aws.sdk.kotlin.services.appsync.model.ListGraphqlApisRequest
import aws.sdk.kotlin.services.appsync.model.ListGraphqlApisResponse
import aws.sdk.kotlin.services.appsync.model.ListResolversByFunctionRequest
import aws.sdk.kotlin.services.appsync.model.ListResolversByFunctionResponse
import aws.sdk.kotlin.services.appsync.model.ListResolversRequest
import aws.sdk.kotlin.services.appsync.model.ListResolversResponse
import aws.sdk.kotlin.services.appsync.model.ListSourceApiAssociationsRequest
import aws.sdk.kotlin.services.appsync.model.ListSourceApiAssociationsResponse
import aws.sdk.kotlin.services.appsync.model.ListTypesByAssociationRequest
import aws.sdk.kotlin.services.appsync.model.ListTypesByAssociationResponse
import aws.sdk.kotlin.services.appsync.model.ListTypesRequest
import aws.sdk.kotlin.services.appsync.model.ListTypesResponse
import aws.sdk.kotlin.services.appsync.model.Resolver
import aws.sdk.kotlin.services.appsync.model.SourceApiAssociationSummary
import aws.sdk.kotlin.services.appsync.model.Type
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListApiKeysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListApiKeysRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApiKeysResponse]
 */
public fun AppSyncClient.listApiKeysPaginated(initialRequest: ListApiKeysRequest): Flow<ListApiKeysResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listApiKeysPaginated.listApiKeys(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListApiKeysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApiKeysResponse]
 */
public fun AppSyncClient.listApiKeysPaginated(block: ListApiKeysRequest.Builder.() -> Unit): Flow<ListApiKeysResponse> =
    listApiKeysPaginated(ListApiKeysRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listApiKeysPaginated]
 * to access the nested member [ApiKey]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ApiKey]
 */
@JvmName("listApiKeysResponseApiKey")
public fun Flow<ListApiKeysResponse>.apiKeys(): Flow<ApiKey> =
    transform() { response ->
        response.apiKeys?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListApisResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListApisRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApisResponse]
 */
public fun AppSyncClient.listApisPaginated(initialRequest: ListApisRequest = ListApisRequest { }): Flow<ListApisResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listApisPaginated.listApis(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListApisResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApisResponse]
 */
public fun AppSyncClient.listApisPaginated(block: ListApisRequest.Builder.() -> Unit): Flow<ListApisResponse> =
    listApisPaginated(ListApisRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listApisPaginated]
 * to access the nested member [Api]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Api]
 */
@JvmName("listApisResponseApi")
public fun Flow<ListApisResponse>.apis(): Flow<Api> =
    transform() { response ->
        response.apis?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListChannelNamespacesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListChannelNamespacesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelNamespacesResponse]
 */
public fun AppSyncClient.listChannelNamespacesPaginated(initialRequest: ListChannelNamespacesRequest): Flow<ListChannelNamespacesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listChannelNamespacesPaginated.listChannelNamespaces(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListChannelNamespacesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelNamespacesResponse]
 */
public fun AppSyncClient.listChannelNamespacesPaginated(block: ListChannelNamespacesRequest.Builder.() -> Unit): Flow<ListChannelNamespacesResponse> =
    listChannelNamespacesPaginated(ListChannelNamespacesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listChannelNamespacesPaginated]
 * to access the nested member [ChannelNamespace]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ChannelNamespace]
 */
@JvmName("listChannelNamespacesResponseChannelNamespace")
public fun Flow<ListChannelNamespacesResponse>.channelNamespaces(): Flow<ChannelNamespace> =
    transform() { response ->
        response.channelNamespaces?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDataSourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDataSourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataSourcesResponse]
 */
public fun AppSyncClient.listDataSourcesPaginated(initialRequest: ListDataSourcesRequest): Flow<ListDataSourcesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDataSourcesPaginated.listDataSources(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDataSourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataSourcesResponse]
 */
public fun AppSyncClient.listDataSourcesPaginated(block: ListDataSourcesRequest.Builder.() -> Unit): Flow<ListDataSourcesResponse> =
    listDataSourcesPaginated(ListDataSourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDataSourcesPaginated]
 * to access the nested member [DataSource]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DataSource]
 */
@JvmName("listDataSourcesResponseDataSource")
public fun Flow<ListDataSourcesResponse>.dataSources(): Flow<DataSource> =
    transform() { response ->
        response.dataSources?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDomainNamesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDomainNamesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainNamesResponse]
 */
public fun AppSyncClient.listDomainNamesPaginated(initialRequest: ListDomainNamesRequest = ListDomainNamesRequest { }): Flow<ListDomainNamesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDomainNamesPaginated.listDomainNames(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDomainNamesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainNamesResponse]
 */
public fun AppSyncClient.listDomainNamesPaginated(block: ListDomainNamesRequest.Builder.() -> Unit): Flow<ListDomainNamesResponse> =
    listDomainNamesPaginated(ListDomainNamesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDomainNamesPaginated]
 * to access the nested member [DomainNameConfig]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DomainNameConfig]
 */
@JvmName("listDomainNamesResponseDomainNameConfig")
public fun Flow<ListDomainNamesResponse>.domainNameConfigs(): Flow<DomainNameConfig> =
    transform() { response ->
        response.domainNameConfigs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFunctionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFunctionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFunctionsResponse]
 */
public fun AppSyncClient.listFunctionsPaginated(initialRequest: ListFunctionsRequest): Flow<ListFunctionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFunctionsPaginated.listFunctions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListFunctionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFunctionsResponse]
 */
public fun AppSyncClient.listFunctionsPaginated(block: ListFunctionsRequest.Builder.() -> Unit): Flow<ListFunctionsResponse> =
    listFunctionsPaginated(ListFunctionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFunctionsPaginated]
 * to access the nested member [FunctionConfiguration]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FunctionConfiguration]
 */
@JvmName("listFunctionsResponseFunctionConfiguration")
public fun Flow<ListFunctionsResponse>.functions(): Flow<FunctionConfiguration> =
    transform() { response ->
        response.functions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListGraphqlApisResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGraphqlApisRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGraphqlApisResponse]
 */
public fun AppSyncClient.listGraphqlApisPaginated(initialRequest: ListGraphqlApisRequest = ListGraphqlApisRequest { }): Flow<ListGraphqlApisResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGraphqlApisPaginated.listGraphqlApis(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListGraphqlApisResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGraphqlApisResponse]
 */
public fun AppSyncClient.listGraphqlApisPaginated(block: ListGraphqlApisRequest.Builder.() -> Unit): Flow<ListGraphqlApisResponse> =
    listGraphqlApisPaginated(ListGraphqlApisRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listGraphqlApisPaginated]
 * to access the nested member [GraphqlApi]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GraphqlApi]
 */
@JvmName("listGraphqlApisResponseGraphqlApi")
public fun Flow<ListGraphqlApisResponse>.graphqlApis(): Flow<GraphqlApi> =
    transform() { response ->
        response.graphqlApis?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListResolversResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResolversRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolversResponse]
 */
public fun AppSyncClient.listResolversPaginated(initialRequest: ListResolversRequest): Flow<ListResolversResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResolversPaginated.listResolvers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListResolversResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolversResponse]
 */
public fun AppSyncClient.listResolversPaginated(block: ListResolversRequest.Builder.() -> Unit): Flow<ListResolversResponse> =
    listResolversPaginated(ListResolversRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listResolversPaginated]
 * to access the nested member [Resolver]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Resolver]
 */
@JvmName("listResolversResponseResolver")
public fun Flow<ListResolversResponse>.resolvers(): Flow<Resolver> =
    transform() { response ->
        response.resolvers?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListResolversByFunctionResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResolversByFunctionRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolversByFunctionResponse]
 */
public fun AppSyncClient.listResolversByFunctionPaginated(initialRequest: ListResolversByFunctionRequest): Flow<ListResolversByFunctionResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResolversByFunctionPaginated.listResolversByFunction(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListResolversByFunctionResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResolversByFunctionResponse]
 */
public fun AppSyncClient.listResolversByFunctionPaginated(block: ListResolversByFunctionRequest.Builder.() -> Unit): Flow<ListResolversByFunctionResponse> =
    listResolversByFunctionPaginated(ListResolversByFunctionRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listResolversByFunctionPaginated]
 * to access the nested member [Resolver]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Resolver]
 */
@JvmName("listResolversByFunctionResponseResolver")
public fun Flow<ListResolversByFunctionResponse>.resolvers(): Flow<Resolver> =
    transform() { response ->
        response.resolvers?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSourceApiAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSourceApiAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSourceApiAssociationsResponse]
 */
public fun AppSyncClient.listSourceApiAssociationsPaginated(initialRequest: ListSourceApiAssociationsRequest): Flow<ListSourceApiAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSourceApiAssociationsPaginated.listSourceApiAssociations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSourceApiAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSourceApiAssociationsResponse]
 */
public fun AppSyncClient.listSourceApiAssociationsPaginated(block: ListSourceApiAssociationsRequest.Builder.() -> Unit): Flow<ListSourceApiAssociationsResponse> =
    listSourceApiAssociationsPaginated(ListSourceApiAssociationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSourceApiAssociationsPaginated]
 * to access the nested member [SourceApiAssociationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SourceApiAssociationSummary]
 */
@JvmName("listSourceApiAssociationsResponseSourceApiAssociationSummary")
public fun Flow<ListSourceApiAssociationsResponse>.sourceApiAssociationSummaries(): Flow<SourceApiAssociationSummary> =
    transform() { response ->
        response.sourceApiAssociationSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTypesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTypesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTypesResponse]
 */
public fun AppSyncClient.listTypesPaginated(initialRequest: ListTypesRequest): Flow<ListTypesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTypesPaginated.listTypes(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTypesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTypesResponse]
 */
public fun AppSyncClient.listTypesPaginated(block: ListTypesRequest.Builder.() -> Unit): Flow<ListTypesResponse> =
    listTypesPaginated(ListTypesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTypesPaginated]
 * to access the nested member [Type]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Type]
 */
@JvmName("listTypesResponseType")
public fun Flow<ListTypesResponse>.types(): Flow<Type> =
    transform() { response ->
        response.types?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTypesByAssociationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTypesByAssociationRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTypesByAssociationResponse]
 */
public fun AppSyncClient.listTypesByAssociationPaginated(initialRequest: ListTypesByAssociationRequest): Flow<ListTypesByAssociationResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTypesByAssociationPaginated.listTypesByAssociation(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTypesByAssociationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTypesByAssociationResponse]
 */
public fun AppSyncClient.listTypesByAssociationPaginated(block: ListTypesByAssociationRequest.Builder.() -> Unit): Flow<ListTypesByAssociationResponse> =
    listTypesByAssociationPaginated(ListTypesByAssociationRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTypesByAssociationPaginated]
 * to access the nested member [Type]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Type]
 */
@JvmName("listTypesByAssociationResponseType")
public fun Flow<ListTypesByAssociationResponse>.types(): Flow<Type> =
    transform() { response ->
        response.types?.forEach {
            emit(it)
        }
    }
