// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes an Amazon Cognito user pool configuration.
 */
public class UserPoolConfig private constructor(builder: Builder) {
    /**
     * A regular expression for validating the incoming Amazon Cognito user pool app client ID. If this value isn't set, no filtering is applied.
     */
    public val appIdClientRegex: kotlin.String? = builder.appIdClientRegex
    /**
     * The Amazon Web Services Region in which the user pool was created.
     */
    public val awsRegion: kotlin.String = requireNotNull(builder.awsRegion) { "A non-null value must be provided for awsRegion" }
    /**
     * The action that you want your GraphQL API to take when a request that uses Amazon Cognito user pool authentication doesn't match the Amazon Cognito user pool configuration.
     */
    public val defaultAction: aws.sdk.kotlin.services.appsync.model.DefaultAction = requireNotNull(builder.defaultAction) { "A non-null value must be provided for defaultAction" }
    /**
     * The user pool ID.
     */
    public val userPoolId: kotlin.String = requireNotNull(builder.userPoolId) { "A non-null value must be provided for userPoolId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.UserPoolConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UserPoolConfig(")
        append("appIdClientRegex=$appIdClientRegex,")
        append("awsRegion=$awsRegion,")
        append("defaultAction=$defaultAction,")
        append("userPoolId=$userPoolId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appIdClientRegex?.hashCode() ?: 0
        result = 31 * result + (awsRegion.hashCode())
        result = 31 * result + (defaultAction.hashCode())
        result = 31 * result + (userPoolId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UserPoolConfig

        if (appIdClientRegex != other.appIdClientRegex) return false
        if (awsRegion != other.awsRegion) return false
        if (defaultAction != other.defaultAction) return false
        if (userPoolId != other.userPoolId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.UserPoolConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A regular expression for validating the incoming Amazon Cognito user pool app client ID. If this value isn't set, no filtering is applied.
         */
        public var appIdClientRegex: kotlin.String? = null
        /**
         * The Amazon Web Services Region in which the user pool was created.
         */
        public var awsRegion: kotlin.String? = null
        /**
         * The action that you want your GraphQL API to take when a request that uses Amazon Cognito user pool authentication doesn't match the Amazon Cognito user pool configuration.
         */
        public var defaultAction: aws.sdk.kotlin.services.appsync.model.DefaultAction? = null
        /**
         * The user pool ID.
         */
        public var userPoolId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.UserPoolConfig) : this() {
            this.appIdClientRegex = x.appIdClientRegex
            this.awsRegion = x.awsRegion
            this.defaultAction = x.defaultAction
            this.userPoolId = x.userPoolId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.UserPoolConfig = UserPoolConfig(this)

        internal fun correctErrors(): Builder {
            if (awsRegion == null) awsRegion = ""
            if (defaultAction == null) defaultAction = DefaultAction.SdkUnknown("no value provided")
            if (userPoolId == null) userPoolId = ""
            return this
        }
    }
}
