// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateGraphqlApiRequest private constructor(builder: Builder) {
    /**
     * A list of additional authentication providers for the `GraphqlApi` API.
     */
    public val additionalAuthenticationProviders: List<AdditionalAuthenticationProvider>? = builder.additionalAuthenticationProviders
    /**
     * The API ID.
     */
    public val apiId: kotlin.String? = builder.apiId
    /**
     * The new authentication type for the `GraphqlApi` object.
     */
    public val authenticationType: aws.sdk.kotlin.services.appsync.model.AuthenticationType? = builder.authenticationType
    /**
     * The `enhancedMetricsConfig` object.
     */
    public val enhancedMetricsConfig: aws.sdk.kotlin.services.appsync.model.EnhancedMetricsConfig? = builder.enhancedMetricsConfig
    /**
     * Sets the value of the GraphQL API to enable (`ENABLED`) or disable (`DISABLED`) introspection. If no value is provided, the introspection configuration will be set to `ENABLED` by default. This field will produce an error if the operation attempts to use the introspection feature while this field is disabled.
     *
     * For more information about introspection, see [GraphQL introspection](https://graphql.org/learn/introspection/).
     */
    public val introspectionConfig: aws.sdk.kotlin.services.appsync.model.GraphQlApiIntrospectionConfig? = builder.introspectionConfig
    /**
     * Configuration for Lambda function authorization.
     */
    public val lambdaAuthorizerConfig: aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig? = builder.lambdaAuthorizerConfig
    /**
     * The Amazon CloudWatch Logs configuration for the `GraphqlApi` object.
     */
    public val logConfig: aws.sdk.kotlin.services.appsync.model.LogConfig? = builder.logConfig
    /**
     * The Identity and Access Management service role ARN for a merged API. The AppSync service assumes this role on behalf of the Merged API to validate access to source APIs at runtime and to prompt the `AUTO_MERGE` to update the merged API endpoint with the source API changes automatically.
     */
    public val mergedApiExecutionRoleArn: kotlin.String? = builder.mergedApiExecutionRoleArn
    /**
     * The new name for the `GraphqlApi` object.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The OpenID Connect configuration for the `GraphqlApi` object.
     */
    public val openIdConnectConfig: aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig? = builder.openIdConnectConfig
    /**
     * The owner contact information for an API resource.
     *
     * This field accepts any string input with a length of 0 - 256 characters.
     */
    public val ownerContact: kotlin.String? = builder.ownerContact
    /**
     * The maximum depth a query can have in a single request. Depth refers to the amount of nested levels allowed in the body of query. The default value is `0` (or unspecified), which indicates there's no depth limit. If you set a limit, it can be between `1` and `75` nested levels. This field will produce a limit error if the operation falls out of bounds.
     *
     * Note that fields can still be set to nullable or non-nullable. If a non-nullable field produces an error, the error will be thrown upwards to the first nullable field available.
     */
    public val queryDepthLimit: kotlin.Int? = builder.queryDepthLimit
    /**
     * The maximum number of resolvers that can be invoked in a single request. The default value is `0` (or unspecified), which will set the limit to `10000`. When specified, the limit value can be between `1` and `10000`. This field will produce a limit error if the operation falls out of bounds.
     */
    public val resolverCountLimit: kotlin.Int? = builder.resolverCountLimit
    /**
     * The new Amazon Cognito user pool configuration for the `~GraphqlApi` object.
     */
    public val userPoolConfig: aws.sdk.kotlin.services.appsync.model.UserPoolConfig? = builder.userPoolConfig
    /**
     * A flag indicating whether to use X-Ray tracing for the `GraphqlApi`.
     */
    public val xrayEnabled: kotlin.Boolean? = builder.xrayEnabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.UpdateGraphqlApiRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateGraphqlApiRequest(")
        append("additionalAuthenticationProviders=$additionalAuthenticationProviders,")
        append("apiId=$apiId,")
        append("authenticationType=$authenticationType,")
        append("enhancedMetricsConfig=$enhancedMetricsConfig,")
        append("introspectionConfig=$introspectionConfig,")
        append("lambdaAuthorizerConfig=$lambdaAuthorizerConfig,")
        append("logConfig=$logConfig,")
        append("mergedApiExecutionRoleArn=$mergedApiExecutionRoleArn,")
        append("name=$name,")
        append("openIdConnectConfig=$openIdConnectConfig,")
        append("ownerContact=$ownerContact,")
        append("queryDepthLimit=$queryDepthLimit,")
        append("resolverCountLimit=$resolverCountLimit,")
        append("userPoolConfig=$userPoolConfig,")
        append("xrayEnabled=$xrayEnabled")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalAuthenticationProviders?.hashCode() ?: 0
        result = 31 * result + (apiId?.hashCode() ?: 0)
        result = 31 * result + (authenticationType?.hashCode() ?: 0)
        result = 31 * result + (enhancedMetricsConfig?.hashCode() ?: 0)
        result = 31 * result + (introspectionConfig?.hashCode() ?: 0)
        result = 31 * result + (lambdaAuthorizerConfig?.hashCode() ?: 0)
        result = 31 * result + (logConfig?.hashCode() ?: 0)
        result = 31 * result + (mergedApiExecutionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (openIdConnectConfig?.hashCode() ?: 0)
        result = 31 * result + (ownerContact?.hashCode() ?: 0)
        result = 31 * result + (queryDepthLimit ?: 0)
        result = 31 * result + (resolverCountLimit ?: 0)
        result = 31 * result + (userPoolConfig?.hashCode() ?: 0)
        result = 31 * result + (xrayEnabled?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateGraphqlApiRequest

        if (additionalAuthenticationProviders != other.additionalAuthenticationProviders) return false
        if (apiId != other.apiId) return false
        if (authenticationType != other.authenticationType) return false
        if (enhancedMetricsConfig != other.enhancedMetricsConfig) return false
        if (introspectionConfig != other.introspectionConfig) return false
        if (lambdaAuthorizerConfig != other.lambdaAuthorizerConfig) return false
        if (logConfig != other.logConfig) return false
        if (mergedApiExecutionRoleArn != other.mergedApiExecutionRoleArn) return false
        if (name != other.name) return false
        if (openIdConnectConfig != other.openIdConnectConfig) return false
        if (ownerContact != other.ownerContact) return false
        if (queryDepthLimit != other.queryDepthLimit) return false
        if (resolverCountLimit != other.resolverCountLimit) return false
        if (userPoolConfig != other.userPoolConfig) return false
        if (xrayEnabled != other.xrayEnabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.UpdateGraphqlApiRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of additional authentication providers for the `GraphqlApi` API.
         */
        public var additionalAuthenticationProviders: List<AdditionalAuthenticationProvider>? = null
        /**
         * The API ID.
         */
        public var apiId: kotlin.String? = null
        /**
         * The new authentication type for the `GraphqlApi` object.
         */
        public var authenticationType: aws.sdk.kotlin.services.appsync.model.AuthenticationType? = null
        /**
         * The `enhancedMetricsConfig` object.
         */
        public var enhancedMetricsConfig: aws.sdk.kotlin.services.appsync.model.EnhancedMetricsConfig? = null
        /**
         * Sets the value of the GraphQL API to enable (`ENABLED`) or disable (`DISABLED`) introspection. If no value is provided, the introspection configuration will be set to `ENABLED` by default. This field will produce an error if the operation attempts to use the introspection feature while this field is disabled.
         *
         * For more information about introspection, see [GraphQL introspection](https://graphql.org/learn/introspection/).
         */
        public var introspectionConfig: aws.sdk.kotlin.services.appsync.model.GraphQlApiIntrospectionConfig? = null
        /**
         * Configuration for Lambda function authorization.
         */
        public var lambdaAuthorizerConfig: aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig? = null
        /**
         * The Amazon CloudWatch Logs configuration for the `GraphqlApi` object.
         */
        public var logConfig: aws.sdk.kotlin.services.appsync.model.LogConfig? = null
        /**
         * The Identity and Access Management service role ARN for a merged API. The AppSync service assumes this role on behalf of the Merged API to validate access to source APIs at runtime and to prompt the `AUTO_MERGE` to update the merged API endpoint with the source API changes automatically.
         */
        public var mergedApiExecutionRoleArn: kotlin.String? = null
        /**
         * The new name for the `GraphqlApi` object.
         */
        public var name: kotlin.String? = null
        /**
         * The OpenID Connect configuration for the `GraphqlApi` object.
         */
        public var openIdConnectConfig: aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig? = null
        /**
         * The owner contact information for an API resource.
         *
         * This field accepts any string input with a length of 0 - 256 characters.
         */
        public var ownerContact: kotlin.String? = null
        /**
         * The maximum depth a query can have in a single request. Depth refers to the amount of nested levels allowed in the body of query. The default value is `0` (or unspecified), which indicates there's no depth limit. If you set a limit, it can be between `1` and `75` nested levels. This field will produce a limit error if the operation falls out of bounds.
         *
         * Note that fields can still be set to nullable or non-nullable. If a non-nullable field produces an error, the error will be thrown upwards to the first nullable field available.
         */
        public var queryDepthLimit: kotlin.Int? = null
        /**
         * The maximum number of resolvers that can be invoked in a single request. The default value is `0` (or unspecified), which will set the limit to `10000`. When specified, the limit value can be between `1` and `10000`. This field will produce a limit error if the operation falls out of bounds.
         */
        public var resolverCountLimit: kotlin.Int? = null
        /**
         * The new Amazon Cognito user pool configuration for the `~GraphqlApi` object.
         */
        public var userPoolConfig: aws.sdk.kotlin.services.appsync.model.UserPoolConfig? = null
        /**
         * A flag indicating whether to use X-Ray tracing for the `GraphqlApi`.
         */
        public var xrayEnabled: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.UpdateGraphqlApiRequest) : this() {
            this.additionalAuthenticationProviders = x.additionalAuthenticationProviders
            this.apiId = x.apiId
            this.authenticationType = x.authenticationType
            this.enhancedMetricsConfig = x.enhancedMetricsConfig
            this.introspectionConfig = x.introspectionConfig
            this.lambdaAuthorizerConfig = x.lambdaAuthorizerConfig
            this.logConfig = x.logConfig
            this.mergedApiExecutionRoleArn = x.mergedApiExecutionRoleArn
            this.name = x.name
            this.openIdConnectConfig = x.openIdConnectConfig
            this.ownerContact = x.ownerContact
            this.queryDepthLimit = x.queryDepthLimit
            this.resolverCountLimit = x.resolverCountLimit
            this.userPoolConfig = x.userPoolConfig
            this.xrayEnabled = x.xrayEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.UpdateGraphqlApiRequest = UpdateGraphqlApiRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.EnhancedMetricsConfig] inside the given [block]
         */
        public fun enhancedMetricsConfig(block: aws.sdk.kotlin.services.appsync.model.EnhancedMetricsConfig.Builder.() -> kotlin.Unit) {
            this.enhancedMetricsConfig = aws.sdk.kotlin.services.appsync.model.EnhancedMetricsConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig] inside the given [block]
         */
        public fun lambdaAuthorizerConfig(block: aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig.Builder.() -> kotlin.Unit) {
            this.lambdaAuthorizerConfig = aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.LogConfig] inside the given [block]
         */
        public fun logConfig(block: aws.sdk.kotlin.services.appsync.model.LogConfig.Builder.() -> kotlin.Unit) {
            this.logConfig = aws.sdk.kotlin.services.appsync.model.LogConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig] inside the given [block]
         */
        public fun openIdConnectConfig(block: aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig.Builder.() -> kotlin.Unit) {
            this.openIdConnectConfig = aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.UserPoolConfig] inside the given [block]
         */
        public fun userPoolConfig(block: aws.sdk.kotlin.services.appsync.model.UserPoolConfig.Builder.() -> kotlin.Unit) {
            this.userPoolConfig = aws.sdk.kotlin.services.appsync.model.UserPoolConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
