// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains the metadata required to introspect the RDS cluster.
 */
public class RdsDataApiConfig private constructor(builder: Builder) {
    /**
     * The name of the database in the cluster.
     */
    public val databaseName: kotlin.String = requireNotNull(builder.databaseName) { "A non-null value must be provided for databaseName" }
    /**
     * The resource ARN of the RDS cluster.
     */
    public val resourceArn: kotlin.String = requireNotNull(builder.resourceArn) { "A non-null value must be provided for resourceArn" }
    /**
     * The secret's ARN that was obtained from Secrets Manager. A secret consists of secret information, the secret value, plus metadata about the secret. A secret value can be a string or binary. It typically includes the ARN, secret name and description, policies, tags, encryption key from the Key Management Service, and key rotation data.
     */
    public val secretArn: kotlin.String = requireNotNull(builder.secretArn) { "A non-null value must be provided for secretArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.RdsDataApiConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RdsDataApiConfig(")
        append("databaseName=$databaseName,")
        append("resourceArn=$resourceArn,")
        append("secretArn=$secretArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = databaseName.hashCode()
        result = 31 * result + (resourceArn.hashCode())
        result = 31 * result + (secretArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RdsDataApiConfig

        if (databaseName != other.databaseName) return false
        if (resourceArn != other.resourceArn) return false
        if (secretArn != other.secretArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.RdsDataApiConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the database in the cluster.
         */
        public var databaseName: kotlin.String? = null
        /**
         * The resource ARN of the RDS cluster.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The secret's ARN that was obtained from Secrets Manager. A secret consists of secret information, the secret value, plus metadata about the secret. A secret value can be a string or binary. It typically includes the ARN, secret name and description, policies, tags, encryption key from the Key Management Service, and key rotation data.
         */
        public var secretArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.RdsDataApiConfig) : this() {
            this.databaseName = x.databaseName
            this.resourceArn = x.resourceArn
            this.secretArn = x.secretArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.RdsDataApiConfig = RdsDataApiConfig(this)

        internal fun correctErrors(): Builder {
            if (databaseName == null) databaseName = ""
            if (resourceArn == null) resourceArn = ""
            if (secretArn == null) secretArn = ""
            return this
        }
    }
}
