// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A `LambdaAuthorizerConfig` specifies how to authorize AppSync API access when using the `AWS_LAMBDA` authorizer mode. Be aware that an AppSync API can have only one Lambda authorizer configured at a time.
 */
public class LambdaAuthorizerConfig private constructor(builder: Builder) {
    /**
     * The number of seconds a response should be cached for. The default is 0 seconds, which disables caching. If you don't specify a value for `authorizerResultTtlInSeconds`, the default value is used. The maximum value is one hour (3600 seconds). The Lambda function can override this by returning a `ttlOverride` key in its response.
     */
    public val authorizerResultTtlInSeconds: kotlin.Int = builder.authorizerResultTtlInSeconds
    /**
     * The Amazon Resource Name (ARN) of the Lambda function to be called for authorization. This can be a standard Lambda ARN, a version ARN (`.../v3`), or an alias ARN.
     *
     * **Note**: This Lambda function must have the following resource-based policy assigned to it. When configuring Lambda authorizers in the console, this is done for you. To use the Command Line Interface (CLI), run the following:
     *
     * `aws lambda add-permission --function-name "arn:aws:lambda:us-east-2:111122223333:function:my-function" --statement-id "appsync" --principal appsync.amazonaws.com --action lambda:InvokeFunction`
     */
    public val authorizerUri: kotlin.String = requireNotNull(builder.authorizerUri) { "A non-null value must be provided for authorizerUri" }
    /**
     * A regular expression for validation of tokens before the Lambda function is called.
     */
    public val identityValidationExpression: kotlin.String? = builder.identityValidationExpression

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaAuthorizerConfig(")
        append("authorizerResultTtlInSeconds=$authorizerResultTtlInSeconds,")
        append("authorizerUri=$authorizerUri,")
        append("identityValidationExpression=$identityValidationExpression")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authorizerResultTtlInSeconds
        result = 31 * result + (authorizerUri.hashCode())
        result = 31 * result + (identityValidationExpression?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LambdaAuthorizerConfig

        if (authorizerResultTtlInSeconds != other.authorizerResultTtlInSeconds) return false
        if (authorizerUri != other.authorizerUri) return false
        if (identityValidationExpression != other.identityValidationExpression) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of seconds a response should be cached for. The default is 0 seconds, which disables caching. If you don't specify a value for `authorizerResultTtlInSeconds`, the default value is used. The maximum value is one hour (3600 seconds). The Lambda function can override this by returning a `ttlOverride` key in its response.
         */
        public var authorizerResultTtlInSeconds: kotlin.Int = 0
        /**
         * The Amazon Resource Name (ARN) of the Lambda function to be called for authorization. This can be a standard Lambda ARN, a version ARN (`.../v3`), or an alias ARN.
         *
         * **Note**: This Lambda function must have the following resource-based policy assigned to it. When configuring Lambda authorizers in the console, this is done for you. To use the Command Line Interface (CLI), run the following:
         *
         * `aws lambda add-permission --function-name "arn:aws:lambda:us-east-2:111122223333:function:my-function" --statement-id "appsync" --principal appsync.amazonaws.com --action lambda:InvokeFunction`
         */
        public var authorizerUri: kotlin.String? = null
        /**
         * A regular expression for validation of tokens before the Lambda function is called.
         */
        public var identityValidationExpression: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig) : this() {
            this.authorizerResultTtlInSeconds = x.authorizerResultTtlInSeconds
            this.authorizerUri = x.authorizerUri
            this.identityValidationExpression = x.identityValidationExpression
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig = LambdaAuthorizerConfig(this)

        internal fun correctErrors(): Builder {
            if (authorizerUri == null) authorizerUri = ""
            return this
        }
    }
}
