// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes a data source.
 */
public class DataSource private constructor(builder: Builder) {
    /**
     * The data source Amazon Resource Name (ARN).
     */
    public val dataSourceArn: kotlin.String? = builder.dataSourceArn
    /**
     * The description of the data source.
     */
    public val description: kotlin.String? = builder.description
    /**
     * DynamoDB settings.
     */
    public val dynamodbConfig: aws.sdk.kotlin.services.appsync.model.DynamodbDataSourceConfig? = builder.dynamodbConfig
    /**
     * Amazon OpenSearch Service settings.
     */
    public val elasticsearchConfig: aws.sdk.kotlin.services.appsync.model.ElasticsearchDataSourceConfig? = builder.elasticsearchConfig
    /**
     * Amazon EventBridge settings.
     */
    public val eventBridgeConfig: aws.sdk.kotlin.services.appsync.model.EventBridgeDataSourceConfig? = builder.eventBridgeConfig
    /**
     * HTTP endpoint settings.
     */
    public val httpConfig: aws.sdk.kotlin.services.appsync.model.HttpDataSourceConfig? = builder.httpConfig
    /**
     * Lambda settings.
     */
    public val lambdaConfig: aws.sdk.kotlin.services.appsync.model.LambdaDataSourceConfig? = builder.lambdaConfig
    /**
     * Enables or disables enhanced data source metrics for specified data sources. Note that `metricsConfig` won't be used unless the `dataSourceLevelMetricsBehavior` value is set to `PER_DATA_SOURCE_METRICS`. If the `dataSourceLevelMetricsBehavior` is set to `FULL_REQUEST_DATA_SOURCE_METRICS` instead, `metricsConfig` will be ignored. However, you can still set its value.
     *
     * `metricsConfig` can be `ENABLED` or `DISABLED`.
     */
    public val metricsConfig: aws.sdk.kotlin.services.appsync.model.DataSourceLevelMetricsConfig? = builder.metricsConfig
    /**
     * The name of the data source.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Amazon OpenSearch Service settings.
     */
    public val openSearchServiceConfig: aws.sdk.kotlin.services.appsync.model.OpenSearchServiceDataSourceConfig? = builder.openSearchServiceConfig
    /**
     * Relational database settings.
     */
    public val relationalDatabaseConfig: aws.sdk.kotlin.services.appsync.model.RelationalDatabaseDataSourceConfig? = builder.relationalDatabaseConfig
    /**
     * The Identity and Access Management (IAM) service role Amazon Resource Name (ARN) for the data source. The system assumes this role when accessing the data source.
     */
    public val serviceRoleArn: kotlin.String? = builder.serviceRoleArn
    /**
     * The type of the data source.
     * + **AWS_LAMBDA**: The data source is an Lambda function.
     * + **AMAZON_DYNAMODB**: The data source is an Amazon DynamoDB table.
     * + **AMAZON_ELASTICSEARCH**: The data source is an Amazon OpenSearch Service domain.
     * + **AMAZON_OPENSEARCH_SERVICE**: The data source is an Amazon OpenSearch Service domain.
     * + **AMAZON_EVENTBRIDGE**: The data source is an Amazon EventBridge configuration.
     * + **AMAZON_BEDROCK_RUNTIME**: The data source is the Amazon Bedrock runtime.
     * + **NONE**: There is no data source. Use this type when you want to invoke a GraphQL operation without connecting to a data source, such as when you're performing data transformation with resolvers or invoking a subscription from a mutation.
     * + **HTTP**: The data source is an HTTP endpoint.
     * + **RELATIONAL_DATABASE**: The data source is a relational database.
     */
    public val type: aws.sdk.kotlin.services.appsync.model.DataSourceType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.DataSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataSource(")
        append("dataSourceArn=$dataSourceArn,")
        append("description=$description,")
        append("dynamodbConfig=$dynamodbConfig,")
        append("elasticsearchConfig=$elasticsearchConfig,")
        append("eventBridgeConfig=$eventBridgeConfig,")
        append("httpConfig=$httpConfig,")
        append("lambdaConfig=$lambdaConfig,")
        append("metricsConfig=$metricsConfig,")
        append("name=$name,")
        append("openSearchServiceConfig=$openSearchServiceConfig,")
        append("relationalDatabaseConfig=$relationalDatabaseConfig,")
        append("serviceRoleArn=$serviceRoleArn,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSourceArn?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dynamodbConfig?.hashCode() ?: 0)
        result = 31 * result + (elasticsearchConfig?.hashCode() ?: 0)
        result = 31 * result + (eventBridgeConfig?.hashCode() ?: 0)
        result = 31 * result + (httpConfig?.hashCode() ?: 0)
        result = 31 * result + (lambdaConfig?.hashCode() ?: 0)
        result = 31 * result + (metricsConfig?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (openSearchServiceConfig?.hashCode() ?: 0)
        result = 31 * result + (relationalDatabaseConfig?.hashCode() ?: 0)
        result = 31 * result + (serviceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataSource

        if (dataSourceArn != other.dataSourceArn) return false
        if (description != other.description) return false
        if (dynamodbConfig != other.dynamodbConfig) return false
        if (elasticsearchConfig != other.elasticsearchConfig) return false
        if (eventBridgeConfig != other.eventBridgeConfig) return false
        if (httpConfig != other.httpConfig) return false
        if (lambdaConfig != other.lambdaConfig) return false
        if (metricsConfig != other.metricsConfig) return false
        if (name != other.name) return false
        if (openSearchServiceConfig != other.openSearchServiceConfig) return false
        if (relationalDatabaseConfig != other.relationalDatabaseConfig) return false
        if (serviceRoleArn != other.serviceRoleArn) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.DataSource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The data source Amazon Resource Name (ARN).
         */
        public var dataSourceArn: kotlin.String? = null
        /**
         * The description of the data source.
         */
        public var description: kotlin.String? = null
        /**
         * DynamoDB settings.
         */
        public var dynamodbConfig: aws.sdk.kotlin.services.appsync.model.DynamodbDataSourceConfig? = null
        /**
         * Amazon OpenSearch Service settings.
         */
        public var elasticsearchConfig: aws.sdk.kotlin.services.appsync.model.ElasticsearchDataSourceConfig? = null
        /**
         * Amazon EventBridge settings.
         */
        public var eventBridgeConfig: aws.sdk.kotlin.services.appsync.model.EventBridgeDataSourceConfig? = null
        /**
         * HTTP endpoint settings.
         */
        public var httpConfig: aws.sdk.kotlin.services.appsync.model.HttpDataSourceConfig? = null
        /**
         * Lambda settings.
         */
        public var lambdaConfig: aws.sdk.kotlin.services.appsync.model.LambdaDataSourceConfig? = null
        /**
         * Enables or disables enhanced data source metrics for specified data sources. Note that `metricsConfig` won't be used unless the `dataSourceLevelMetricsBehavior` value is set to `PER_DATA_SOURCE_METRICS`. If the `dataSourceLevelMetricsBehavior` is set to `FULL_REQUEST_DATA_SOURCE_METRICS` instead, `metricsConfig` will be ignored. However, you can still set its value.
         *
         * `metricsConfig` can be `ENABLED` or `DISABLED`.
         */
        public var metricsConfig: aws.sdk.kotlin.services.appsync.model.DataSourceLevelMetricsConfig? = null
        /**
         * The name of the data source.
         */
        public var name: kotlin.String? = null
        /**
         * Amazon OpenSearch Service settings.
         */
        public var openSearchServiceConfig: aws.sdk.kotlin.services.appsync.model.OpenSearchServiceDataSourceConfig? = null
        /**
         * Relational database settings.
         */
        public var relationalDatabaseConfig: aws.sdk.kotlin.services.appsync.model.RelationalDatabaseDataSourceConfig? = null
        /**
         * The Identity and Access Management (IAM) service role Amazon Resource Name (ARN) for the data source. The system assumes this role when accessing the data source.
         */
        public var serviceRoleArn: kotlin.String? = null
        /**
         * The type of the data source.
         * + **AWS_LAMBDA**: The data source is an Lambda function.
         * + **AMAZON_DYNAMODB**: The data source is an Amazon DynamoDB table.
         * + **AMAZON_ELASTICSEARCH**: The data source is an Amazon OpenSearch Service domain.
         * + **AMAZON_OPENSEARCH_SERVICE**: The data source is an Amazon OpenSearch Service domain.
         * + **AMAZON_EVENTBRIDGE**: The data source is an Amazon EventBridge configuration.
         * + **AMAZON_BEDROCK_RUNTIME**: The data source is the Amazon Bedrock runtime.
         * + **NONE**: There is no data source. Use this type when you want to invoke a GraphQL operation without connecting to a data source, such as when you're performing data transformation with resolvers or invoking a subscription from a mutation.
         * + **HTTP**: The data source is an HTTP endpoint.
         * + **RELATIONAL_DATABASE**: The data source is a relational database.
         */
        public var type: aws.sdk.kotlin.services.appsync.model.DataSourceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.DataSource) : this() {
            this.dataSourceArn = x.dataSourceArn
            this.description = x.description
            this.dynamodbConfig = x.dynamodbConfig
            this.elasticsearchConfig = x.elasticsearchConfig
            this.eventBridgeConfig = x.eventBridgeConfig
            this.httpConfig = x.httpConfig
            this.lambdaConfig = x.lambdaConfig
            this.metricsConfig = x.metricsConfig
            this.name = x.name
            this.openSearchServiceConfig = x.openSearchServiceConfig
            this.relationalDatabaseConfig = x.relationalDatabaseConfig
            this.serviceRoleArn = x.serviceRoleArn
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.DataSource = DataSource(this)

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.DynamodbDataSourceConfig] inside the given [block]
         */
        public fun dynamodbConfig(block: aws.sdk.kotlin.services.appsync.model.DynamodbDataSourceConfig.Builder.() -> kotlin.Unit) {
            this.dynamodbConfig = aws.sdk.kotlin.services.appsync.model.DynamodbDataSourceConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.ElasticsearchDataSourceConfig] inside the given [block]
         */
        public fun elasticsearchConfig(block: aws.sdk.kotlin.services.appsync.model.ElasticsearchDataSourceConfig.Builder.() -> kotlin.Unit) {
            this.elasticsearchConfig = aws.sdk.kotlin.services.appsync.model.ElasticsearchDataSourceConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.EventBridgeDataSourceConfig] inside the given [block]
         */
        public fun eventBridgeConfig(block: aws.sdk.kotlin.services.appsync.model.EventBridgeDataSourceConfig.Builder.() -> kotlin.Unit) {
            this.eventBridgeConfig = aws.sdk.kotlin.services.appsync.model.EventBridgeDataSourceConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.HttpDataSourceConfig] inside the given [block]
         */
        public fun httpConfig(block: aws.sdk.kotlin.services.appsync.model.HttpDataSourceConfig.Builder.() -> kotlin.Unit) {
            this.httpConfig = aws.sdk.kotlin.services.appsync.model.HttpDataSourceConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.LambdaDataSourceConfig] inside the given [block]
         */
        public fun lambdaConfig(block: aws.sdk.kotlin.services.appsync.model.LambdaDataSourceConfig.Builder.() -> kotlin.Unit) {
            this.lambdaConfig = aws.sdk.kotlin.services.appsync.model.LambdaDataSourceConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.OpenSearchServiceDataSourceConfig] inside the given [block]
         */
        public fun openSearchServiceConfig(block: aws.sdk.kotlin.services.appsync.model.OpenSearchServiceDataSourceConfig.Builder.() -> kotlin.Unit) {
            this.openSearchServiceConfig = aws.sdk.kotlin.services.appsync.model.OpenSearchServiceDataSourceConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.RelationalDatabaseDataSourceConfig] inside the given [block]
         */
        public fun relationalDatabaseConfig(block: aws.sdk.kotlin.services.appsync.model.RelationalDatabaseDataSourceConfig.Builder.() -> kotlin.Unit) {
            this.relationalDatabaseConfig = aws.sdk.kotlin.services.appsync.model.RelationalDatabaseDataSourceConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
