// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a channel namespace associated with an `Api`. The `ChannelNamespace` contains the definitions for code handlers for the `Api`.
 */
public class ChannelNamespace private constructor(builder: Builder) {
    /**
     * The `Api` ID.
     */
    public val apiId: kotlin.String? = builder.apiId
    /**
     * The Amazon Resource Name (ARN) for the `ChannelNamespace`.
     */
    public val channelNamespaceArn: kotlin.String? = builder.channelNamespaceArn
    /**
     * The event handler functions that run custom business logic to process published events and subscribe requests.
     */
    public val codeHandlers: kotlin.String? = builder.codeHandlers
    /**
     * The date and time that the `ChannelNamespace` was created.
     */
    public val created: aws.smithy.kotlin.runtime.time.Instant? = builder.created
    /**
     * The configuration for the `OnPublish` and `OnSubscribe` handlers.
     */
    public val handlerConfigs: aws.sdk.kotlin.services.appsync.model.HandlerConfigs? = builder.handlerConfigs
    /**
     * The date and time that the `ChannelNamespace` was last changed.
     */
    public val lastModified: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModified
    /**
     * The name of the channel namespace. This name must be unique within the `Api`.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The authorization mode to use for publishing messages on the channel namespace. This configuration overrides the default `Api`authorization configuration.
     */
    public val publishAuthModes: List<AuthMode>? = builder.publishAuthModes
    /**
     * The authorization mode to use for subscribing to messages on the channel namespace. This configuration overrides the default `Api`authorization configuration.
     */
    public val subscribeAuthModes: List<AuthMode>? = builder.subscribeAuthModes
    /**
     * A map with keys of `TagKey` objects and values of `TagValue` objects.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.ChannelNamespace = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ChannelNamespace(")
        append("apiId=$apiId,")
        append("channelNamespaceArn=$channelNamespaceArn,")
        append("codeHandlers=$codeHandlers,")
        append("created=$created,")
        append("handlerConfigs=$handlerConfigs,")
        append("lastModified=$lastModified,")
        append("name=$name,")
        append("publishAuthModes=$publishAuthModes,")
        append("subscribeAuthModes=$subscribeAuthModes,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiId?.hashCode() ?: 0
        result = 31 * result + (channelNamespaceArn?.hashCode() ?: 0)
        result = 31 * result + (codeHandlers?.hashCode() ?: 0)
        result = 31 * result + (created?.hashCode() ?: 0)
        result = 31 * result + (handlerConfigs?.hashCode() ?: 0)
        result = 31 * result + (lastModified?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (publishAuthModes?.hashCode() ?: 0)
        result = 31 * result + (subscribeAuthModes?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ChannelNamespace

        if (apiId != other.apiId) return false
        if (channelNamespaceArn != other.channelNamespaceArn) return false
        if (codeHandlers != other.codeHandlers) return false
        if (created != other.created) return false
        if (handlerConfigs != other.handlerConfigs) return false
        if (lastModified != other.lastModified) return false
        if (name != other.name) return false
        if (publishAuthModes != other.publishAuthModes) return false
        if (subscribeAuthModes != other.subscribeAuthModes) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.ChannelNamespace = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The `Api` ID.
         */
        public var apiId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the `ChannelNamespace`.
         */
        public var channelNamespaceArn: kotlin.String? = null
        /**
         * The event handler functions that run custom business logic to process published events and subscribe requests.
         */
        public var codeHandlers: kotlin.String? = null
        /**
         * The date and time that the `ChannelNamespace` was created.
         */
        public var created: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The configuration for the `OnPublish` and `OnSubscribe` handlers.
         */
        public var handlerConfigs: aws.sdk.kotlin.services.appsync.model.HandlerConfigs? = null
        /**
         * The date and time that the `ChannelNamespace` was last changed.
         */
        public var lastModified: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the channel namespace. This name must be unique within the `Api`.
         */
        public var name: kotlin.String? = null
        /**
         * The authorization mode to use for publishing messages on the channel namespace. This configuration overrides the default `Api`authorization configuration.
         */
        public var publishAuthModes: List<AuthMode>? = null
        /**
         * The authorization mode to use for subscribing to messages on the channel namespace. This configuration overrides the default `Api`authorization configuration.
         */
        public var subscribeAuthModes: List<AuthMode>? = null
        /**
         * A map with keys of `TagKey` objects and values of `TagValue` objects.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.ChannelNamespace) : this() {
            this.apiId = x.apiId
            this.channelNamespaceArn = x.channelNamespaceArn
            this.codeHandlers = x.codeHandlers
            this.created = x.created
            this.handlerConfigs = x.handlerConfigs
            this.lastModified = x.lastModified
            this.name = x.name
            this.publishAuthModes = x.publishAuthModes
            this.subscribeAuthModes = x.subscribeAuthModes
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.ChannelNamespace = ChannelNamespace(this)

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.HandlerConfigs] inside the given [block]
         */
        public fun handlerConfigs(block: aws.sdk.kotlin.services.appsync.model.HandlerConfigs.Builder.() -> kotlin.Unit) {
            this.handlerConfigs = aws.sdk.kotlin.services.appsync.model.HandlerConfigs.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
