// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.serde

import aws.sdk.kotlin.services.appsync.model.AppSyncRuntime
import aws.sdk.kotlin.services.appsync.model.CreateFunctionRequest
import aws.sdk.kotlin.services.appsync.model.SyncConfig
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateFunctionOperationSerializer: HttpSerializer.NonStreaming<CreateFunctionRequest> {
    override fun serialize(context: ExecutionContext, input: CreateFunctionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.apiId) { "apiId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v1"))
                add(PercentEncoding.Path.encode("apis"))
                add(PercentEncoding.SmithyLabel.encode(input.apiId))
                add(PercentEncoding.Path.encode("functions"))
            }
        }

        val payload = serializeCreateFunctionOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateFunctionOperationBody(context: ExecutionContext, input: CreateFunctionRequest): ByteArray {
    val serializer = JsonSerializer()
    val CODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("code"))
    val DATASOURCENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dataSourceName"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val FUNCTIONVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("functionVersion"))
    val MAXBATCHSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("maxBatchSize"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val REQUESTMAPPINGTEMPLATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("requestMappingTemplate"))
    val RESPONSEMAPPINGTEMPLATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("responseMappingTemplate"))
    val RUNTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("runtime"))
    val SYNCCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("syncConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CODE_DESCRIPTOR)
        field(DATASOURCENAME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(FUNCTIONVERSION_DESCRIPTOR)
        field(MAXBATCHSIZE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(REQUESTMAPPINGTEMPLATE_DESCRIPTOR)
        field(RESPONSEMAPPINGTEMPLATE_DESCRIPTOR)
        field(RUNTIME_DESCRIPTOR)
        field(SYNCCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.code?.let { field(CODE_DESCRIPTOR, it) }
        input.dataSourceName?.let { field(DATASOURCENAME_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.functionVersion?.let { field(FUNCTIONVERSION_DESCRIPTOR, it) }
        input.maxBatchSize?.let { field(MAXBATCHSIZE_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.requestMappingTemplate?.let { field(REQUESTMAPPINGTEMPLATE_DESCRIPTOR, it) }
        input.responseMappingTemplate?.let { field(RESPONSEMAPPINGTEMPLATE_DESCRIPTOR, it) }
        input.runtime?.let { field(RUNTIME_DESCRIPTOR, it, ::serializeAppSyncRuntimeDocument) }
        input.syncConfig?.let { field(SYNCCONFIG_DESCRIPTOR, it, ::serializeSyncConfigDocument) }
    }
    return serializer.toByteArray()
}
