// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.waiters

import aws.sdk.kotlin.services.appstream.AppStreamClient
import aws.sdk.kotlin.services.appstream.model.DescribeFleetsRequest
import aws.sdk.kotlin.services.appstream.model.DescribeFleetsResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.util.flattenIfPossible
import kotlin.time.Duration.Companion.milliseconds


public suspend fun AppStreamClient.waitUntilFleetStarted(request: DescribeFleetsRequest = DescribeFleetsRequest { }): Outcome<DescribeFleetsResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeFleetsRequest, DescribeFleetsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val fleets = it.fleets
            val fleetsOrEmpty = fleets?.flattenIfPossible()
            val projection = fleetsOrEmpty?.flatMap {
                val state = it?.state?.value
                listOfNotNull(state)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "RUNNING" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val fleets = it.fleets
            val fleetsOrEmpty = fleets?.flattenIfPossible()
            val projection = fleetsOrEmpty?.flatMap {
                val state = it?.state?.value
                listOfNotNull(state)
            }
            (projection as List<String?>?)?.any { it == "STOPPING" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val fleets = it.fleets
            val fleetsOrEmpty = fleets?.flattenIfPossible()
            val projection = fleetsOrEmpty?.flatMap {
                val state = it?.state?.value
                listOfNotNull(state)
            }
            (projection as List<String?>?)?.any { it == "STOPPED" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeFleets(request) }
}

public suspend fun AppStreamClient.waitUntilFleetStarted(block: DescribeFleetsRequest.Builder.() -> Unit): Outcome<DescribeFleetsResponse> =
    waitUntilFleetStarted(DescribeFleetsRequest.Builder().apply(block).build())

public suspend fun AppStreamClient.waitUntilFleetStopped(request: DescribeFleetsRequest = DescribeFleetsRequest { }): Outcome<DescribeFleetsResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeFleetsRequest, DescribeFleetsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val fleets = it.fleets
            val fleetsOrEmpty = fleets?.flattenIfPossible()
            val projection = fleetsOrEmpty?.flatMap {
                val state = it?.state?.value
                listOfNotNull(state)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "STOPPED" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val fleets = it.fleets
            val fleetsOrEmpty = fleets?.flattenIfPossible()
            val projection = fleetsOrEmpty?.flatMap {
                val state = it?.state?.value
                listOfNotNull(state)
            }
            (projection as List<String?>?)?.any { it == "STARTING" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val fleets = it.fleets
            val fleetsOrEmpty = fleets?.flattenIfPossible()
            val projection = fleetsOrEmpty?.flatMap {
                val state = it?.state?.value
                listOfNotNull(state)
            }
            (projection as List<String?>?)?.any { it == "RUNNING" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeFleets(request) }
}

public suspend fun AppStreamClient.waitUntilFleetStopped(block: DescribeFleetsRequest.Builder.() -> Unit): Outcome<DescribeFleetsResponse> =
    waitUntilFleetStopped(DescribeFleetsRequest.Builder().apply(block).build())
