// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.serde

import aws.sdk.kotlin.services.appstream.model.AppStreamException
import aws.sdk.kotlin.services.appstream.model.CreateUsageReportSubscriptionResponse
import aws.sdk.kotlin.services.appstream.model.UsageReportSchedule
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateUsageReportSubscriptionOperationDeserializer: HttpDeserializer.NonStreaming<CreateUsageReportSubscriptionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateUsageReportSubscriptionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateUsageReportSubscriptionError(context, call, payload)
        }
        val builder = CreateUsageReportSubscriptionResponse.Builder()

        if (payload != null) {
            deserializeCreateUsageReportSubscriptionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateUsageReportSubscriptionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AppStreamException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRoleException" -> InvalidRoleExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidAccountStatusException" -> InvalidAccountStatusExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> AppStreamException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateUsageReportSubscriptionOperationBody(builder: CreateUsageReportSubscriptionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val S3BUCKETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("S3BucketName"))
    val SCHEDULE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Schedule"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(S3BUCKETNAME_DESCRIPTOR)
        field(SCHEDULE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                S3BUCKETNAME_DESCRIPTOR.index -> builder.s3BucketName = deserializeString()
                SCHEDULE_DESCRIPTOR.index -> builder.schedule = deserializeString().let { UsageReportSchedule.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
