// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateUserRequest private constructor(builder: Builder) {
    /**
     * The authentication type for the user. You must specify USERPOOL.
     */
    public val authenticationType: aws.sdk.kotlin.services.appstream.model.AuthenticationType? = builder.authenticationType
    /**
     * The first name, or given name, of the user.
     */
    public val firstName: kotlin.String? = builder.firstName
    /**
     * The last name, or surname, of the user.
     */
    public val lastName: kotlin.String? = builder.lastName
    /**
     * The action to take for the welcome email that is sent to a user after the user is created in the user pool. If you specify SUPPRESS, no email is sent. If you specify RESEND, do not specify the first name or last name of the user. If the value is null, the email is sent.
     *
     * The temporary password in the welcome email is valid for only 7 days. If users don’t set their passwords within 7 days, you must send them a new welcome email.
     */
    public val messageAction: aws.sdk.kotlin.services.appstream.model.MessageAction? = builder.messageAction
    /**
     * The email address of the user.
     *
     * Users' email addresses are case-sensitive. During login, if they specify an email address that doesn't use the same capitalization as the email address specified when their user pool account was created, a "user does not exist" error message displays.
     */
    public val userName: kotlin.String? = builder.userName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appstream.model.CreateUserRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateUserRequest(")
        append("authenticationType=$authenticationType,")
        append("firstName=*** Sensitive Data Redacted ***,")
        append("lastName=*** Sensitive Data Redacted ***,")
        append("messageAction=$messageAction,")
        append("userName=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationType?.hashCode() ?: 0
        result = 31 * result + (firstName?.hashCode() ?: 0)
        result = 31 * result + (lastName?.hashCode() ?: 0)
        result = 31 * result + (messageAction?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateUserRequest

        if (authenticationType != other.authenticationType) return false
        if (firstName != other.firstName) return false
        if (lastName != other.lastName) return false
        if (messageAction != other.messageAction) return false
        if (userName != other.userName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appstream.model.CreateUserRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The authentication type for the user. You must specify USERPOOL.
         */
        public var authenticationType: aws.sdk.kotlin.services.appstream.model.AuthenticationType? = null
        /**
         * The first name, or given name, of the user.
         */
        public var firstName: kotlin.String? = null
        /**
         * The last name, or surname, of the user.
         */
        public var lastName: kotlin.String? = null
        /**
         * The action to take for the welcome email that is sent to a user after the user is created in the user pool. If you specify SUPPRESS, no email is sent. If you specify RESEND, do not specify the first name or last name of the user. If the value is null, the email is sent.
         *
         * The temporary password in the welcome email is valid for only 7 days. If users don’t set their passwords within 7 days, you must send them a new welcome email.
         */
        public var messageAction: aws.sdk.kotlin.services.appstream.model.MessageAction? = null
        /**
         * The email address of the user.
         *
         * Users' email addresses are case-sensitive. During login, if they specify an email address that doesn't use the same capitalization as the email address specified when their user pool account was created, a "user does not exist" error message displays.
         */
        public var userName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appstream.model.CreateUserRequest) : this() {
            this.authenticationType = x.authenticationType
            this.firstName = x.firstName
            this.lastName = x.lastName
            this.messageAction = x.messageAction
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appstream.model.CreateUserRequest = CreateUserRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
