// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the capacity status for a fleet.
 */
public class ComputeCapacityStatus private constructor(builder: Builder) {
    /**
     * The number of user sessions currently being used for streaming sessions. This only applies to multi-session fleets.
     */
    public val activeUserSessions: kotlin.Int? = builder.activeUserSessions
    /**
     * The total number of session slots that are available for streaming or are currently streaming.
     *
     * ActualUserSessionCapacity = AvailableUserSessionCapacity + ActiveUserSessions
     *
     * This only applies to multi-session fleets.
     */
    public val actualUserSessions: kotlin.Int? = builder.actualUserSessions
    /**
     * The number of currently available instances that can be used to stream sessions.
     */
    public val available: kotlin.Int? = builder.available
    /**
     * The number of idle session slots currently available for user sessions.
     *
     * AvailableUserSessionCapacity = ActualUserSessionCapacity - ActiveUserSessions
     *
     * This only applies to multi-session fleets.
     */
    public val availableUserSessions: kotlin.Int? = builder.availableUserSessions
    /**
     * The desired number of streaming instances.
     */
    public val desired: kotlin.Int? = builder.desired
    /**
     * The total number of sessions slots that are either running or pending. This represents the total number of concurrent streaming sessions your fleet can support in a steady state.
     *
     * DesiredUserSessionCapacity = ActualUserSessionCapacity + PendingUserSessionCapacity
     *
     * This only applies to multi-session fleets.
     */
    public val desiredUserSessions: kotlin.Int? = builder.desiredUserSessions
    /**
     * The number of instances in use for streaming.
     */
    public val inUse: kotlin.Int? = builder.inUse
    /**
     * The total number of simultaneous streaming instances that are running.
     */
    public val running: kotlin.Int? = builder.running

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appstream.model.ComputeCapacityStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ComputeCapacityStatus(")
        append("activeUserSessions=$activeUserSessions,")
        append("actualUserSessions=$actualUserSessions,")
        append("available=$available,")
        append("availableUserSessions=$availableUserSessions,")
        append("desired=$desired,")
        append("desiredUserSessions=$desiredUserSessions,")
        append("inUse=$inUse,")
        append("running=$running")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeUserSessions ?: 0
        result = 31 * result + (actualUserSessions ?: 0)
        result = 31 * result + (available ?: 0)
        result = 31 * result + (availableUserSessions ?: 0)
        result = 31 * result + (desired ?: 0)
        result = 31 * result + (desiredUserSessions ?: 0)
        result = 31 * result + (inUse ?: 0)
        result = 31 * result + (running ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ComputeCapacityStatus

        if (activeUserSessions != other.activeUserSessions) return false
        if (actualUserSessions != other.actualUserSessions) return false
        if (available != other.available) return false
        if (availableUserSessions != other.availableUserSessions) return false
        if (desired != other.desired) return false
        if (desiredUserSessions != other.desiredUserSessions) return false
        if (inUse != other.inUse) return false
        if (running != other.running) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appstream.model.ComputeCapacityStatus = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of user sessions currently being used for streaming sessions. This only applies to multi-session fleets.
         */
        public var activeUserSessions: kotlin.Int? = null
        /**
         * The total number of session slots that are available for streaming or are currently streaming.
         *
         * ActualUserSessionCapacity = AvailableUserSessionCapacity + ActiveUserSessions
         *
         * This only applies to multi-session fleets.
         */
        public var actualUserSessions: kotlin.Int? = null
        /**
         * The number of currently available instances that can be used to stream sessions.
         */
        public var available: kotlin.Int? = null
        /**
         * The number of idle session slots currently available for user sessions.
         *
         * AvailableUserSessionCapacity = ActualUserSessionCapacity - ActiveUserSessions
         *
         * This only applies to multi-session fleets.
         */
        public var availableUserSessions: kotlin.Int? = null
        /**
         * The desired number of streaming instances.
         */
        public var desired: kotlin.Int? = null
        /**
         * The total number of sessions slots that are either running or pending. This represents the total number of concurrent streaming sessions your fleet can support in a steady state.
         *
         * DesiredUserSessionCapacity = ActualUserSessionCapacity + PendingUserSessionCapacity
         *
         * This only applies to multi-session fleets.
         */
        public var desiredUserSessions: kotlin.Int? = null
        /**
         * The number of instances in use for streaming.
         */
        public var inUse: kotlin.Int? = null
        /**
         * The total number of simultaneous streaming instances that are running.
         */
        public var running: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appstream.model.ComputeCapacityStatus) : this() {
            this.activeUserSessions = x.activeUserSessions
            this.actualUserSessions = x.actualUserSessions
            this.available = x.available
            this.availableUserSessions = x.availableUserSessions
            this.desired = x.desired
            this.desiredUserSessions = x.desiredUserSessions
            this.inUse = x.inUse
            this.running = x.running
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appstream.model.ComputeCapacityStatus = ComputeCapacityStatus(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
