// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the persistent application settings for users of a stack.
 */
public class ApplicationSettingsResponse private constructor(builder: Builder) {
    /**
     * Specifies whether persistent application settings are enabled for users during their streaming sessions.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The S3 bucket where users’ persistent application settings are stored. When persistent application settings are enabled for the first time for an account in an AWS Region, an S3 bucket is created. The bucket is unique to the AWS account and the Region.
     */
    public val s3BucketName: kotlin.String? = builder.s3BucketName
    /**
     * The path prefix for the S3 bucket where users’ persistent application settings are stored.
     */
    public val settingsGroup: kotlin.String? = builder.settingsGroup

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appstream.model.ApplicationSettingsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApplicationSettingsResponse(")
        append("enabled=$enabled,")
        append("s3BucketName=$s3BucketName,")
        append("settingsGroup=$settingsGroup")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (s3BucketName?.hashCode() ?: 0)
        result = 31 * result + (settingsGroup?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApplicationSettingsResponse

        if (enabled != other.enabled) return false
        if (s3BucketName != other.s3BucketName) return false
        if (settingsGroup != other.settingsGroup) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appstream.model.ApplicationSettingsResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether persistent application settings are enabled for users during their streaming sessions.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The S3 bucket where users’ persistent application settings are stored. When persistent application settings are enabled for the first time for an account in an AWS Region, an S3 bucket is created. The bucket is unique to the AWS account and the Region.
         */
        public var s3BucketName: kotlin.String? = null
        /**
         * The path prefix for the S3 bucket where users’ persistent application settings are stored.
         */
        public var settingsGroup: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appstream.model.ApplicationSettingsResponse) : this() {
            this.enabled = x.enabled
            this.s3BucketName = x.s3BucketName
            this.settingsGroup = x.settingsGroup
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appstream.model.ApplicationSettingsResponse = ApplicationSettingsResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
