// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.paginators

import aws.sdk.kotlin.services.appstream.AppStreamClient
import aws.sdk.kotlin.services.appstream.model.DescribeAppBlockBuilderAppBlockAssociationsRequest
import aws.sdk.kotlin.services.appstream.model.DescribeAppBlockBuilderAppBlockAssociationsResponse
import aws.sdk.kotlin.services.appstream.model.DescribeAppBlockBuildersRequest
import aws.sdk.kotlin.services.appstream.model.DescribeAppBlockBuildersResponse
import aws.sdk.kotlin.services.appstream.model.DescribeImagePermissionsRequest
import aws.sdk.kotlin.services.appstream.model.DescribeImagePermissionsResponse
import aws.sdk.kotlin.services.appstream.model.DescribeImagesRequest
import aws.sdk.kotlin.services.appstream.model.DescribeImagesResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [DescribeAppBlockBuilderAppBlockAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeAppBlockBuilderAppBlockAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAppBlockBuilderAppBlockAssociationsResponse]
 */
public fun AppStreamClient.describeAppBlockBuilderAppBlockAssociationsPaginated(initialRequest: DescribeAppBlockBuilderAppBlockAssociationsRequest = DescribeAppBlockBuilderAppBlockAssociationsRequest { }): Flow<DescribeAppBlockBuilderAppBlockAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeAppBlockBuilderAppBlockAssociationsPaginated.describeAppBlockBuilderAppBlockAssociations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeAppBlockBuilderAppBlockAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAppBlockBuilderAppBlockAssociationsResponse]
 */
public fun AppStreamClient.describeAppBlockBuilderAppBlockAssociationsPaginated(block: DescribeAppBlockBuilderAppBlockAssociationsRequest.Builder.() -> Unit): Flow<DescribeAppBlockBuilderAppBlockAssociationsResponse> =
    describeAppBlockBuilderAppBlockAssociationsPaginated(DescribeAppBlockBuilderAppBlockAssociationsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeAppBlockBuildersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeAppBlockBuildersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAppBlockBuildersResponse]
 */
public fun AppStreamClient.describeAppBlockBuildersPaginated(initialRequest: DescribeAppBlockBuildersRequest = DescribeAppBlockBuildersRequest { }): Flow<DescribeAppBlockBuildersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeAppBlockBuildersPaginated.describeAppBlockBuilders(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeAppBlockBuildersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAppBlockBuildersResponse]
 */
public fun AppStreamClient.describeAppBlockBuildersPaginated(block: DescribeAppBlockBuildersRequest.Builder.() -> Unit): Flow<DescribeAppBlockBuildersResponse> =
    describeAppBlockBuildersPaginated(DescribeAppBlockBuildersRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeImagePermissionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeImagePermissionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeImagePermissionsResponse]
 */
public fun AppStreamClient.describeImagePermissionsPaginated(initialRequest: DescribeImagePermissionsRequest): Flow<DescribeImagePermissionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeImagePermissionsPaginated.describeImagePermissions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeImagePermissionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeImagePermissionsResponse]
 */
public fun AppStreamClient.describeImagePermissionsPaginated(block: DescribeImagePermissionsRequest.Builder.() -> Unit): Flow<DescribeImagePermissionsResponse> =
    describeImagePermissionsPaginated(DescribeImagePermissionsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeImagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeImagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeImagesResponse]
 */
public fun AppStreamClient.describeImagesPaginated(initialRequest: DescribeImagesRequest = DescribeImagesRequest { }): Flow<DescribeImagesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeImagesPaginated.describeImages(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeImagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeImagesResponse]
 */
public fun AppStreamClient.describeImagesPaginated(block: DescribeImagesRequest.Builder.() -> Unit): Flow<DescribeImagesResponse> =
    describeImagesPaginated(DescribeImagesRequest.Builder().apply(block).build())
