// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes VPC configuration information for fleets and image builders.
 */
public class VpcConfig private constructor(builder: Builder) {
    /**
     * The identifiers of the security groups for the fleet or image builder.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The identifiers of the subnets to which a network interface is attached from the fleet instance or image builder instance. Fleet instances use one or more subnets. Image builder instances use one subnet.
     */
    public val subnetIds: List<String>? = builder.subnetIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appstream.model.VpcConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcConfig(")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetIds=$subnetIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = securityGroupIds?.hashCode() ?: 0
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcConfig

        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetIds != other.subnetIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appstream.model.VpcConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifiers of the security groups for the fleet or image builder.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The identifiers of the subnets to which a network interface is attached from the fleet instance or image builder instance. Fleet instances use one or more subnets. Image builder instances use one subnet.
         */
        public var subnetIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appstream.model.VpcConfig) : this() {
            this.securityGroupIds = x.securityGroupIds
            this.subnetIds = x.subnetIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appstream.model.VpcConfig = VpcConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
