// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.serde

import aws.sdk.kotlin.services.appstream.model.CreateAppBlockRequest
import aws.sdk.kotlin.services.appstream.model.PackagingType
import aws.sdk.kotlin.services.appstream.model.S3Location
import aws.sdk.kotlin.services.appstream.model.ScriptDetails
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateAppBlockOperationSerializer: HttpSerializer.NonStreaming<CreateAppBlockRequest> {
    override fun serialize(context: ExecutionContext, input: CreateAppBlockRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeCreateAppBlockOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeCreateAppBlockOperationBody(context: ExecutionContext, input: CreateAppBlockRequest): ByteArray {
    val serializer = JsonSerializer()
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val DISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DisplayName"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val PACKAGINGTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("PackagingType"))
    val POSTSETUPSCRIPTDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("PostSetupScriptDetails"))
    val SETUPSCRIPTDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SetupScriptDetails"))
    val SOURCES3LOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SourceS3Location"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(DISPLAYNAME_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PACKAGINGTYPE_DESCRIPTOR)
        field(POSTSETUPSCRIPTDETAILS_DESCRIPTOR)
        field(SETUPSCRIPTDETAILS_DESCRIPTOR)
        field(SOURCES3LOCATION_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.displayName?.let { field(DISPLAYNAME_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.packagingType?.let { field(PACKAGINGTYPE_DESCRIPTOR, it.value) }
        input.postSetupScriptDetails?.let { field(POSTSETUPSCRIPTDETAILS_DESCRIPTOR, it, ::serializeScriptDetailsDocument) }
        input.setupScriptDetails?.let { field(SETUPSCRIPTDETAILS_DESCRIPTOR, it, ::serializeScriptDetailsDocument) }
        input.sourceS3Location?.let { field(SOURCES3LOCATION_DESCRIPTOR, it, ::serializeS3LocationDocument) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
    }
    return serializer.toByteArray()
}
